/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph;

import java.util.Objects;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.datatypes.xsd.impl.RDFDirLangString;
import org.apache.jena.datatypes.xsd.impl.RDFLangString;
import org.apache.jena.graph.BlankNodeId;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Node_Blank;
import org.apache.jena.graph.Node_Graph;
import org.apache.jena.graph.Node_Literal;
import org.apache.jena.graph.Node_Marker;
import org.apache.jena.graph.Node_Triple;
import org.apache.jena.graph.Node_URI;
import org.apache.jena.graph.Node_Variable;
import org.apache.jena.graph.TextDirection;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.graph.impl.LiteralLabelFactory;
import org.apache.jena.graph.langtag.LangTags;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sys.JenaSystem;

public class NodeFactory {
    static final boolean legacyLangTag = false;

    private NodeFactory() {
    }

    public static RDFDatatype getType(String s) {
        if (s == null) {
            return null;
        }
        return TypeMapper.getInstance().getSafeTypeByName(s);
    }

    public static Node createBlankNode() {
        return NodeFactory.createBlankNode(BlankNodeId.createFreshId());
    }

    public static Node createBlankNode(String string) {
        return new Node_Blank(string);
    }

    public static Node createURI(String uri) {
        Objects.requireNonNull(uri, "Argument to NodeFactory.createURI is null");
        return new Node_URI(uri);
    }

    public static Node createVariable(String name) {
        Objects.requireNonNull(name, "Argument to NodeFactory.createVariable is null");
        return new Node_Variable(name);
    }

    public static Node createExt(String name) {
        Objects.requireNonNull(name, "Argument to NodeFactory.createExt is null");
        return new Node_Marker(name);
    }

    @Deprecated
    public static Node createLiteral(LiteralLabel lit) {
        Objects.requireNonNull(lit, "Argument to NodeFactory.createLiteral is null");
        return new Node_Literal(lit);
    }

    @Deprecated(forRemoval=true)
    public static Node createLiteral(String string) {
        return NodeFactory.createLiteralString(string);
    }

    public static Node createLiteralString(String string) {
        Objects.requireNonNull(string, "Argument to NodeFactory.createLiteralString is null");
        return new Node_Literal(string);
    }

    @Deprecated
    public static Node createLiteral(String string, String lang) {
        return NodeFactory.createLiteralLang(string, lang);
    }

    public static Node createLiteralLang(String string, String lang) {
        Objects.requireNonNull(string, "null lexical form for literal");
        if (Lib.isEmpty(lang)) {
            return new Node_Literal(string);
        }
        String langFmt = NodeFactory.formatLanguageTag(lang);
        return new Node_Literal(string, langFmt);
    }

    public static Node createLiteralDirLang(String string, String lang, String textDir) {
        TextDirection textDirEnum = NodeFactory.initialTextDirection(textDir);
        String langFmt = NodeFactory.formatLanguageTag(lang);
        return NodeFactory.createLiteralDirLang(string, langFmt, textDirEnum);
    }

    private static boolean noTextDir(TextDirection textDir) {
        return textDir == Node.noTextDirection;
    }

    public static Node createLiteralDirLang(String string, String lang, TextDirection textDir) {
        Objects.requireNonNull(string, "null lexical form for literal");
        if (Lib.isEmpty(lang)) {
            if (textDir != null) {
                throw new JenaException("The language must be gived for a language direction literal");
            }
            return new Node_Literal(string);
        }
        if (NodeFactory.noTextDir(textDir)) {
            return new Node_Literal(string, lang);
        }
        String langFmt = NodeFactory.formatLanguageTag(lang);
        return new Node_Literal(string, langFmt, textDir);
    }

    public static Node createLiteral(String lex, String lang, RDFDatatype dtype) {
        return NodeFactory.createLiteral(lex, lang, Node.noTextDirection, dtype);
    }

    public static Node createLiteral(String lex, String lang, String textDir, RDFDatatype dtype) {
        TextDirection textDirEnum = NodeFactory.initialTextDirection(textDir);
        return NodeFactory.createLiteral(lex, lang, textDirEnum, dtype);
    }

    public static Node createLiteral(String lex, String lang, TextDirection textDir, RDFDatatype dtype) {
        boolean hasTextDirLang;
        boolean hasLang;
        Objects.requireNonNull(lex, "null lexical form for literal");
        boolean bl = hasLang = !Lib.isEmpty(lang);
        if (hasLang) {
            String langFmt = NodeFactory.formatLanguageTag(lang);
            if (dtype != null) {
                if (NodeFactory.noTextDir(textDir)) {
                    if (!dtype.equals(RDFLangString.rdfLangString)) {
                        throw new JenaException("Datatype is not rdf:langString but a language was given");
                    }
                } else if (!dtype.equals(RDFDirLangString.rdfDirLangString)) {
                    throw new JenaException("Datatype is not rdf:dirLangString but a language and initial text direction was given");
                }
            }
            return NodeFactory.createLiteralDirLang(lex, langFmt, textDir);
        }
        if (dtype == null) {
            return NodeFactory.createLiteralString(lex);
        }
        boolean bl2 = hasTextDirLang = textDir != null;
        if (hasTextDirLang) {
            if (dtype.equals(RDFDirLangString.rdfDirLangString)) {
                throw new JenaException("Datatype is rdf:dirLangString and has an initial text direction but no language given");
            }
            if (dtype.equals(RDFLangString.rdfLangString)) {
                throw new JenaException("Datatype is rdf:langString and has an initial text direction but no language given");
            }
        }
        Node n = NodeFactory.createLiteralDT(lex, dtype);
        return n;
    }

    private static String formatLanguageTag(String langTagStr) {
        if (langTagStr == null) {
            return "";
        }
        if (langTagStr.isEmpty()) {
            return langTagStr;
        }
        return LangTags.basicFormat(langTagStr);
    }

    private static TextDirection initialTextDirection(String input) {
        if (Lib.isEmpty(input)) {
            return Node.noTextDirection;
        }
        TextDirection textDir = TextDirection.create(input);
        return textDir;
    }

    @Deprecated
    public static Node createLiteral(String lex, RDFDatatype dtype) {
        return NodeFactory.createLiteralDT(lex, dtype);
    }

    public static Node createLiteralDT(String lex, RDFDatatype dtype) {
        Objects.requireNonNull(lex, "null lexical form for literal");
        if (dtype == null) {
            dtype = XSDDatatype.XSDstring;
        }
        return new Node_Literal(lex, dtype);
    }

    public static Node createLiteralByValue(Object value) {
        Objects.requireNonNull(value, "Argument 'value' to NodeFactory.createLiteralByValue is null");
        return new Node_Literal(LiteralLabelFactory.createByValue(value));
    }

    public static Node createLiteralByValue(Object value, RDFDatatype dtype) {
        Objects.requireNonNull(value, "Argument 'value' to NodeFactory.createLiteralByValue is null");
        return new Node_Literal(LiteralLabelFactory.createByValue(value, dtype));
    }

    public static Node createTripleNode(Node s, Node p, Node o) {
        Triple triple = Triple.create(s, p, o);
        return NodeFactory.createTripleNode(triple);
    }

    public static Node createTripleNode(Triple triple) {
        return new Node_Triple(triple);
    }

    public static Node createGraphNode(Graph graph) {
        return new Node_Graph(graph);
    }

    static {
        JenaSystem.init();
    }
}

