/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.trans.bplustree;

import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.Alg;
import org.apache.jena.dboe.base.StorageException;
import org.apache.jena.dboe.base.block.Block;
import org.apache.jena.dboe.base.block.BlockMgr;
import org.apache.jena.dboe.base.buffer.RecordBuffer;
import org.apache.jena.dboe.base.record.Record;
import org.apache.jena.dboe.base.recordbuffer.RecordBufferPage;
import org.apache.jena.dboe.trans.bplustree.AccessPath;
import org.apache.jena.dboe.trans.bplustree.BPT;
import org.apache.jena.dboe.trans.bplustree.BPTreeException;
import org.apache.jena.dboe.trans.bplustree.BPTreePage;
import org.apache.jena.dboe.trans.bplustree.BPTreeRecordsMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BPTreeRecords
extends BPTreePage {
    private static Logger log = LoggerFactory.getLogger(BPTreeRecords.class);
    private final RecordBufferPage rBuffPage;
    private final BPTreeRecordsMgr bprRecordsMgr;
    private RecordBuffer rBuff;

    @Override
    protected Logger getLogger() {
        return log;
    }

    BPTreeRecords(BPTreeRecordsMgr mgr, RecordBufferPage rbp) {
        super(mgr.getBPTree());
        this.bprRecordsMgr = mgr;
        this.rBuffPage = rbp;
        this.rBuff = this.rBuffPage.getRecordBuffer();
    }

    RecordBufferPage getRecordBufferPage() {
        return this.rBuffPage;
    }

    RecordBuffer getRecordBuffer() {
        return this.rBuff;
    }

    public final Record get(int idx) {
        return this.rBuff.get(idx);
    }

    @Override
    public final Block getBackingBlock() {
        return this.rBuffPage.getBackingBlock();
    }

    @Override
    public BlockMgr getBlockMgr() {
        return this.bpTree.getRecordsMgr().getBlockMgr();
    }

    @Override
    public void reset(Block block) {
        this.rBuffPage.reset(block);
        this.rBuff = this.rBuffPage.getRecordBuffer();
    }

    int getLink() {
        return this.rBuffPage.getLink();
    }

    @Override
    public boolean isFull() {
        return this.rBuff.size() >= this.rBuff.maxSize();
    }

    @Override
    public boolean hasAnyKeys() {
        return this.rBuff.size() > 0;
    }

    @Override
    public boolean isMinSize() {
        return this.rBuff.size() <= this.rBuff.maxSize() / 2;
    }

    @Override
    Record internalSearch(AccessPath path, Record rec) {
        int i = this.rBuff.find(rec);
        if (i < 0) {
            return null;
        }
        return this.rBuff.get(i);
    }

    @Override
    public final void write() {
        this.bprRecordsMgr.write(this);
    }

    @Override
    final boolean promote() {
        boolean promoteInPlace;
        if (this.bprRecordsMgr.isWritable(this.getId())) {
            return false;
        }
        boolean bl = promoteInPlace = this.bpTree == null ? true : this.bpTree.state().modifiableRecordsBlock(this.getId());
        if (promoteInPlace) {
            this.bprRecordsMgr.promoteInPlace(this);
            if (this.getBackingBlock().isReadOnly()) {
                this.bprRecordsMgr.getBlockMgr().promote(this.getBackingBlock());
            }
            return false;
        }
        Block oldBlock = this.getBackingBlock();
        boolean b = this.bprRecordsMgr.promoteDuplicate(this);
        if (b) {
            this.bprRecordsMgr.getBlockMgr().release(oldBlock);
        }
        return b;
    }

    @Override
    public final void release() {
        this.bprRecordsMgr.release(this);
    }

    @Override
    public final void free() {
        this.bprRecordsMgr.free(this);
    }

    @Override
    Record internalInsert(AccessPath path, Record record) {
        int i = this.rBuff.find(record);
        Record r2 = null;
        if (i < 0) {
            i = Alg.decodeIndex(i);
            if (this.rBuff.size() >= this.rBuff.maxSize()) {
                throw new StorageException("RecordBlock.put overflow");
            }
            BPT.promotePage(path, this);
            this.rBuff.add(i, record);
        } else {
            r2 = this.rBuff.get(i);
            if (Record.compareByKeyValue(record, r2) != 0) {
                BPT.promotePage(path, this);
                this.rBuff.set(i, record);
            } else {
                return r2;
            }
        }
        this.write();
        return r2;
    }

    @Override
    Record internalDelete(AccessPath path, Record record) {
        int i = this.rBuff.find(record);
        if (i < 0) {
            return null;
        }
        BPT.promotePage(path, this);
        Record r2 = this.rBuff.get(i);
        this.rBuff.remove(i);
        this.write();
        return r2;
    }

    @Override
    public Record getSplitKey() {
        int splitIdx = this.rBuff.size() / 2 - 1;
        Record r = this.rBuff.get(splitIdx);
        return r;
    }

    @Override
    public BPTreePage split() {
        BPTreeRecords other = this.insertNewPage();
        int splitIdx = this.rBuff.size() / 2 - 1;
        Record r = BPT.CheckingNode ? this.rBuff.get(splitIdx) : null;
        int moveLen = this.rBuff.size() - (splitIdx + 1);
        this.rBuff.copy(splitIdx + 1, other.getRecordBufferPage().getRecordBuffer(), 0, moveLen);
        this.rBuff.clear(splitIdx + 1, moveLen);
        this.rBuff.setSize(splitIdx + 1);
        if (BPT.CheckingNode && !Record.keyEQ(r, this.maxRecord())) {
            BPTreeRecords.error("id=%d : BPTreeRecords.split: Not returning expected record (actual=%s expected=%s)", this.getId(), r, this.maxRecord());
        }
        return other;
    }

    private BPTreeRecords insertNewPage() {
        BPTreeRecords other = this.create(-1);
        this.rBuffPage.setLink(-1);
        return other;
    }

    private BPTreeRecords create(int linkId) {
        BPTreeRecords newPage = this.bprRecordsMgr.create();
        newPage.getRecordBufferPage().setLink(linkId);
        return newPage;
    }

    @Override
    public Record shiftRight(BPTreePage other, Record splitKey) {
        BPTreeRecords page = BPTreeRecords.cast(other);
        this.rBuff.shiftRight(page.rBuff);
        if (this.rBuff.size() == 0) {
            return null;
        }
        return this.rBuff.getHigh();
    }

    @Override
    public Record shiftLeft(BPTreePage other, Record splitKey) {
        BPTreeRecords page = BPTreeRecords.cast(other);
        this.rBuff.shiftLeft(page.rBuff);
        if (this.rBuff.size() == 0) {
            return null;
        }
        return this.rBuff.getHigh();
    }

    @Override
    BPTreePage merge(BPTreePage right, Record splitKey) {
        return BPTreeRecords.merge(this, BPTreeRecords.cast(right));
    }

    private static BPTreeRecords merge(BPTreeRecords left, BPTreeRecords right) {
        right.rBuff.copyToTop(left.rBuff);
        right.rBuff.clear();
        left.rBuffPage.setLink(right.rBuffPage.getLink());
        return left;
    }

    private static BPTreeRecords cast(BPTreePage page) {
        try {
            return (BPTreeRecords)page;
        }
        catch (ClassCastException ex) {
            BPTreeRecords.error("Wrong type: " + page, new Object[0]);
            return null;
        }
    }

    @Override
    public final Record internalMinRecord(AccessPath path) {
        return this.getLowRecord();
    }

    @Override
    public final Record internalMaxRecord(AccessPath path) {
        return this.getHighRecord();
    }

    private static void error(String msg, Object ... args) {
        msg = String.format(msg, args);
        System.out.println(msg);
        System.out.flush();
        throw new BPTreeException(msg);
    }

    @Override
    public final Record getLowRecord() {
        if (this.rBuff.size() == 0) {
            return null;
        }
        return this.rBuff.getLow();
    }

    @Override
    public final Record getHighRecord() {
        if (this.rBuff.size() == 0) {
            return null;
        }
        return this.rBuff.getHigh();
    }

    @Override
    public final int getMaxSize() {
        return this.rBuff.maxSize();
    }

    @Override
    public final int getCount() {
        return this.rBuff.size();
    }

    @Override
    public final void setCount(int count) {
        this.rBuff.setSize(count);
    }

    public String toString() {
        if (BPT.CheckingNode) {
            this.checkNode();
        }
        Record min2 = this.rBuff.getLow();
        Record max2 = this.rBuff.getHigh();
        return String.format("BPTreeRecords[id=%d, count=%d, link=%d]: %s ... %s", this.getId(), this.rBuff.getSize(), this.getLink(), min2, max2);
    }

    @Override
    protected String typeMark() {
        return "Data";
    }

    @Override
    public final void checkNode() {
        if (!BPT.CheckingNode) {
            return;
        }
        if (this.rBuff.size() < 0 || this.rBuff.size() > this.rBuff.maxSize()) {
            BPTreeRecords.error("Mis-sized: %s", this);
        }
        for (int i = 1; i < this.getCount(); ++i) {
            Record r2;
            Record r1 = this.rBuff.get(i - 1);
            if (!Record.keyGT(r1, r2 = this.rBuff.get(i))) continue;
            BPTreeRecords.error("Not sorted: %s", this);
        }
    }

    @Override
    public final void checkNodeDeep() {
        this.checkNode();
    }

    @Override
    public int getId() {
        return this.rBuffPage.getId();
    }

    @Override
    public String getRefStr() {
        return String.format("BPTRecord[id=%d]", this.getBackingBlock().getId());
    }

    @Override
    public void output(IndentedWriter out) {
        out.print(this.toString());
    }
}

