/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.ui;

import org.eclipse.embedcdt.core.EclipseUtils;
import org.eclipse.embedcdt.internal.ui.Activator;
import org.eclipse.embedcdt.ui.DirectoryNotStrictFieldEditor;
import org.eclipse.swt.widgets.Composite;

public class DirectoryNotStrictVariableFieldEditor
extends DirectoryNotStrictFieldEditor {
    protected String fVariableName;
    protected String fVariableDescription;

    public DirectoryNotStrictVariableFieldEditor(String buildToolsPathKey, String variableName, String variableDescription, String toolsPaths_label, Composite fieldEditorParent, boolean isStrict) {
        super(buildToolsPathKey, toolsPaths_label, fieldEditorParent, isStrict);
        this.fVariableName = variableName;
        this.fVariableDescription = variableDescription;
    }

    protected void doLoad() {
        if (this.getTextControl() != null) {
            String value = EclipseUtils.getVariableValue((String)this.fVariableName);
            if (value == null || value.isEmpty()) {
                value = this.getPreferenceStore().getString(this.getPreferenceName());
                if (Activator.getInstance().isDebugging()) {
                    System.out.println("DirectoryNotStrictVariableFieldEditor.doLoad() got \"" + value + "\"");
                }
                this.setPresentsDefaultValue(false);
            }
            this.getTextControl().setText(value);
            this.oldValue = value;
        }
    }

    protected void doStore() {
        String value = this.getTextControl().getText();
        EclipseUtils.setVariableValue((String)this.fVariableName, (String)this.fVariableDescription, (String)value);
        super.doStore();
    }
}

