/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.common.impl;

import com.sun.ts.tests.websocket.common.impl.ExtensionParameterImpl;
import jakarta.websocket.Extension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ExtensionImpl
implements Extension,
Comparable<Extension> {
    protected List<Extension.Parameter> list = new ArrayList<Extension.Parameter>();
    protected String name;
    protected boolean caseSensitive = false;

    public void caseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public ExtensionImpl(String name, Extension.Parameter ... params) {
        this.name = name;
        this.addParameters(params);
    }

    public ExtensionImpl(Extension extension) {
        this(extension.getName(), extension.getParameters().toArray(new Extension.Parameter[0]));
    }

    public void addParameters(Extension.Parameter ... params) {
        if (params != null) {
            for (Extension.Parameter param : params) {
                this.list.add(param);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public List<Extension.Parameter> getParameters() {
        return this.list;
    }

    @Override
    public int compareTo(Extension o) {
        int cmp;
        int n = cmp = this.caseSensitive ? this.name.compareTo(o.getName()) : this.name.compareToIgnoreCase(o.getName());
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.getParameters().size() - o.getParameters().size();
        if (cmp != 0) {
            return (int)Math.signum(cmp);
        }
        List<ExtensionParameterImpl> newThisList = this.getExtensionParameters(this);
        List<ExtensionParameterImpl> newOtherList = this.getExtensionParameters(o);
        Collections.sort(newThisList);
        Collections.sort(newOtherList);
        Iterator<ExtensionParameterImpl> i = newThisList.iterator();
        Iterator<ExtensionParameterImpl> j = newOtherList.iterator();
        while (i.hasNext() && cmp == 0) {
            ExtensionParameterImpl iItem = i.next();
            ExtensionParameterImpl jItem = j.next();
            cmp = iItem.compareTo(jItem);
        }
        return cmp;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Extension) {
            return this.compareTo((Extension)obj) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append(this.getClass().getSimpleName()).append("(name=\"").append(this.name).append("\", parameters=[");
        for (Extension.Parameter parameter : this.getExtensionParameters(this)) {
            sb.append(parameter.toString()).append(",");
        }
        sb.append("])");
        return sb.toString();
    }

    public List<ExtensionParameterImpl> getExtensionParameters(Extension extension) {
        ArrayList<ExtensionParameterImpl> params = new ArrayList<ExtensionParameterImpl>();
        for (Extension.Parameter item : extension.getParameters()) {
            params.add(new ExtensionParameterImpl(item, this.caseSensitive));
        }
        Collections.sort(params);
        return params;
    }

    public static List<ExtensionImpl> transformToImpl(List<? extends Extension> extensions) {
        ArrayList<ExtensionImpl> list = new ArrayList<ExtensionImpl>();
        if (extensions != null) {
            for (Extension extension : extensions) {
                list.add(new ExtensionImpl(extension));
            }
        }
        return list;
    }

    public static String toString(List<? extends Extension> list) {
        StringBuilder sb = new StringBuilder().append("{");
        if (list != null) {
            for (Extension extension : list) {
                sb.append(extension.toString()).append(";");
            }
        }
        sb.append("}");
        return sb.toString();
    }
}

