/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.StoredProcedureQuery;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.core.StoredProcedureQuery.Client;
import ee.jakarta.tck.persistence.core.StoredProcedureQuery.Employee;
import jakarta.persistence.Parameter;
import jakarta.persistence.ParameterMode;
import jakarta.persistence.StoredProcedureQuery;
import jakarta.persistence.TemporalType;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;

public class Client2
extends Client {
    public static void main(String[] args) {
        Client2 theTests = new Client2();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createEmployee2TestData();
            this.dataBaseName = p.getProperty("jdbc.db");
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Override
    public List<List> getResultSetsFromStoredProcedure(StoredProcedureQuery spq) {
        this.logTrace("in getResultSetsFromStoredProcedure");
        boolean results = true;
        ArrayList<List> listOfList = new ArrayList<List>();
        int rsnum = 1;
        int rowsAffected = 0;
        do {
            if (results) {
                this.logTrace("Processing set:" + rsnum);
                ArrayList<Employee> empList = new ArrayList<Employee>();
                List list = spq.getResultList();
                if (list != null) {
                    this.logTrace("Getting result set: " + rsnum + ", size:" + list.size());
                    for (Object o : list) {
                        if (o instanceof Employee) {
                            Employee e = (Employee)o;
                            this.logTrace("Saving:" + e);
                            empList.add(e);
                            continue;
                        }
                        this.logErr("Did not get instance of Employee, instead got:" + o.getClass().getSimpleName());
                    }
                    if (empList.size() > 0) {
                        listOfList.add(empList);
                    }
                } else {
                    this.logErr("Result set[" + rsnum + "] returned was null");
                }
                ++rsnum;
            } else {
                rowsAffected = spq.getUpdateCount();
                if (rowsAffected >= 0) {
                    this.logTrace("rowsAffected:" + rowsAffected);
                }
            }
            results = spq.hasMoreResults();
            this.logTrace("Results:" + results);
        } while (results || rowsAffected != -1);
        return listOfList;
    }

    @Override
    public boolean verifyEmployeeIds(List<Integer> expected, List<List> listOfList) {
        boolean result = false;
        int count = 0;
        for (List lEmp : listOfList) {
            if (lEmp.size() > 0) {
                ArrayList<Integer> actual = new ArrayList<Integer>();
                for (Employee employee : lEmp) {
                    actual.add(employee.getId());
                }
                if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                    this.logTrace("Received expected result:");
                    for (Integer n : actual) {
                        this.logTrace("id:" + n);
                    }
                    ++count;
                    continue;
                }
                this.logErr("Did not receive expected result:");
                for (Integer n : expected) {
                    this.logErr(" Expected id:" + n);
                }
                for (Integer n : actual) {
                    this.logErr("Actual id:" + n);
                }
                continue;
            }
            this.logErr("Result set that was returned had 0 length");
        }
        if (count == listOfList.size()) {
            result = true;
        }
        return result;
    }

    @Override
    public boolean verifyListOfListEmployees(List<Employee> expected, List<List> listOfList) {
        boolean result = false;
        int count = 0;
        for (List lEmp : listOfList) {
            if (lEmp.size() > 0) {
                ArrayList<Employee> actual = new ArrayList<Employee>();
                for (Employee e : lEmp) {
                    actual.add(e);
                }
                if (!this.verifyListEmployees(expected, actual)) continue;
                ++count;
                continue;
            }
            this.logErr("Result set that was returned had 0 length");
        }
        if (count == listOfList.size()) {
            result = true;
        }
        return result;
    }

    @Override
    public boolean verifyListEmployees(List<Employee> expected, List<Employee> actual) {
        boolean result = false;
        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
            for (Employee e : expected) {
                this.logTrace("Received expected result:" + e);
            }
            result = true;
        } else {
            this.logErr("Did not receive expected result:");
            for (Employee e : expected) {
                this.logErr("expected employee:" + e);
            }
            for (Employee e : actual) {
                this.logErr("actual employee :" + e);
            }
        }
        return result;
    }

    @Override
    public void setParameterIntCalendarTemporalTypeTest() throws Exception {
        boolean pass2 = false;
        boolean pass4 = false;
        try {
            this.getEntityTransaction().begin();
            try {
                this.logMsg("Testing StoredProcedureQuery object");
                StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpIdUsingHireDateFromOut");
                spq.registerStoredProcedureParameter(1, Calendar.class, ParameterMode.IN);
                spq.registerStoredProcedureParameter(2, Integer.class, ParameterMode.OUT);
                spq.setParameter(1, this.calDate, TemporalType.DATE);
                if (!spq.execute()) {
                    Object o = spq.getOutputParameterValue(2);
                    if (o instanceof Integer) {
                        int actual = (Integer)o;
                        if (actual == this.emp2.getId()) {
                            this.logTrace("Received expected id:" + actual);
                            pass2 = true;
                        } else {
                            this.logErr("Expected id: " + this.emp2.getId() + ", actual:" + actual);
                        }
                    } else {
                        this.logErr("Did not get instance of Integer back:" + o);
                    }
                } else {
                    this.logErr("Expected execute() to return false, actual: true");
                }
            }
            catch (Exception e) {
                this.logErr("Caught exception: ", e);
            }
            try {
                this.logMsg("Testing Query object");
                StoredProcedureQuery spq1 = this.getEntityManager().createStoredProcedureQuery("GetEmpIdUsingHireDateFromOut");
                spq1.registerStoredProcedureParameter(1, Calendar.class, ParameterMode.IN);
                spq1.registerStoredProcedureParameter(2, Integer.class, ParameterMode.OUT);
                StoredProcedureQuery q = spq1;
                q.setParameter(1, this.getCalDate(), TemporalType.DATE);
                StoredProcedureQuery spq2 = q;
                if (!spq2.execute()) {
                    Object o = spq2.getOutputParameterValue(2);
                    if (o instanceof Integer) {
                        int actual = (Integer)o;
                        if (actual == 5) {
                            this.logTrace("Received expected id:" + actual);
                            pass4 = true;
                        } else {
                            this.logErr("Expected id: 5, actual:" + actual);
                        }
                    } else {
                        this.logErr("Did not get instance of Integer back:" + o);
                    }
                } else {
                    this.logErr("Expected execute() to return false, actual: true");
                }
            }
            catch (Exception e) {
                this.logErr("Caught exception: ", e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass2 || !pass4) {
            throw new Exception("setParameterIntCalendarTemporalTypeTest failed");
        }
    }

    @Override
    public void setParameterIntCalendarTemporalTypeIllegalArgumentExceptionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            this.logMsg("Testing StoredProcedureQuery with incorrect position specified");
            StoredProcedureQuery spq1 = this.getEntityManager().createStoredProcedureQuery("GetEmpIdUsingHireDateFromOut");
            spq1.registerStoredProcedureParameter(1, Calendar.class, ParameterMode.IN);
            try {
                spq1.setParameter(99, this.getCalDate(), TemporalType.DATE);
                this.logErr("Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
                pass1 = true;
            }
            catch (Exception e) {
                this.logErr("Caught unexpected exception", e);
            }
            this.logMsg("Testing Query object with incorrect position specified");
            StoredProcedureQuery spq3 = this.getEntityManager().createStoredProcedureQuery("GetEmpIdUsingHireDateFromOut");
            spq3.registerStoredProcedureParameter(1, Calendar.class, ParameterMode.IN);
            StoredProcedureQuery q1 = spq3.setParameter(1, this.getCalDate(), TemporalType.DATE);
            try {
                q1.setParameter(99, (Object)this.getCalDate());
                this.logErr("Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
                pass2 = true;
            }
            catch (Exception e) {
                this.logErr("Caught unexpected exception", e);
            }
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception e) {
            this.logErr("Caught exception", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("setParameterIntCalendarTemporalTypeIllegalArgumentExceptionTest failed");
        }
    }

    @Override
    public void setParameterParameterCalendarTemporalTypeTest() throws Exception {
        boolean pass5;
        boolean pass3;
        boolean pass2;
        block20: {
            block19: {
                pass2 = false;
                pass3 = false;
                pass5 = false;
                try {
                    this.logMsg("Testing StoredProcedure");
                    this.getEntityTransaction().begin();
                    StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpIdUsingHireDateFromOut");
                    spq.registerStoredProcedureParameter(1, Calendar.class, ParameterMode.IN);
                    spq.registerStoredProcedureParameter(2, Integer.class, ParameterMode.OUT);
                    spq.setParameter(1, this.getCalDate(), TemporalType.DATE);
                    Parameter p = spq.getParameter(1);
                    spq.setParameter(p, this.calDate, TemporalType.DATE);
                    if (!spq.execute()) {
                        Object o = spq.getOutputParameterValue(2);
                        if (o instanceof Integer) {
                            int actual = (Integer)o;
                            if (actual == this.emp2.getId()) {
                                this.logTrace("Received expected id:" + actual);
                                pass2 = true;
                            } else {
                                this.logErr("Expected id: " + this.emp2.getId() + ", actual:" + actual);
                            }
                        } else {
                            this.logErr("Did not get instance of Integer back:" + o);
                        }
                    } else {
                        this.logErr("Expected execute() to return false, actual: true");
                    }
                    this.getEntityTransaction().commit();
                }
                catch (Exception e) {
                    this.logErr("Caught exception: ", e);
                    if (!this.getEntityTransaction().isActive()) break block19;
                    this.getEntityTransaction().rollback();
                }
            }
            try {
                this.getEntityTransaction().begin();
                this.logMsg("Testing Query object");
                StoredProcedureQuery spq1 = this.getEntityManager().createStoredProcedureQuery("GetEmpIdUsingHireDateFromOut");
                spq1.registerStoredProcedureParameter(1, Calendar.class, ParameterMode.IN);
                spq1.registerStoredProcedureParameter(2, Integer.class, ParameterMode.OUT);
                spq1.setParameter(1, this.getCalDate(), TemporalType.DATE);
                StoredProcedureQuery q = spq1;
                Parameter p = q.getParameter(1);
                q.setParameter(p, this.calDate, TemporalType.DATE);
                Parameter p2 = q.getParameter(1);
                if (p.getPosition().equals(p2.getPosition()) && p.getParameterType().equals(p2.getParameterType())) {
                    this.logTrace("Received expected parameter");
                    pass3 = true;
                } else {
                    this.logErr("Expected parameter:" + p + ", actual:" + p2);
                }
                StoredProcedureQuery spq2 = q;
                if (!spq2.execute()) {
                    Object o = spq2.getOutputParameterValue(2);
                    if (o instanceof Integer) {
                        int actual = (Integer)o;
                        if (actual == this.emp2.getId()) {
                            this.logTrace("Received expected id:" + actual);
                            pass5 = true;
                        } else {
                            this.logErr("Expected id: " + this.emp2.getId() + ", actual:" + actual);
                        }
                    } else {
                        this.logErr("Did not get instance of Integer back:" + o);
                    }
                } else {
                    this.logErr("Expected execute() to return false, actual: true");
                }
                this.getEntityTransaction().commit();
            }
            catch (Exception e) {
                this.logErr("Caught exception: ", e);
                if (!this.getEntityTransaction().isActive()) break block20;
                this.getEntityTransaction().rollback();
            }
        }
        if (!(pass2 && pass3 && pass5)) {
            throw new Exception("setParameterParameterCalendarTemporalTypeTest failed");
        }
    }

    @Override
    public void setParameterParameterCalendarTemporalTypeIllegalArgumentExceptionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("Get parameter from other stored procedure");
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpLastNameFromInOut");
            spq.registerStoredProcedureParameter(1, String.class, ParameterMode.INOUT);
            spq.setParameter(1, (Object)"INOUT");
            Parameter p = spq.getParameter(1);
            this.logMsg("Testing StoredProcedureQuery with parameter specified from another query");
            StoredProcedureQuery spq1 = this.getEntityManager().createStoredProcedureQuery("GetEmpIdUsingHireDateFromOut");
            spq1.registerStoredProcedureParameter(1, Calendar.class, ParameterMode.IN);
            spq1.setParameter(1, this.getCalDate(), TemporalType.DATE);
            try {
                spq1.setParameter(p, this.getCalDate(), TemporalType.DATE);
                this.logErr("Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
                pass1 = true;
            }
            catch (Exception e) {
                this.logErr("Caught unexpected exception", e);
            }
            this.logMsg("Testing Query object with parameter specified from another query");
            StoredProcedureQuery spq3 = this.getEntityManager().createStoredProcedureQuery("GetEmpIdUsingHireDateFromOut");
            spq3.registerStoredProcedureParameter(1, Calendar.class, ParameterMode.IN);
            StoredProcedureQuery q1 = spq3.setParameter(1, (Object)this.getCalDate());
            try {
                q1.setParameter(p, this.getCalDate(), TemporalType.DATE);
                this.logErr("Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
                pass2 = true;
            }
            catch (Exception e) {
                this.logErr("Caught unexpected exception", e);
            }
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception e) {
            this.logErr("Caught exception", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("setParameterParameterCalendarTemporalTypeIllegalArgumentExceptionTest failed");
        }
    }
}

