/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.transport.ListenerThreadImpl;
import com.sun.corba.ee.impl.transport.ReaderThreadImpl;
import com.sun.corba.ee.impl.transport.Timeoutable;
import com.sun.corba.ee.spi.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.threadpool.NoSuchThreadPoolException;
import com.sun.corba.ee.spi.threadpool.NoSuchWorkQueueException;
import com.sun.corba.ee.spi.threadpool.Work;
import com.sun.corba.ee.spi.trace.Transport;
import com.sun.corba.ee.spi.transport.Acceptor;
import com.sun.corba.ee.spi.transport.Connection;
import com.sun.corba.ee.spi.transport.EventHandler;
import com.sun.corba.ee.spi.transport.ListenerThread;
import com.sun.corba.ee.spi.transport.ReaderThread;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.pfl.tf.spi.annotation.InfoMethod;

@Transport
@ManagedObject
@Description(value="The Selector, which handles incoming requests to the ORB")
public class SelectorImpl
extends Thread
implements com.sun.corba.ee.spi.transport.Selector {
    private static final ORBUtilSystemException wrapper = ORBUtilSystemException.self;
    private ORB orb;
    private Timer timer;
    private Selector selector;
    private long timeout;
    private final List<EventHandler> deferredRegistrations;
    private final List<SelectionKeyAndOp> interestOpsList;
    private final Map<EventHandler, ListenerThread> listenerThreads;
    private final Map<EventHandler, ReaderThread> readerThreads;
    private boolean selectorStarted;
    private volatile boolean closed;
    private Map<EventHandler, Long> lastActivityTimers = new HashMap<EventHandler, Long>();
    private static final Timer SYSTEM_TIMER = new Timer(){

        @Override
        public long getCurrentTime() {
            return System.currentTimeMillis();
        }
    };

    public SelectorImpl(ORB orb) {
        this(orb, SYSTEM_TIMER);
    }

    SelectorImpl(ORB orb, Timer timer) {
        this.orb = orb;
        this.timer = timer;
        this.selector = null;
        this.selectorStarted = false;
        this.timeout = 60000L;
        this.deferredRegistrations = new ArrayList<EventHandler>();
        this.interestOpsList = new ArrayList<SelectionKeyAndOp>();
        this.listenerThreads = new HashMap<EventHandler, ListenerThread>();
        this.readerThreads = new HashMap<EventHandler, ReaderThread>();
        this.closed = false;
    }

    @Override
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    @ManagedAttribute
    @Description(value="The selector timeout")
    public long getTimeout() {
        return this.timeout;
    }

    @InfoMethod
    private void display(String msg, Object value) {
    }

    @InfoMethod
    private void closedEventHandler() {
    }

    @InfoMethod
    private void defaultCaseForEventHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transport
    public void registerInterestOps(EventHandler eventHandler) {
        SelectionKey selectionKey = eventHandler.getSelectionKey();
        if (selectionKey.isValid()) {
            int ehOps = eventHandler.getInterestOps();
            SelectionKeyAndOp keyAndOp = new SelectionKeyAndOp(selectionKey, ehOps);
            List<SelectionKeyAndOp> list = this.interestOpsList;
            synchronized (list) {
                this.interestOpsList.add(keyAndOp);
            }
            this.selector.wakeup();
        } else {
            wrapper.selectionKeyInvalid(eventHandler.toString());
            this.display("EventHandler SelectionKey not valid", eventHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transport
    public void registerForEvent(EventHandler eventHandler) {
        if (this.isClosed()) {
            this.closedEventHandler();
            return;
        }
        if (eventHandler.shouldUseSelectThreadToWait()) {
            List<EventHandler> list = this.deferredRegistrations;
            synchronized (list) {
                this.deferredRegistrations.add(eventHandler);
            }
            this.startSelector();
            this.selector.wakeup();
            return;
        }
        switch (eventHandler.getInterestOps()) {
            case 16: {
                this.createListenerThread(eventHandler);
                break;
            }
            case 1: {
                this.createReaderThread(eventHandler);
                break;
            }
            default: {
                this.defaultCaseForEventHandler();
                throw new RuntimeException("SelectorImpl.registerForEvent: unknown interest ops");
            }
        }
    }

    @Override
    @Transport
    public void unregisterForEvent(EventHandler eventHandler) {
        if (this.isClosed()) {
            this.closedEventHandler();
            return;
        }
        if (eventHandler.shouldUseSelectThreadToWait()) {
            SelectionKey selectionKey = eventHandler.getSelectionKey();
            if (selectionKey != null) {
                selectionKey.cancel();
                this.selector.wakeup();
            }
            return;
        }
        switch (eventHandler.getInterestOps()) {
            case 16: {
                this.destroyListenerThread(eventHandler);
                break;
            }
            case 1: {
                this.destroyReaderThread(eventHandler);
                break;
            }
            default: {
                this.defaultCaseForEventHandler();
                throw new RuntimeException("SelectorImpl.uregisterForEvent: unknown interest ops");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transport
    public void close() {
        if (this.isClosed()) {
            this.closedEventHandler();
            return;
        }
        this.setClosed(true);
        SelectorImpl selectorImpl = this;
        synchronized (selectorImpl) {
            for (ListenerThread lthread : this.listenerThreads.values()) {
                lthread.close();
            }
        }
        selectorImpl = this;
        synchronized (selectorImpl) {
            for (ReaderThread rthread : this.readerThreads.values()) {
                rthread.close();
            }
        }
        try {
            if (this.selector != null) {
                this.selector.wakeup();
            }
        }
        catch (Throwable t) {
            this.display("Exception in close", t);
        }
    }

    @InfoMethod
    private void beginSelect() {
    }

    @InfoMethod
    private void endSelect() {
    }

    @InfoMethod
    private void selectorClosed() {
    }

    @InfoMethod
    private void selectResult(boolean hasNext, int count) {
    }

    @InfoMethod
    private void skippingEventForCancelledKey() {
    }

    @Override
    @Transport
    public void run() {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                SelectorImpl.this.setName("SelectorThread");
                return null;
            }
        });
        while (!this.closed) {
            try {
                this.runSelectionLoopOnce();
            }
            catch (Throwable t) {
                this.display("Ignoring exception", t);
            }
        }
    }

    void runSelectionLoopOnce() throws IOException {
        this.beginSelect();
        int n = 0;
        this.handleDeferredRegistrations();
        this.enableInterestOps();
        try {
            n = this.selector.select(this.timeout);
        }
        catch (IOException e) {
            this.display("Exception in select:", e);
        }
        if (this.closed) {
            this.selector.close();
            this.selectorClosed();
            return;
        }
        Iterator<SelectionKey> iterator = this.selector.selectedKeys().iterator();
        this.selectResult(iterator.hasNext(), n);
        while (iterator.hasNext()) {
            SelectionKey selectionKey = iterator.next();
            iterator.remove();
            if (selectionKey.isValid()) {
                EventHandler eventHandler = (EventHandler)selectionKey.attachment();
                try {
                    eventHandler.handleEvent();
                    if (!this.lastActivityTimers.containsKey(eventHandler)) continue;
                    this.lastActivityTimers.put(eventHandler, this.timer.getCurrentTime());
                }
                catch (Throwable t) {
                    wrapper.exceptionInSelector(t, eventHandler);
                }
                continue;
            }
            wrapper.canceledSelectionKey(selectionKey);
            this.skippingEventForCancelledKey();
        }
        long currentTime = this.timer.getCurrentTime();
        for (EventHandler handler : this.lastActivityTimers.keySet()) {
            long elapsedTime = currentTime - this.lastActivityTimers.get(handler);
            ((Timeoutable)((Object)handler)).checkForTimeout(elapsedTime);
        }
        this.endSelect();
    }

    private synchronized boolean isClosed() {
        return this.closed;
    }

    private synchronized void setClosed(boolean closed) {
        this.closed = closed;
    }

    @InfoMethod
    private void selectorStarted() {
    }

    @Transport
    private synchronized void startSelector() {
        if (!this.selectorStarted) {
            this.selectorStarted();
            try {
                this.selector = Selector.open();
            }
            catch (IOException e) {
                throw new RuntimeException(".startSelector: Selector.open exception", e);
            }
            this.setDaemon(true);
            this.start();
            this.selectorStarted = true;
        }
    }

    @InfoMethod
    private void registeringEventHandler(EventHandler eh) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transport
    private void handleDeferredRegistrations() {
        List<EventHandler> list = this.deferredRegistrations;
        synchronized (list) {
            for (EventHandler eventHandler : this.deferredRegistrations) {
                this.registeringEventHandler(eventHandler);
                SelectableChannel channel = eventHandler.getChannel();
                SelectionKey selectionKey = null;
                try {
                    selectionKey = channel.register(this.selector, eventHandler.getInterestOps(), eventHandler);
                }
                catch (ClosedChannelException e) {
                    this.display("Exception", e);
                }
                eventHandler.setSelectionKey(selectionKey);
                if (!(eventHandler instanceof Timeoutable)) continue;
                this.lastActivityTimers.put(eventHandler, this.timer.getCurrentTime());
            }
            this.deferredRegistrations.clear();
        }
    }

    @InfoMethod
    private void ignoringCancelledKeyException() {
    }

    @InfoMethod
    private void keyAndOpInfo(SelectionKeyAndOp val) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transport
    private void enableInterestOps() {
        List<SelectionKeyAndOp> list = this.interestOpsList;
        synchronized (list) {
            for (SelectionKeyAndOp keyAndOp : this.interestOpsList) {
                SelectionKey selectionKey = keyAndOp.selectionKey;
                if (!selectionKey.isValid()) continue;
                this.keyAndOpInfo(keyAndOp);
                int keyOp = keyAndOp.keyOp;
                try {
                    int selectionKeyOps = selectionKey.interestOps();
                    selectionKey.interestOps(selectionKeyOps | keyOp);
                }
                catch (CancelledKeyException cke) {
                    this.ignoringCancelledKeyException();
                }
            }
            this.interestOpsList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transport
    private void createListenerThread(EventHandler eventHandler) {
        Acceptor acceptor = eventHandler.getAcceptor();
        ListenerThreadImpl listenerThread = new ListenerThreadImpl(this.orb, acceptor);
        SelectorImpl selectorImpl = this;
        synchronized (selectorImpl) {
            this.listenerThreads.put(eventHandler, listenerThread);
        }
        Throwable throwable = null;
        try {
            this.orb.getThreadPoolManager().getThreadPool(0).getWorkQueue(0).addWork((Work)listenerThread);
        }
        catch (NoSuchThreadPoolException e) {
            throwable = e;
        }
        catch (NoSuchWorkQueueException e) {
            throwable = e;
        }
        if (throwable != null) {
            throw new RuntimeException(throwable);
        }
    }

    @InfoMethod
    private void cannotFindListenerThread() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transport
    private void destroyListenerThread(EventHandler eventHandler) {
        ListenerThread listenerThread;
        SelectorImpl selectorImpl = this;
        synchronized (selectorImpl) {
            listenerThread = this.listenerThreads.get(eventHandler);
            if (listenerThread == null) {
                this.cannotFindListenerThread();
                return;
            }
            this.listenerThreads.remove(eventHandler);
        }
        listenerThread.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transport
    private void createReaderThread(EventHandler eventHandler) {
        Connection connection = eventHandler.getConnection();
        ReaderThreadImpl readerThread = new ReaderThreadImpl(this.orb, connection);
        SelectorImpl selectorImpl = this;
        synchronized (selectorImpl) {
            this.readerThreads.put(eventHandler, readerThread);
        }
        Throwable throwable = null;
        try {
            this.orb.getThreadPoolManager().getThreadPool(0).getWorkQueue(0).addWork((Work)readerThread);
        }
        catch (NoSuchThreadPoolException e) {
            throwable = e;
        }
        catch (NoSuchWorkQueueException e) {
            throwable = e;
        }
        if (throwable != null) {
            throw new RuntimeException(throwable);
        }
    }

    @InfoMethod
    private void cannotFindReaderThread() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transport
    private void destroyReaderThread(EventHandler eventHandler) {
        ReaderThread readerThread;
        SelectorImpl selectorImpl = this;
        synchronized (selectorImpl) {
            readerThread = this.readerThreads.get(eventHandler);
            if (readerThread == null) {
                this.cannotFindReaderThread();
                return;
            }
            this.readerThreads.remove(eventHandler);
        }
        readerThread.close();
    }

    static interface Timer {
        public long getCurrentTime();
    }

    private static class SelectionKeyAndOp {
        public int keyOp;
        public SelectionKey selectionKey;

        public SelectionKeyAndOp(SelectionKey selectionKey, int keyOp) {
            this.selectionKey = selectionKey;
            this.keyOp = keyOp;
        }
    }
}

