/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundlerepository.impl;

import java.util.Collections;
import java.util.Dictionary;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.felix.bundlerepository.Capability;
import org.apache.felix.bundlerepository.Requirement;
import org.apache.felix.utils.collections.MapToDictionary;
import org.apache.felix.utils.filter.FilterImpl;
import org.osgi.framework.InvalidSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequirementImpl
implements Requirement {
    private static final Pattern REMOVE_LT = Pattern.compile("\\(([^<>=~()]*)<([^*=]([^\\\\\\*\\(\\)]|\\\\|\\*|\\(|\\))*)\\)");
    private static final Pattern REMOVE_GT = Pattern.compile("\\(([^<>=~()]*)>([^*=]([^\\\\\\*\\(\\)]|\\\\|\\*|\\(|\\))*)\\)");
    private static final Pattern REMOVE_NV = Pattern.compile("\\(version>=0.0.0\\)");
    private String m_name = null;
    private boolean m_extend = false;
    private boolean m_multiple = false;
    private boolean m_optional = false;
    private FilterImpl m_filter = null;
    private String m_comment = null;
    private Map<String, Object> m_attributes = Collections.emptyMap();
    private Map<String, String> m_directives = Collections.emptyMap();

    public RequirementImpl() {
    }

    public RequirementImpl(String name) {
        this.setName(name);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.m_attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.m_attributes = Collections.unmodifiableMap(attributes);
    }

    @Override
    public Map<String, String> getDirectives() {
        return this.m_directives;
    }

    public void setDirectives(Map<String, String> directives) {
        this.m_directives = Collections.unmodifiableMap(directives);
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name.intern();
    }

    @Override
    public String getFilter() {
        return this.m_filter.toString();
    }

    public void setFilter(String filter) {
        try {
            String nf = REMOVE_LT.matcher(filter).replaceAll("(!($1>=$2))");
            nf = REMOVE_GT.matcher(nf).replaceAll("(!($1<=$2))");
            nf = REMOVE_NV.matcher(nf).replaceAll("");
            this.m_filter = FilterImpl.newInstance(nf, true);
        }
        catch (InvalidSyntaxException e) {
            IllegalArgumentException ex = new IllegalArgumentException();
            ex.initCause(e);
            throw ex;
        }
    }

    @Override
    public boolean isSatisfied(Capability capability) {
        MapToDictionary propertyDict = new MapToDictionary(capability.getPropertiesAsMap());
        return this.m_name.equals(capability.getName()) && this.m_filter.match(propertyDict) && (this.m_filter.toString().contains("(mandatory:<*") || ((Dictionary)propertyDict).get("mandatory:") == null);
    }

    @Override
    public boolean isExtend() {
        return this.m_extend;
    }

    public void setExtend(boolean extend) {
        this.m_extend = extend;
    }

    @Override
    public boolean isMultiple() {
        return this.m_multiple;
    }

    public void setMultiple(boolean multiple) {
        this.m_multiple = multiple;
    }

    @Override
    public boolean isOptional() {
        return this.m_optional;
    }

    public void setOptional(boolean optional) {
        this.m_optional = optional;
    }

    @Override
    public String getComment() {
        return this.m_comment;
    }

    public void addText(String s) {
        this.m_comment = s;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Requirement) {
            Requirement r = (Requirement)o;
            return this.m_name.equals(r.getName()) && this.m_optional == r.isOptional() && this.m_multiple == r.isMultiple() && this.m_filter.toString().equals(r.getFilter()) && (this.m_comment == r.getComment() || this.m_comment != null && this.m_comment.equals(r.getComment()));
        }
        return false;
    }

    public int hashCode() {
        return this.m_filter.toString().hashCode();
    }

    public String toString() {
        return this.m_name + ":" + this.getFilter();
    }
}

