/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.model;

import jakarta.faces.model.DataModel;
import jakarta.faces.model.DataModelEvent;
import jakarta.faces.model.DataModelListener;
import jakarta.faces.model.NoRowAvailableException;
import java.util.List;

public class ListDataModel<E>
extends DataModel<E> {
    private int index = -1;
    private List<E> list;

    public ListDataModel() {
        this(null);
    }

    public ListDataModel(List<E> list) {
        this.setWrappedData(list);
    }

    @Override
    public boolean isRowAvailable() {
        return this.list != null && this.index >= 0 && this.index < this.list.size();
    }

    @Override
    public int getRowCount() {
        if (this.list == null) {
            return -1;
        }
        return this.list.size();
    }

    @Override
    public E getRowData() {
        if (this.list == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new NoRowAvailableException();
        }
        return this.list.get(this.index);
    }

    @Override
    public int getRowIndex() {
        return this.index;
    }

    @Override
    public void setRowIndex(int rowIndex) {
        if (rowIndex < -1) {
            throw new IllegalArgumentException();
        }
        int old = this.index;
        this.index = rowIndex;
        if (this.list == null) {
            return;
        }
        DataModelListener[] listeners = this.getDataModelListeners();
        if (old != this.index && listeners != null) {
            Object rowData = null;
            if (this.isRowAvailable()) {
                rowData = this.getRowData();
            }
            DataModelEvent event = new DataModelEvent(this, this.index, rowData);
            for (DataModelListener listener : listeners) {
                if (null == listener) continue;
                listener.rowSelected(event);
            }
        }
    }

    @Override
    public Object getWrappedData() {
        return this.list;
    }

    @Override
    public void setWrappedData(Object data) {
        if (data == null) {
            this.list = null;
            this.setRowIndex(-1);
        } else {
            this.list = (List)data;
            this.index = -1;
            this.setRowIndex(0);
        }
    }
}

