/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.AccessPath;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.ExpressionClassBuilderInterface;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.RequiredRowOrdering;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.BinaryComparisonOperatorNode;
import org.apache.derby.impl.sql.compile.BinaryOperatorNode;
import org.apache.derby.impl.sql.compile.BinaryRelationalOperatorNode;
import org.apache.derby.impl.sql.compile.BooleanConstantNode;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.InListOperatorNode;
import org.apache.derby.impl.sql.compile.OperatorNode;
import org.apache.derby.impl.sql.compile.OrNode;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.QueryTreeNodeVector;
import org.apache.derby.impl.sql.compile.RelationalOperator;
import org.apache.derby.impl.sql.compile.RemapCRsVisitor;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.UnaryComparisonOperatorNode;
import org.apache.derby.impl.sql.compile.UnaryOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

class PredicateList
extends QueryTreeNodeVector<Predicate>
implements OptimizablePredicateList {
    private int numberOfStartPredicates;
    private int numberOfStopPredicates;
    private int numberOfQualifiers;
    private static final int QUALIFIER_ORDER_EQUALS = 0;
    private static final int QUALIFIER_ORDER_OTHER_RELOP = 1;
    private static final int QUALIFIER_ORDER_NOT_EQUALS = 2;
    private static final int QUALIFIER_ORDER_NON_QUAL = 3;
    private static final int QUALIFIER_ORDER_OR_CLAUSE = 4;
    private static final int QUALIFIER_NUM_CATEGORIES = 5;

    PredicateList(ContextManager contextManager) {
        super(Predicate.class, contextManager);
    }

    @Override
    public OptimizablePredicate getOptPredicate(int n) {
        return (OptimizablePredicate)this.elementAt(n);
    }

    @Override
    public final void removeOptPredicate(int n) throws StandardException {
        Predicate predicate = (Predicate)this.removeElementAt(n);
        if (predicate.isStartKey()) {
            --this.numberOfStartPredicates;
        }
        if (predicate.isStopKey()) {
            --this.numberOfStopPredicates;
        }
        if (predicate.isQualifier()) {
            --this.numberOfQualifiers;
        }
    }

    public final void removeOptPredicate(OptimizablePredicate optimizablePredicate) {
        this.removeElement((Predicate)optimizablePredicate);
        if (optimizablePredicate.isStartKey()) {
            --this.numberOfStartPredicates;
        }
        if (optimizablePredicate.isStopKey()) {
            --this.numberOfStopPredicates;
        }
        if (optimizablePredicate.isQualifier()) {
            --this.numberOfQualifiers;
        }
    }

    @Override
    public void addOptPredicate(OptimizablePredicate optimizablePredicate) {
        this.addElement((Predicate)optimizablePredicate);
        if (optimizablePredicate.isStartKey()) {
            ++this.numberOfStartPredicates;
        }
        if (optimizablePredicate.isStopKey()) {
            ++this.numberOfStopPredicates;
        }
        if (optimizablePredicate.isQualifier()) {
            ++this.numberOfQualifiers;
        }
    }

    public void addOptPredicate(OptimizablePredicate optimizablePredicate, int n) {
        this.insertElementAt((Predicate)optimizablePredicate, n);
        if (optimizablePredicate.isStartKey()) {
            ++this.numberOfStartPredicates;
        }
        if (optimizablePredicate.isStopKey()) {
            ++this.numberOfStopPredicates;
        }
        if (optimizablePredicate.isQualifier()) {
            ++this.numberOfQualifiers;
        }
    }

    @Override
    public boolean useful(Optimizable optimizable, ConglomerateDescriptor conglomerateDescriptor) throws StandardException {
        boolean bl = false;
        if (!conglomerateDescriptor.isIndex()) {
            return false;
        }
        for (Predicate predicate : this) {
            boolean bl2;
            RelationalOperator relationalOperator = predicate.getRelop();
            InListOperatorNode inListOperatorNode = predicate.getSourceInList();
            boolean bl3 = bl2 = inListOperatorNode != null;
            if (!bl2 && relationalOperator == null || !bl2 && !relationalOperator.usefulStartKey(optimizable) && !relationalOperator.usefulStopKey(optimizable)) continue;
            ColumnReference columnReference = null;
            if (bl2) {
                if (inListOperatorNode.getLeftOperand() instanceof ColumnReference && (columnReference = (ColumnReference)inListOperatorNode.getLeftOperand()).getColumnNumber() != conglomerateDescriptor.getIndexDescriptor().baseColumnPositions()[0]) {
                    columnReference = null;
                }
            } else {
                columnReference = relationalOperator.getColumnOperand(optimizable, conglomerateDescriptor.getIndexDescriptor().baseColumnPositions()[0]);
            }
            if (columnReference == null || bl2 && inListOperatorNode.selfReference(columnReference) || !bl2 && relationalOperator.selfComparison(columnReference)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public void pushUsefulPredicates(Optimizable optimizable) throws StandardException {
        AccessPath accessPath = optimizable.getTrulyTheBestAccessPath();
        this.orderUsefulPredicates(optimizable, accessPath.getConglomerateDescriptor(), true, accessPath.getNonMatchingIndexScan(), accessPath.getCoveringIndexScan());
    }

    @Override
    public void classify(Optimizable optimizable, ConglomerateDescriptor conglomerateDescriptor) throws StandardException {
        this.orderUsefulPredicates(optimizable, conglomerateDescriptor, false, false, false);
    }

    @Override
    public void markAllPredicatesQualifiers() {
        for (Predicate predicate : this) {
            predicate.markQualifier();
        }
        this.numberOfQualifiers = this.size();
    }

    @Override
    public int hasEqualityPredicateOnOrderedColumn(Optimizable optimizable, int n, boolean bl) throws StandardException {
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            AndNode andNode;
            ValueNode valueNode;
            Predicate predicate = (Predicate)this.elementAt(i);
            if (predicate.getReferencedMap().hasSingleBitSet() || !(valueNode = (andNode = predicate.getAndNode()).getLeftOperand()).optimizableEqualityNode(optimizable, n, bl)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean hasOptimizableEqualityPredicate(Optimizable optimizable, int n, boolean bl) throws StandardException {
        for (Predicate predicate : this) {
            AndNode andNode = predicate.getAndNode();
            ValueNode valueNode = andNode.getLeftOperand();
            if (!valueNode.optimizableEqualityNode(optimizable, n, bl)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasOptimizableEquijoin(Optimizable optimizable, int n) throws StandardException {
        for (Predicate predicate : this) {
            AndNode andNode;
            ValueNode valueNode;
            if (predicate.isScopedForPush() || !(valueNode = (andNode = predicate.getAndNode()).getLeftOperand()).optimizableEqualityNode(optimizable, n, false) || !((RelationalOperator)((Object)valueNode)).isQualifier(optimizable, false) || predicate.getReferencedMap().hasSingleBitSet()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void putOptimizableEqualityPredicateFirst(Optimizable optimizable, int n) throws StandardException {
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            Predicate predicate = (Predicate)this.elementAt(i);
            AndNode andNode = predicate.getAndNode();
            ValueNode valueNode = andNode.getLeftOperand();
            if (!valueNode.optimizableEqualityNode(optimizable, n, false)) continue;
            if (i != 0) {
                this.removeElementAt(i);
                this.insertElementAt(predicate, 0);
            }
            return;
        }
    }

    private void orderUsefulPredicates(Optimizable optimizable, ConglomerateDescriptor conglomerateDescriptor, boolean bl, boolean bl2, boolean bl3) throws StandardException {
        int n;
        int n2;
        int n3 = this.size();
        Object[] objectArray = new Predicate[n3];
        int n4 = 0;
        for (Predicate[] predicateArray : this) {
            predicateArray.clearScanFlags();
        }
        if (conglomerateDescriptor == null || !conglomerateDescriptor.isIndex() || bl2 && bl3) {
            int n5;
            Predicate[] predicateArray = new Predicate[n3];
            for (n5 = 0; n5 < n3; ++n5) {
                Predicate predicate = (Predicate)this.elementAt(n5);
                if (!predicate.isRelationalOpPredicate() ? !predicate.isPushableOrClause(optimizable) : !predicate.getRelop().isQualifier(optimizable, bl)) continue;
                predicate.markQualifier();
                if (!bl || !optimizable.pushOptPredicate(predicate)) continue;
                predicateArray[n5] = predicate;
            }
            for (n5 = n3 - 1; n5 >= 0; --n5) {
                if (predicateArray[n5] == null) continue;
                this.removeOptPredicate(predicateArray[n5]);
            }
            return;
        }
        int[] nArray = conglomerateDescriptor.getIndexDescriptor().baseColumnPositions();
        boolean[] blArray = conglomerateDescriptor.getIndexDescriptor().isAscending();
        boolean bl4 = bl && optimizable.getTrulyTheBestAccessPath().getJoinStrategy().isHashJoin();
        for (Predicate predicate : this) {
            ColumnReference columnReference = null;
            RelationalOperator relationalOperator = predicate.getRelop();
            InListOperatorNode inListOperatorNode = predicate.getSourceInList();
            int n6 = n2 = inListOperatorNode != null ? 1 : 0;
            if (n2 == 0 && (relationalOperator == null || !relationalOperator.isQualifier(optimizable, bl)) || bl4 && predicate.isInListProbePredicate()) continue;
            for (n = 0; n < nArray.length; ++n) {
                if (n2 != 0) {
                    if (inListOperatorNode.getLeftOperand() instanceof ColumnReference) {
                        columnReference = (ColumnReference)inListOperatorNode.getLeftOperand();
                        if (optimizable.getTableNumber() != columnReference.getTableNumber() || columnReference.getColumnNumber() != nArray[n] || inListOperatorNode.selfReference(columnReference)) {
                            columnReference = null;
                        } else if (predicate.isInListProbePredicate() && n > 0) {
                            columnReference = null;
                        }
                    }
                } else {
                    columnReference = relationalOperator.getColumnOperand(optimizable, nArray[n]);
                }
                if (columnReference != null) break;
            }
            if (columnReference == null) continue;
            predicate.setIndexPosition(n);
            objectArray[n4++] = predicate;
        }
        if (n4 == 0) {
            return;
        }
        if (objectArray.length > n4) {
            Predicate[] predicateArray;
            predicateArray = new Predicate[n4];
            System.arraycopy(objectArray, 0, predicateArray, 0, n4);
            objectArray = predicateArray;
        }
        Arrays.sort(objectArray);
        int n7 = -1;
        boolean bl5 = false;
        int n8 = -1;
        n = 0;
        boolean bl6 = false;
        int n9 = -1;
        n2 = -1;
        boolean bl7 = false;
        boolean bl8 = false;
        for (int i = 0; i < n4; ++i) {
            boolean bl9;
            Object object = objectArray[i];
            int n10 = ((Predicate)object).getIndexPosition();
            boolean bl10 = false;
            RelationalOperator relationalOperator = ((Predicate)object).getRelop();
            int n11 = -1;
            boolean bl11 = bl9 = ((Predicate)object).getSourceInList() != null;
            if (relationalOperator != null) {
                n11 = relationalOperator.getOperator();
            }
            if (n7 != n10) {
                if (n10 - n7 > 1) {
                    bl5 = true;
                } else if (n11 == 1 || n11 == 7) {
                    n2 = n10;
                }
                if (!bl5 && !bl8 && (bl9 || relationalOperator.usefulStartKey(optimizable) && blArray[n10] || relationalOperator.usefulStopKey(optimizable) && !blArray[n10])) {
                    ((Predicate)object).markStartKey();
                    n7 = n10;
                    bl10 = true;
                    boolean bl12 = bl8 = ((Predicate)object).getStartOperator(optimizable) == -1;
                }
            }
            if (n8 != n10) {
                if (n10 - n8 > 1) {
                    n = 1;
                }
                if (n == 0 && !bl7 && (bl9 || relationalOperator.usefulStopKey(optimizable) && blArray[n10] || relationalOperator.usefulStartKey(optimizable) && !blArray[n10])) {
                    ((Predicate)object).markStopKey();
                    n8 = n10;
                    bl10 = true;
                    boolean bl13 = bl7 = ((Predicate)object).getStopOperator(optimizable) == 1;
                }
            }
            if (!bl9 && (!bl10 || bl6 && n10 != n9)) {
                ((Predicate)object).markQualifier();
            }
            if (n2 != n10 && n9 == -1 && n11 != 1 && n11 != 7) {
                bl6 = true;
                n9 = n10;
            }
            if (bl) {
                Object object2;
                if (bl9 && !bl10) continue;
                if (bl9 && !((Predicate)object).isInListProbePredicate()) {
                    AndNode andNode = new AndNode(((Predicate)object).getAndNode().getLeftOperand(), ((Predicate)object).getAndNode().getRightOperand(), this.getContextManager());
                    andNode.copyFields(((Predicate)object).getAndNode());
                    Predicate predicate = new Predicate(andNode, ((Predicate)object).getReferencedSet(), this.getContextManager());
                    predicate.copyFields((Predicate)object);
                    object2 = predicate;
                } else {
                    object2 = object;
                }
                if (!optimizable.pushOptPredicate((OptimizablePredicate)object2) || bl9 && !((Predicate)object).isInListProbePredicate()) continue;
                this.removeOptPredicate((OptimizablePredicate)object);
                continue;
            }
            this.removeOptPredicate((OptimizablePredicate)object);
            this.addOptPredicate((OptimizablePredicate)object, i);
        }
    }

    void addPredicate(Predicate predicate) throws StandardException {
        if (predicate.isStartKey()) {
            ++this.numberOfStartPredicates;
        }
        if (predicate.isStopKey()) {
            ++this.numberOfStopPredicates;
        }
        if (predicate.isQualifier()) {
            ++this.numberOfQualifiers;
        }
        this.addElement(predicate);
    }

    protected void transferNonQualifiers(Optimizable optimizable, PredicateList predicateList) throws StandardException {
        for (int i = this.size() - 1; i >= 0; --i) {
            Predicate predicate = (Predicate)this.elementAt(i);
            if (predicate.isRelationalOpPredicate() && predicate.getRelop().isQualifier(optimizable, false)) continue;
            predicate.clearScanFlags();
            this.removeElementAt(i);
            predicateList.addElement(predicate);
        }
        this.markAllPredicatesQualifiers();
    }

    void categorize() throws StandardException {
        for (Predicate predicate : this) {
            predicate.categorize();
        }
    }

    void eliminateBooleanTrueAndBooleanTrue() {
        for (int i = this.size() - 1; i >= 0; --i) {
            AndNode andNode = ((Predicate)this.elementAt(i)).getAndNode();
            if (!andNode.getLeftOperand().isBooleanTrue() || !andNode.getRightOperand().isBooleanTrue()) continue;
            this.removeElementAt(i);
        }
    }

    ValueNode restoreConstantPredicates() throws StandardException {
        BinaryOperatorNode binaryOperatorNode = null;
        ValueNode valueNode = null;
        for (int i = this.size() - 1; i >= 0; --i) {
            AndNode andNode = ((Predicate)this.elementAt(i)).getAndNode();
            if (!andNode.isConstantExpression()) continue;
            this.removeElementAt(i);
            if (andNode.getLeftOperand().isBooleanTrue() && andNode.getRightOperand().isBooleanTrue()) continue;
            if (andNode.getLeftOperand().isBooleanFalse()) {
                binaryOperatorNode = andNode;
            }
            if (valueNode != null) {
                andNode.setRightOperand(valueNode);
                if (valueNode.getTypeServices().isNullable()) {
                    andNode.setNullability(true);
                }
            }
            valueNode = andNode;
        }
        if (valueNode != null && ((AndNode)valueNode).getRightOperand().isBooleanTrue()) {
            valueNode = ((AndNode)valueNode).getLeftOperand();
        } else if (binaryOperatorNode != null) {
            valueNode = binaryOperatorNode.getLeftOperand();
        }
        return valueNode;
    }

    ValueNode restorePredicates() throws StandardException {
        BinaryOperatorNode binaryOperatorNode = null;
        ValueNode valueNode = null;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            AndNode andNode = ((Predicate)this.elementAt(i)).getAndNode();
            if (andNode.getLeftOperand().isBooleanTrue() && andNode.getRightOperand().isBooleanTrue()) continue;
            if (andNode.getLeftOperand().isBooleanFalse()) {
                binaryOperatorNode = andNode;
            }
            if (valueNode != null) {
                andNode.setRightOperand(valueNode);
                if (valueNode.getTypeServices().isNullable()) {
                    andNode.setNullability(true);
                }
            }
            valueNode = andNode;
        }
        if (valueNode != null && ((AndNode)valueNode).getRightOperand().isBooleanTrue()) {
            valueNode = ((AndNode)valueNode).getLeftOperand();
        } else if (binaryOperatorNode != null) {
            valueNode = binaryOperatorNode.getLeftOperand();
        }
        this.removeAllElements();
        return valueNode;
    }

    void remapColumnReferencesToExpressions() throws StandardException {
        for (Predicate predicate : this) {
            predicate.setAndNode((AndNode)predicate.getAndNode().remapColumnReferencesToExpressions());
        }
    }

    void pullExpressions(int n, ValueNode valueNode) throws StandardException {
        if (valueNode != null) {
            Predicate predicate;
            JBitSet jBitSet;
            AndNode andNode = (AndNode)valueNode;
            BooleanConstantNode booleanConstantNode = new BooleanConstantNode(true, this.getContextManager());
            while (andNode.getRightOperand() instanceof AndNode) {
                AndNode andNode2 = andNode;
                andNode = (AndNode)andNode.getRightOperand();
                andNode2.setRightOperand(null);
                andNode2.setRightOperand(booleanConstantNode);
                jBitSet = new JBitSet(n);
                predicate = new Predicate(andNode2, jBitSet, this.getContextManager());
                this.addPredicate(predicate);
            }
            jBitSet = new JBitSet(n);
            predicate = new Predicate(andNode, jBitSet, this.getContextManager());
            this.addPredicate(predicate);
        }
    }

    void xorReferencedSet(JBitSet jBitSet) {
        for (Predicate predicate : this) {
            predicate.getReferencedSet().xor(jBitSet);
        }
    }

    private void countScanFlags() {
        for (Predicate predicate : this) {
            if (predicate.isStartKey()) {
                ++this.numberOfStartPredicates;
            }
            if (predicate.isStopKey()) {
                ++this.numberOfStopPredicates;
            }
            if (!predicate.isQualifier()) continue;
            ++this.numberOfQualifiers;
        }
    }

    private static boolean isConstantOrParameterNode(ValueNode valueNode) {
        return valueNode instanceof ConstantNode || valueNode instanceof ParameterNode;
    }

    void pushExpressionsIntoSelect(SelectNode selectNode, boolean bl) throws StandardException {
        for (int i = this.size() - 1; i >= 0; --i) {
            boolean bl2;
            Predicate predicate = (Predicate)this.elementAt(i);
            CollectNodesVisitor<ColumnReference> collectNodesVisitor = new CollectNodesVisitor<ColumnReference>(ColumnReference.class);
            predicate.getAndNode().accept(collectNodesVisitor);
            List<ColumnReference> list = collectNodesVisitor.getList();
            boolean bl3 = bl2 = list.size() > 0;
            if (bl2) {
                for (ValueNode valueNode2 : list) {
                    if (valueNode2.pointsToColumnReference()) continue;
                    bl2 = false;
                    break;
                }
            }
            if (!bl2) continue;
            if (bl) {
                ValueNode valueNode;
                ColumnReference columnReference;
                ValueNode valueNode2;
                AndNode andNode = predicate.getAndNode();
                BinaryRelationalOperatorNode binaryRelationalOperatorNode = null;
                InListOperatorNode inListOperatorNode = null;
                if (andNode.getLeftOperand() instanceof BinaryRelationalOperatorNode) {
                    binaryRelationalOperatorNode = (BinaryRelationalOperatorNode)andNode.getLeftOperand();
                    if (!(binaryRelationalOperatorNode.getLeftOperand() instanceof ColumnReference) || !PredicateList.isConstantOrParameterNode(binaryRelationalOperatorNode.getRightOperand())) continue;
                    columnReference = (ColumnReference)binaryRelationalOperatorNode.getLeftOperand();
                } else {
                    if (!(andNode.getLeftOperand() instanceof InListOperatorNode) || !((inListOperatorNode = (InListOperatorNode)andNode.getLeftOperand()).getLeftOperand() instanceof ColumnReference) || !inListOperatorNode.getRightOperandList().isConstantExpression()) continue;
                    columnReference = (ColumnReference)inListOperatorNode.getLeftOperand();
                }
                ColumnReference columnReference2 = selectNode.findColumnReferenceInResult(columnReference.getColumnName());
                if (columnReference2 == null) continue;
                if (andNode.getLeftOperand() instanceof BinaryRelationalOperatorNode) {
                    inListOperatorNode = binaryRelationalOperatorNode.getInListOp();
                    if (inListOperatorNode != null) {
                        inListOperatorNode = inListOperatorNode.shallowCopy();
                        inListOperatorNode.setLeftOperand(columnReference2);
                    }
                    valueNode = new BinaryRelationalOperatorNode(binaryRelationalOperatorNode.kind, (ValueNode)columnReference2, binaryRelationalOperatorNode.getRightOperand(), inListOperatorNode, binaryRelationalOperatorNode.getForQueryRewrite(), this.getContextManager());
                    ((BinaryComparisonOperatorNode)valueNode).bindComparisonOperator();
                    valueNode2 = valueNode;
                } else {
                    valueNode = new InListOperatorNode(columnReference2, inListOperatorNode.getRightOperandList(), this.getContextManager());
                    valueNode.setType(inListOperatorNode.getTypeServices());
                    valueNode2 = valueNode;
                }
                valueNode = new BooleanConstantNode(true, this.getContextManager());
                AndNode andNode2 = new AndNode(valueNode2, valueNode, this.getContextManager());
                andNode2.postBindFixup();
                JBitSet jBitSet = new JBitSet(selectNode.getReferencedTableMap().size());
                predicate = new Predicate(andNode2, jBitSet, this.getContextManager());
            } else {
                if (predicate.isStartKey()) {
                    --this.numberOfStartPredicates;
                }
                if (predicate.isStopKey()) {
                    --this.numberOfStopPredicates;
                }
                if (predicate.isQualifier()) {
                    --this.numberOfQualifiers;
                }
                predicate.clearScanFlags();
                this.removeElementAt(i);
            }
            selectNode.pushExpressionsIntoSelect(predicate);
        }
    }

    void markReferencedColumns() throws StandardException {
        CollectNodesVisitor<ColumnReference> collectNodesVisitor = new CollectNodesVisitor<ColumnReference>(ColumnReference.class);
        for (Predicate queryTreeNode : this) {
            queryTreeNode.getAndNode().accept(collectNodesVisitor);
        }
        for (ColumnReference columnReference : collectNodesVisitor.getList()) {
            ResultColumn resultColumn = columnReference.getSource();
            if (resultColumn == null) continue;
            resultColumn.markAllRCsInChainReferenced();
        }
    }

    void checkTopPredicatesForEqualsConditions(int n, boolean[] blArray, int[] nArray, JBitSet[] jBitSetArray, boolean bl) throws StandardException {
        for (Predicate predicate : this) {
            predicate.getAndNode().checkTopPredicatesForEqualsConditions(n, blArray, nArray, jBitSetArray, bl);
        }
    }

    boolean allPushable() {
        for (Predicate predicate : this) {
            if (predicate.getPushable()) continue;
            return false;
        }
        return true;
    }

    boolean allReference(FromBaseTable fromBaseTable) {
        int n = fromBaseTable.getTableNumber();
        for (Predicate predicate : this) {
            if (predicate.getReferencedSet().get(n)) continue;
            return false;
        }
        return true;
    }

    PredicateList getPushablePredicates(JBitSet jBitSet) throws StandardException {
        PredicateList predicateList = null;
        for (int i = this.size() - 1; i >= 0; --i) {
            JBitSet jBitSet2;
            Predicate predicate = (Predicate)this.elementAt(i);
            if (!predicate.getPushable() || !jBitSet.contains(jBitSet2 = predicate.getReferencedSet())) continue;
            if (predicateList == null) {
                predicateList = new PredicateList(this.getContextManager());
            }
            predicateList.addPredicate(predicate);
            RemapCRsVisitor remapCRsVisitor = new RemapCRsVisitor(true);
            predicate.getAndNode().accept(remapCRsVisitor);
            this.removeElementAt(i);
        }
        return predicateList;
    }

    void decrementLevel(FromList fromList, int n) {
        int[] nArray = fromList.getTableNumbers();
        block0: for (Predicate predicate : this) {
            int n2;
            UnaryOperatorNode unaryOperatorNode;
            ColumnReference columnReference = null;
            ColumnReference columnReference2 = null;
            ValueNode valueNode = predicate.getAndNode().getLeftOperand();
            if (valueNode instanceof BinaryOperatorNode) {
                BinaryOperatorNode binaryOperatorNode = (BinaryOperatorNode)valueNode;
                if (binaryOperatorNode.getLeftOperand() instanceof ColumnReference) {
                    columnReference = (ColumnReference)binaryOperatorNode.getLeftOperand();
                }
                if (binaryOperatorNode.getRightOperand() instanceof ColumnReference) {
                    columnReference2 = (ColumnReference)binaryOperatorNode.getRightOperand();
                }
            } else if (valueNode instanceof UnaryOperatorNode && (unaryOperatorNode = (UnaryOperatorNode)valueNode).getOperand() instanceof ColumnReference) {
                columnReference = (ColumnReference)unaryOperatorNode.getOperand();
            }
            if (columnReference != null) {
                int n3 = columnReference.getTableNumber();
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    if (nArray[n2] != n3) continue;
                    columnReference.setSourceLevel(columnReference.getSourceLevel() - n);
                    break;
                }
            }
            if (columnReference2 == null) continue;
            int n4 = columnReference2.getTableNumber();
            for (n2 = 0; n2 < nArray.length; ++n2) {
                if (nArray[n2] != n4) continue;
                columnReference2.setSourceLevel(columnReference2.getSourceLevel() - n);
                continue block0;
            }
        }
    }

    void joinClauseTransitiveClosure(int n, FromList fromList, CompilerContext compilerContext) throws StandardException {
        ValueNode valueNode;
        QueryTreeNode queryTreeNode;
        Object object;
        if (fromList.size() < 3) {
            return;
        }
        PredicateList[] predicateListArray = new PredicateList[n];
        for (int i = 0; i < n; ++i) {
            predicateListArray[i] = new PredicateList(this.getContextManager());
        }
        for (QueryTreeNode queryTreeNode2 : this) {
            object = ((Predicate)queryTreeNode2).getAndNode().getLeftOperand();
            if (!((ValueNode)object).isBinaryEqualsOperatorNode()) continue;
            BinaryRelationalOperatorNode binaryRelationalOperatorNode = (BinaryRelationalOperatorNode)object;
            queryTreeNode = binaryRelationalOperatorNode.getLeftOperand();
            valueNode = binaryRelationalOperatorNode.getRightOperand();
            if (!(queryTreeNode instanceof ColumnReference) || !(valueNode instanceof ColumnReference)) continue;
            ColumnReference columnReference = (ColumnReference)queryTreeNode;
            ColumnReference columnReference2 = (ColumnReference)valueNode;
            if (columnReference.getSourceLevel() != columnReference2.getSourceLevel() || columnReference.getTableNumber() == columnReference2.getTableNumber() || fromList.tableNumberIsNotExists(columnReference.getTableNumber()) || fromList.tableNumberIsNotExists(columnReference2.getTableNumber())) continue;
            predicateListArray[columnReference.getTableNumber()].addElement(queryTreeNode2);
            predicateListArray[columnReference2.getTableNumber()].addElement(queryTreeNode2);
        }
        for (int i = 0; i < n; ++i) {
            int n2;
            QueryTreeNode queryTreeNode2;
            queryTreeNode2 = predicateListArray[i];
            if (((QueryTreeNodeVector)queryTreeNode2).size() == 0) continue;
            object = new ArrayList();
            for (n2 = ((QueryTreeNodeVector)queryTreeNode2).size() - 1; n2 >= 0; --n2) {
                queryTreeNode = (Predicate)((QueryTreeNodeVector)queryTreeNode2).elementAt(n2);
                if (((Predicate)queryTreeNode).getEquivalenceClass() == -1) continue;
                ((QueryTreeNodeVector)queryTreeNode2).removeElementAt(n2);
                ((ArrayList)object).add(queryTreeNode);
            }
            for (n2 = 0; n2 < ((ArrayList)object).size(); ++n2) {
                ((QueryTreeNodeVector)queryTreeNode2).insertElementAt((Predicate)((ArrayList)object).get(n2), 0);
            }
            for (n2 = 0; n2 < ((QueryTreeNodeVector)queryTreeNode2).size(); ++n2) {
                int n3;
                int n4;
                int n5;
                queryTreeNode = null;
                int n6 = i;
                Predicate predicate = (Predicate)((QueryTreeNodeVector)queryTreeNode2).elementAt(n2);
                if (predicate.getEquivalenceClass() == -1) {
                    predicate.setEquivalenceClass(compilerContext.getNextEquivalenceClass());
                }
                int n7 = predicate.getEquivalenceClass();
                BinaryRelationalOperatorNode binaryRelationalOperatorNode = (BinaryRelationalOperatorNode)predicate.getAndNode().getLeftOperand();
                ColumnReference columnReference = (ColumnReference)binaryRelationalOperatorNode.getLeftOperand();
                ColumnReference columnReference3 = (ColumnReference)binaryRelationalOperatorNode.getRightOperand();
                if (columnReference.getTableNumber() == n6) {
                    n5 = columnReference.getColumnNumber();
                    n4 = columnReference3.getTableNumber();
                    n3 = columnReference3.getColumnNumber();
                    valueNode = columnReference;
                } else {
                    n5 = columnReference3.getColumnNumber();
                    n4 = columnReference.getTableNumber();
                    n3 = columnReference.getColumnNumber();
                    valueNode = columnReference3;
                }
                PredicateList predicateList = predicateListArray[n4];
                for (Predicate predicate2 : predicateList) {
                    ValueNode valueNode2;
                    ValueNode valueNode3;
                    BinaryRelationalOperatorNode binaryRelationalOperatorNode2;
                    int n8;
                    int n9;
                    int n10;
                    if (predicate2.getEquivalenceClass() != -1 && predicate2.getEquivalenceClass() != n7) continue;
                    BinaryRelationalOperatorNode binaryRelationalOperatorNode3 = (BinaryRelationalOperatorNode)predicate2.getAndNode().getLeftOperand();
                    ColumnReference columnReference4 = (ColumnReference)binaryRelationalOperatorNode3.getLeftOperand();
                    ColumnReference columnReference5 = (ColumnReference)binaryRelationalOperatorNode3.getRightOperand();
                    if (columnReference4.getTableNumber() == n4) {
                        if (columnReference4.getColumnNumber() != n3) continue;
                        n10 = columnReference5.getTableNumber();
                        n9 = columnReference5.getColumnNumber();
                    } else {
                        if (columnReference5.getColumnNumber() != n3) continue;
                        n10 = columnReference4.getTableNumber();
                        n9 = columnReference4.getColumnNumber();
                    }
                    if (n6 == n10 && n5 == n9) continue;
                    predicate2.setEquivalenceClass(n7);
                    Predicate predicate3 = null;
                    PredicateList predicateList2 = predicateListArray[n10];
                    for (n8 = 0; n8 < predicateList2.size(); ++n8) {
                        int n11;
                        int n12;
                        predicate3 = (Predicate)predicateList2.elementAt(n8);
                        if (predicate3.getEquivalenceClass() != -1 && predicate3.getEquivalenceClass() != n7) continue;
                        binaryRelationalOperatorNode2 = (BinaryRelationalOperatorNode)predicate3.getAndNode().getLeftOperand();
                        valueNode3 = (ColumnReference)binaryRelationalOperatorNode2.getLeftOperand();
                        valueNode2 = (ColumnReference)binaryRelationalOperatorNode2.getRightOperand();
                        if (((ColumnReference)valueNode3).getTableNumber() == n10) {
                            if (((ColumnReference)valueNode3).getColumnNumber() != n9) continue;
                            n12 = ((ColumnReference)valueNode2).getTableNumber();
                            n11 = ((ColumnReference)valueNode2).getColumnNumber();
                            queryTreeNode = valueNode3;
                        } else {
                            if (((ColumnReference)valueNode2).getColumnNumber() != n9) continue;
                            n12 = ((ColumnReference)valueNode3).getTableNumber();
                            n11 = ((ColumnReference)valueNode3).getColumnNumber();
                            queryTreeNode = valueNode2;
                        }
                        if (n12 == n6 && n11 == n5) break;
                    }
                    if (n8 != predicateList2.size()) {
                        predicate3.setEquivalenceClass(n7);
                        continue;
                    }
                    binaryRelationalOperatorNode2 = new BinaryRelationalOperatorNode(0, ((ColumnReference)valueNode).getClone(), ((ColumnReference)queryTreeNode).getClone(), false, this.getContextManager());
                    binaryRelationalOperatorNode2.bindComparisonOperator();
                    valueNode3 = new BooleanConstantNode(true, this.getContextManager());
                    valueNode2 = new AndNode(binaryRelationalOperatorNode2, valueNode3, this.getContextManager());
                    ((AndNode)valueNode2).postBindFixup();
                    JBitSet jBitSet = new JBitSet(n);
                    ((BinaryOperatorNode)valueNode2).categorize(jBitSet, false);
                    Predicate predicate4 = new Predicate((AndNode)valueNode2, jBitSet, this.getContextManager());
                    predicate4.setEquivalenceClass(n7);
                    this.addPredicate(predicate4);
                    if (n2 != ((QueryTreeNodeVector)queryTreeNode2).size() - 1) {
                        ((QueryTreeNodeVector)queryTreeNode2).insertElementAt(predicate4, n2 + 1);
                    } else {
                        ((QueryTreeNodeVector)queryTreeNode2).addElement(predicate4);
                    }
                    if (queryTreeNode2 == predicateList2) continue;
                    predicateList2.addElement(predicate4);
                }
            }
        }
    }

    void searchClauseTransitiveClosure(int n, boolean bl) throws StandardException {
        ValueNode valueNode;
        RelationalOperator relationalOperator;
        QueryTreeNode queryTreeNode;
        Object object;
        int n2;
        PredicateList predicateList = new PredicateList(this.getContextManager());
        PredicateList predicateList2 = new PredicateList(this.getContextManager());
        BinaryRelationalOperatorNode binaryRelationalOperatorNode = null;
        int n3 = this.size();
        for (n2 = 0; n2 < n3; ++n2) {
            Object object2;
            ValueNode valueNode2;
            BinaryComparisonOperatorNode binaryComparisonOperatorNode;
            object = (Predicate)this.elementAt(n2);
            queryTreeNode = ((Predicate)object).getAndNode();
            if (!((Predicate)object).isRelationalOpPredicate()) continue;
            relationalOperator = (RelationalOperator)((Object)((BinaryOperatorNode)queryTreeNode).getLeftOperand());
            if (((ValueNode)((Object)relationalOperator)).isBinaryEqualsOperatorNode()) {
                binaryComparisonOperatorNode = (BinaryRelationalOperatorNode)relationalOperator;
                binaryRelationalOperatorNode = binaryComparisonOperatorNode;
                valueNode2 = binaryComparisonOperatorNode.getLeftOperand();
                object2 = binaryComparisonOperatorNode.getRightOperand();
                if (valueNode2 instanceof ColumnReference && object2 instanceof ColumnReference) {
                    QueryTreeNode queryTreeNode2 = (ColumnReference)valueNode2;
                    valueNode = (ColumnReference)object2;
                    if (((ColumnReference)queryTreeNode2).getSourceLevel() != ((ColumnReference)valueNode).getSourceLevel() || ((ColumnReference)queryTreeNode2).getTableNumber() == ((ColumnReference)valueNode).getTableNumber()) continue;
                    predicateList.addElement(object);
                    continue;
                }
            }
            if (relationalOperator instanceof UnaryComparisonOperatorNode) {
                if (!(((UnaryComparisonOperatorNode)((Object)relationalOperator)).getOperand() instanceof ColumnReference)) continue;
                predicateList2.addElement(object);
                continue;
            }
            if (!(relationalOperator instanceof BinaryComparisonOperatorNode)) continue;
            binaryComparisonOperatorNode = (BinaryComparisonOperatorNode)((Object)relationalOperator);
            valueNode2 = binaryComparisonOperatorNode.getLeftOperand();
            object2 = binaryComparisonOperatorNode.getRightOperand();
            if (valueNode2 instanceof ColumnReference && PredicateList.isConstantOrParameterNode((ValueNode)object2)) {
                predicateList2.addElement(object);
                continue;
            }
            if (!PredicateList.isConstantOrParameterNode(valueNode2) || !(object2 instanceof ColumnReference)) continue;
            ((BinaryOperatorNode)queryTreeNode).setLeftOperand(binaryComparisonOperatorNode.getSwappedEquivalent());
            predicateList2.addElement(object);
        }
        if (predicateList.size() == 0 || predicateList2.size() == 0) {
            return;
        }
        for (n2 = 0; n2 < predicateList2.size(); ++n2) {
            object = null;
            relationalOperator = (RelationalOperator)((Object)((Predicate)predicateList2.elementAt(n2)).getAndNode().getLeftOperand());
            if (relationalOperator instanceof UnaryComparisonOperatorNode) {
                queryTreeNode = (ColumnReference)((UnaryComparisonOperatorNode)((Object)relationalOperator)).getOperand();
            } else {
                queryTreeNode = (ColumnReference)((BinaryComparisonOperatorNode)((Object)relationalOperator)).getLeftOperand();
                if (((BinaryComparisonOperatorNode)((Object)relationalOperator)).getRightOperand() instanceof ConstantNode) {
                    ConstantNode constantNode = (ConstantNode)((BinaryComparisonOperatorNode)((Object)relationalOperator)).getRightOperand();
                    object = constantNode.getValue();
                } else {
                    object = null;
                }
            }
            int n4 = ((ColumnReference)queryTreeNode).getTableNumber();
            int n5 = ((ColumnReference)queryTreeNode).getColumnNumber();
            for (QueryTreeNode queryTreeNode2 : predicateList) {
                Object object3;
                Object object4;
                QueryTreeNode queryTreeNode32;
                ColumnReference columnReference;
                if (((Predicate)queryTreeNode2).transitiveSearchClauseAdded(relationalOperator)) continue;
                valueNode = (BinaryRelationalOperatorNode)((Predicate)queryTreeNode2).getAndNode().getLeftOperand();
                ColumnReference columnReference2 = (ColumnReference)((BinaryOperatorNode)valueNode).getLeftOperand();
                ColumnReference columnReference3 = (ColumnReference)((BinaryOperatorNode)valueNode).getRightOperand();
                if (columnReference2.getTableNumber() == n4 && columnReference2.getColumnNumber() == n5) {
                    columnReference = columnReference3;
                } else {
                    if (columnReference3.getTableNumber() != n4 || columnReference3.getColumnNumber() != n5) continue;
                    columnReference = columnReference2;
                }
                ((Predicate)queryTreeNode2).setTransitiveSearchClauseAdded(relationalOperator);
                boolean bl2 = false;
                for (QueryTreeNode queryTreeNode32 : predicateList2) {
                    ColumnReference columnReference4;
                    object4 = null;
                    RelationalOperator relationalOperator2 = (RelationalOperator)((Object)queryTreeNode32.getAndNode().getLeftOperand());
                    if (relationalOperator2 instanceof UnaryComparisonOperatorNode) {
                        columnReference4 = (ColumnReference)((UnaryComparisonOperatorNode)((Object)relationalOperator2)).getOperand();
                    } else {
                        columnReference4 = (ColumnReference)((BinaryComparisonOperatorNode)((Object)relationalOperator2)).getLeftOperand();
                        if (((BinaryComparisonOperatorNode)((Object)relationalOperator2)).getRightOperand() instanceof ConstantNode) {
                            object3 = (ConstantNode)((BinaryComparisonOperatorNode)((Object)relationalOperator2)).getRightOperand();
                            object4 = ((ConstantNode)object3).getValue();
                        } else {
                            object4 = null;
                        }
                    }
                    if (columnReference4.getTableNumber() != columnReference.getTableNumber() || columnReference4.getColumnNumber() != columnReference.getColumnNumber() || (object4 == null || object == null || object4.compare((DataValueDescriptor)object) != 0) && (object4 != null || object != null) || relationalOperator2.getOperator() != relationalOperator.getOperator() || !relationalOperator2.getClass().getName().equals(relationalOperator.getClass().getName())) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                OperatorNode operatorNode = (OperatorNode)((Object)relationalOperator.getTransitiveSearchClause((ColumnReference)columnReference.getClone()));
                if (operatorNode instanceof BinaryComparisonOperatorNode) {
                    ((BinaryComparisonOperatorNode)operatorNode).bindComparisonOperator();
                } else {
                    ((UnaryComparisonOperatorNode)operatorNode).bindComparisonOperator();
                }
                queryTreeNode32 = new BooleanConstantNode(true, this.getContextManager());
                object4 = new AndNode(operatorNode, (ValueNode)queryTreeNode32, this.getContextManager());
                ((AndNode)object4).postBindFixup();
                object3 = new JBitSet(n);
                ((BinaryOperatorNode)object4).categorize((JBitSet)object3, false);
                Predicate predicate = new Predicate((AndNode)object4, (JBitSet)object3, this.getContextManager());
                this.addPredicate(predicate);
                predicateList2.addElement(predicate);
            }
        }
        if (bl) {
            return;
        }
        for (n2 = this.size() - 1; n2 >= 0; --n2) {
            queryTreeNode = (Predicate)this.elementAt(n2);
            if (!((Predicate)queryTreeNode).transitiveSearchClauseAdded(binaryRelationalOperatorNode)) continue;
            this.removeElementAt(n2);
        }
    }

    void removeRedundantPredicates() {
        int n = this.size() - 1;
        while (n >= 0) {
            Predicate predicate = (Predicate)this.elementAt(n);
            int n2 = predicate.getEquivalenceClass();
            if (n2 == -1) {
                --n;
                continue;
            }
            for (int i = n - 1; i >= 0; --i) {
                Predicate predicate2 = (Predicate)this.elementAt(i);
                if (predicate2.getEquivalenceClass() != n2) continue;
                if (predicate2.isStartKey()) {
                    predicate.markStartKey();
                }
                if (predicate2.isStopKey()) {
                    predicate.markStopKey();
                }
                if ((predicate2.isStartKey() || predicate2.isStopKey()) && predicate2.isQualifier() && !predicate.isQualifier()) {
                    predicate.markQualifier();
                    ++this.numberOfQualifiers;
                }
                if (predicate2.isQualifier()) {
                    --this.numberOfQualifiers;
                }
                this.removeElementAt(i);
                --n;
            }
            --n;
        }
    }

    @Override
    public void transferPredicates(OptimizablePredicateList optimizablePredicateList, JBitSet jBitSet, Optimizable optimizable) throws StandardException {
        PredicateList predicateList = (PredicateList)optimizablePredicateList;
        for (int i = this.size() - 1; i >= 0; --i) {
            Predicate predicate = (Predicate)this.elementAt(i);
            if (!jBitSet.contains(predicate.getReferencedSet())) continue;
            if (predicate.isStartKey()) {
                --this.numberOfStartPredicates;
            }
            if (predicate.isStopKey()) {
                --this.numberOfStopPredicates;
            }
            if (predicate.isQualifier()) {
                --this.numberOfQualifiers;
            }
            predicate.clearScanFlags();
            predicateList.addPredicate(predicate);
            this.removeElementAt(i);
        }
        AccessPath accessPath = optimizable.getTrulyTheBestAccessPath();
        predicateList.orderUsefulPredicates(optimizable, accessPath.getConglomerateDescriptor(), false, accessPath.getNonMatchingIndexScan(), accessPath.getCoveringIndexScan());
        predicateList.countScanFlags();
    }

    @Override
    public void transferAllPredicates(OptimizablePredicateList optimizablePredicateList) throws StandardException {
        PredicateList predicateList = (PredicateList)optimizablePredicateList;
        for (Predicate predicate : this) {
            predicate.clearScanFlags();
            predicateList.addPredicate(predicate);
        }
        this.removeAllElements();
        this.numberOfStartPredicates = 0;
        this.numberOfStopPredicates = 0;
        this.numberOfQualifiers = 0;
    }

    @Override
    public void copyPredicatesToOtherList(OptimizablePredicateList optimizablePredicateList) throws StandardException {
        for (int i = 0; i < this.size(); ++i) {
            optimizablePredicateList.addOptPredicate(this.getOptPredicate(i));
        }
    }

    @Override
    public boolean isRedundantPredicate(int n) {
        Predicate predicate = (Predicate)this.elementAt(n);
        if (predicate.getEquivalenceClass() == -1) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (((Predicate)this.elementAt(i)).getEquivalenceClass() != predicate.getEquivalenceClass()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setPredicatesAndProperties(OptimizablePredicateList optimizablePredicateList) throws StandardException {
        PredicateList predicateList = (PredicateList)optimizablePredicateList;
        predicateList.removeAllElements();
        for (int i = 0; i < this.size(); ++i) {
            predicateList.addOptPredicate(this.getOptPredicate(i));
        }
        predicateList.numberOfStartPredicates = this.numberOfStartPredicates;
        predicateList.numberOfStopPredicates = this.numberOfStopPredicates;
        predicateList.numberOfQualifiers = this.numberOfQualifiers;
    }

    @Override
    public int startOperator(Optimizable optimizable) {
        int n = -1;
        int n2 = this.size();
        for (int i = n2 - 1; i >= 0; --i) {
            Predicate predicate = (Predicate)this.elementAt(i);
            if (!predicate.isStartKey()) continue;
            n = predicate.getStartOperator(optimizable);
            break;
        }
        return n;
    }

    @Override
    public void generateStopKey(ExpressionClassBuilderInterface expressionClassBuilderInterface, MethodBuilder methodBuilder, Optimizable optimizable) throws StandardException {
        ExpressionClassBuilder expressionClassBuilder = (ExpressionClassBuilder)expressionClassBuilderInterface;
        if (this.numberOfStopPredicates != 0) {
            MethodBuilder methodBuilder2 = expressionClassBuilder.newExprFun();
            LocalField localField = this.generateIndexableRow(expressionClassBuilder, this.numberOfStopPredicates);
            int n = 0;
            for (Predicate predicate : this) {
                if (!predicate.isStopKey()) continue;
                this.generateSetColumn(expressionClassBuilder, methodBuilder2, n, predicate, optimizable, localField, false);
                ++n;
            }
            this.finishKey(expressionClassBuilder, methodBuilder, methodBuilder2, localField);
            return;
        }
        methodBuilder.pushNull("org.apache.derby.iapi.services.loader.GeneratedMethod");
    }

    @Override
    public int stopOperator(Optimizable optimizable) {
        int n = -1;
        int n2 = this.size();
        for (int i = n2 - 1; i >= 0; --i) {
            Predicate predicate = (Predicate)this.elementAt(i);
            if (!predicate.isStopKey()) continue;
            n = predicate.getStopOperator(optimizable);
            break;
        }
        return n;
    }

    private void generateSingleQualifierCode(MethodBuilder methodBuilder, Optimizable optimizable, boolean bl, ExpressionClassBuilder expressionClassBuilder, RelationalOperator relationalOperator, LocalField localField, int n, int n2) throws StandardException {
        methodBuilder.getField(localField);
        methodBuilder.pushThis();
        methodBuilder.callMethod((short)182, expressionClassBuilder.getBaseClassName(), "getExecutionFactory", "org.apache.derby.iapi.sql.execute.ExecutionFactory", 0);
        if (bl) {
            relationalOperator.generateAbsoluteColumnId(methodBuilder, optimizable);
        } else {
            relationalOperator.generateRelativeColumnId(methodBuilder, optimizable);
        }
        relationalOperator.generateOperator(methodBuilder, optimizable);
        relationalOperator.generateQualMethod(expressionClassBuilder, methodBuilder, optimizable);
        expressionClassBuilder.pushThisAsActivation(methodBuilder);
        relationalOperator.generateOrderedNulls(methodBuilder);
        relationalOperator.generateNegate(methodBuilder, optimizable);
        relationalOperator.generateNegate(methodBuilder, optimizable);
        methodBuilder.push(relationalOperator.getOrderableVariantType(optimizable));
        methodBuilder.callMethod((short)185, "org.apache.derby.iapi.sql.execute.ExecutionFactory", "getQualifier", "org.apache.derby.iapi.store.access.Qualifier", 8);
        methodBuilder.push(n);
        methodBuilder.push(n2);
        methodBuilder.callMethod((short)184, expressionClassBuilder.getBaseClassName(), "setQualifier", "void", 4);
    }

    void generateInListValues(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        for (int i = this.size() - 1; i >= 0; --i) {
            Predicate predicate = (Predicate)this.elementAt(i);
            if (!predicate.isInListProbePredicate()) continue;
            this.removeOptPredicate(predicate);
            InListOperatorNode inListOperatorNode = predicate.getSourceInList();
            methodBuilder.getField(inListOperatorNode.generateListAsArray(expressionClassBuilder, methodBuilder));
            if (inListOperatorNode.sortDescending()) {
                methodBuilder.push(2);
            } else if (!inListOperatorNode.isOrdered()) {
                methodBuilder.push(1);
            } else {
                methodBuilder.push(3);
            }
            return;
        }
    }

    @Override
    public void generateQualifiers(ExpressionClassBuilderInterface expressionClassBuilderInterface, MethodBuilder methodBuilder, Optimizable optimizable, boolean bl) throws StandardException {
        int n;
        int n2;
        String string = "org.apache.derby.iapi.store.access.Qualifier[][]";
        if (this.numberOfQualifiers == 0) {
            methodBuilder.pushNull(string);
            return;
        }
        ExpressionClassBuilder expressionClassBuilder = (ExpressionClassBuilder)expressionClassBuilderInterface;
        MethodBuilder methodBuilder2 = expressionClassBuilder.getConstructor();
        MethodBuilder methodBuilder3 = expressionClassBuilder.getExecuteMethod();
        LocalField localField = expressionClassBuilder.newFieldDeclaration(2, string);
        methodBuilder3.getField(localField);
        methodBuilder3.callMethod((short)184, expressionClassBuilder.getBaseClassName(), "reinitializeQualifiers", "void", 1);
        int n3 = 0;
        for (n2 = 0; n2 < this.numberOfQualifiers; ++n2) {
            if (!((Predicate)this.elementAt(n2)).isOrList()) continue;
            ++n3;
        }
        methodBuilder2.pushNewArray("org.apache.derby.iapi.store.access.Qualifier[]", n3 + 1);
        methodBuilder2.setField(localField);
        methodBuilder2.getField(localField);
        methodBuilder2.push(0);
        methodBuilder2.push(this.numberOfQualifiers - n3);
        methodBuilder2.callMethod((short)184, expressionClassBuilder.getBaseClassName(), "allocateQualArray", "void", 3);
        this.orderQualifiers();
        n2 = 0;
        int n4 = this.size();
        boolean bl2 = false;
        for (n = 0; n < n4; ++n) {
            Predicate predicate = (Predicate)this.elementAt(n);
            if (!predicate.isQualifier()) continue;
            if (predicate.isOrList()) {
                bl2 = true;
                break;
            }
            this.generateSingleQualifierCode(methodBuilder2, optimizable, bl, expressionClassBuilder, predicate.getRelop(), localField, 0, n2);
            ++n2;
        }
        if (bl2) {
            n = 1;
            int n5 = n2;
            while (n5 < n4) {
                Predicate predicate = (Predicate)this.elementAt(n5);
                ArrayList<RelationalOperator> arrayList = new ArrayList<RelationalOperator>();
                ValueNode valueNode = predicate.getAndNode().getLeftOperand();
                while (valueNode instanceof OrNode) {
                    OrNode orNode = (OrNode)valueNode;
                    if (orNode.getLeftOperand() instanceof RelationalOperator) {
                        arrayList.add((RelationalOperator)((Object)orNode.getLeftOperand()));
                    }
                    valueNode = orNode.getRightOperand();
                }
                methodBuilder2.getField(localField);
                methodBuilder2.push(n);
                methodBuilder2.push(arrayList.size());
                methodBuilder2.callMethod((short)184, expressionClassBuilder.getBaseClassName(), "allocateQualArray", "void", 3);
                for (int i = 0; i < arrayList.size(); ++i) {
                    this.generateSingleQualifierCode(methodBuilder2, optimizable, bl, expressionClassBuilder, (RelationalOperator)arrayList.get(i), localField, n, i);
                }
                ++n2;
                ++n5;
                ++n;
            }
        }
        methodBuilder.getField(localField);
    }

    private void orderQualifiers() {
        int n;
        PredicateList[] predicateListArray = new PredicateList[5];
        for (n = predicateListArray.length - 1; n >= 0; --n) {
            predicateListArray[n] = new PredicateList(this.getContextManager());
        }
        for (Predicate predicate : this) {
            if (!predicate.isQualifier()) {
                predicateListArray[3].addElement(predicate);
                continue;
            }
            AndNode andNode = predicate.getAndNode();
            if (!(andNode.getLeftOperand() instanceof OrNode)) {
                RelationalOperator relationalOperator = (RelationalOperator)((Object)andNode.getLeftOperand());
                int n2 = relationalOperator.getOperator();
                switch (n2) {
                    case 1: 
                    case 7: {
                        predicateListArray[0].addElement(predicate);
                        break;
                    }
                    case 2: 
                    case 8: {
                        predicateListArray[2].addElement(predicate);
                        break;
                    }
                    default: {
                        predicateListArray[1].addElement(predicate);
                        break;
                    }
                }
                continue;
            }
            predicateListArray[4].addElement(predicate);
        }
        n = 0;
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < predicateListArray[i].size(); ++j) {
                this.setElementAt((Predicate)predicateListArray[i].elementAt(j), n++);
            }
        }
    }

    @Override
    public void generateStartKey(ExpressionClassBuilderInterface expressionClassBuilderInterface, MethodBuilder methodBuilder, Optimizable optimizable) throws StandardException {
        ExpressionClassBuilder expressionClassBuilder = (ExpressionClassBuilder)expressionClassBuilderInterface;
        if (this.numberOfStartPredicates != 0) {
            MethodBuilder methodBuilder2 = expressionClassBuilder.newExprFun();
            LocalField localField = this.generateIndexableRow(expressionClassBuilder, this.numberOfStartPredicates);
            int n = 0;
            for (Predicate predicate : this) {
                if (!predicate.isStartKey()) continue;
                this.generateSetColumn(expressionClassBuilder, methodBuilder2, n, predicate, optimizable, localField, true);
                ++n;
            }
            this.finishKey(expressionClassBuilder, methodBuilder, methodBuilder2, localField);
            return;
        }
        methodBuilder.pushNull("org.apache.derby.iapi.services.loader.GeneratedMethod");
    }

    @Override
    public boolean sameStartStopPosition() throws StandardException {
        if (this.numberOfStartPredicates != this.numberOfStopPredicates) {
            return false;
        }
        for (Predicate predicate : this) {
            if (predicate.isStartKey() && !predicate.isStopKey() || predicate.isStopKey() && !predicate.isStartKey()) {
                return false;
            }
            if (!(predicate.getAndNode().getLeftOperand() instanceof InListOperatorNode)) continue;
            return false;
        }
        return true;
    }

    private LocalField generateIndexableRow(ExpressionClassBuilder expressionClassBuilder, int n) {
        MethodBuilder methodBuilder = expressionClassBuilder.getConstructor();
        expressionClassBuilder.pushGetExecutionFactoryExpression(methodBuilder);
        methodBuilder.push(n);
        methodBuilder.callMethod((short)185, "org.apache.derby.iapi.sql.execute.ExecutionFactory", "getIndexableRow", "org.apache.derby.iapi.sql.execute.ExecIndexRow", 1);
        LocalField localField = expressionClassBuilder.newFieldDeclaration(2, "org.apache.derby.iapi.sql.execute.ExecIndexRow");
        methodBuilder.setField(localField);
        return localField;
    }

    private void generateSetColumn(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder, int n, Predicate predicate, Optimizable optimizable, LocalField localField, boolean bl) throws StandardException {
        MethodBuilder methodBuilder2;
        boolean bl2 = false;
        if (predicate.compareWithKnownConstant(optimizable, false)) {
            bl2 = true;
            methodBuilder2 = expressionClassBuilder.getConstructor();
        } else {
            methodBuilder2 = methodBuilder;
        }
        int[] nArray = optimizable.getTrulyTheBestAccessPath().getConglomerateDescriptor().getIndexDescriptor().baseColumnPositions();
        boolean[] blArray = optimizable.getTrulyTheBestAccessPath().getConglomerateDescriptor().getIndexDescriptor().isAscending();
        boolean bl3 = predicate.getAndNode().getLeftOperand() instanceof InListOperatorNode;
        methodBuilder2.getField(localField);
        methodBuilder2.push(n + 1);
        if (bl3) {
            predicate.getSourceInList().generateStartStopKey(blArray[n], bl, expressionClassBuilder, methodBuilder2);
        } else {
            predicate.generateExpressionOperand(optimizable, nArray[n], expressionClassBuilder, methodBuilder2);
        }
        methodBuilder2.upCast("org.apache.derby.iapi.types.DataValueDescriptor");
        methodBuilder2.callMethod((short)185, "org.apache.derby.iapi.sql.Row", "setColumn", "void", 2);
        if (!bl3) {
            RelationalOperator relationalOperator = predicate.getRelop();
            boolean bl4 = relationalOperator.orderedNulls();
            if (!bl4 && !relationalOperator.getColumnOperand(optimizable).getTypeServices().isNullable()) {
                if (bl2) {
                    bl4 = true;
                } else {
                    ValueNode valueNode = relationalOperator.getExpressionOperand(optimizable.getTableNumber(), nArray[n], (FromTable)optimizable);
                    if (valueNode instanceof ColumnReference) {
                        boolean bl5 = bl4 = !((ColumnReference)valueNode).getTypeServices().isNullable();
                    }
                }
            }
            if (bl4) {
                methodBuilder2.getField(localField);
                methodBuilder2.push(n);
                methodBuilder2.callMethod((short)185, "org.apache.derby.iapi.sql.execute.ExecIndexRow", "orderedNulls", "void", 1);
            }
        }
    }

    private void finishKey(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder, MethodBuilder methodBuilder2, LocalField localField) {
        methodBuilder2.getField(localField);
        methodBuilder2.methodReturn();
        methodBuilder2.complete();
        expressionClassBuilder.pushMethodReference(methodBuilder, methodBuilder2);
    }

    boolean constantColumn(ColumnReference columnReference) {
        boolean bl = false;
        for (Predicate predicate : this) {
            ValueNode valueNode;
            RelationalOperator relationalOperator = predicate.getRelop();
            if (!predicate.isRelationalOpPredicate()) continue;
            if (relationalOperator.getOperator() == 1) {
                valueNode = relationalOperator.getOperand(columnReference, predicate.getReferencedSet().size(), true);
                if (valueNode == null || !valueNode.isConstantExpression()) continue;
                bl = true;
                break;
            }
            if (relationalOperator.getOperator() != 7 || (valueNode = (ColumnReference)relationalOperator.getOperand(columnReference, predicate.getReferencedSet().size(), false)) == null) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public void adjustForSortElimination(RequiredRowOrdering requiredRowOrdering) throws StandardException {
        if (requiredRowOrdering == null) {
            return;
        }
        OrderByList orderByList = (OrderByList)requiredRowOrdering;
        for (Predicate predicate : this) {
            BinaryRelationalOperatorNode binaryRelationalOperatorNode;
            if (!predicate.isInListProbePredicate() || !orderByList.requiresDescending((ColumnReference)(binaryRelationalOperatorNode = (BinaryRelationalOperatorNode)predicate.getRelop()).getLeftOperand(), predicate.getReferencedSet().size())) continue;
            predicate.getSourceInList(true).markSortDescending();
        }
    }

    @Override
    public double selectivity(Optimizable optimizable) throws StandardException {
        Object object;
        int n;
        int n2;
        int n3;
        TableDescriptor tableDescriptor = optimizable.getTableDescriptor();
        ConglomerateDescriptor[] conglomerateDescriptorArray = tableDescriptor.getConglomerateDescriptors();
        int n4 = this.size();
        int n5 = conglomerateDescriptorArray.length;
        if (n5 == 1) {
            return -1.0;
        }
        if (n4 == 0) {
            return -1.0;
        }
        boolean bl = true;
        PredicateList predicateList = new PredicateList(this.getContextManager());
        for (n3 = 0; n3 < n4; ++n3) {
            if (this.isRedundantPredicate(n3)) continue;
            predicateList.addOptPredicate((OptimizablePredicate)this.elementAt(n3));
        }
        n3 = predicateList.size();
        PredicateWrapperList[] predicateWrapperListArray = new PredicateWrapperList[n5];
        for (n2 = 0; n2 < n5; ++n2) {
            ConglomerateDescriptor conglomerateDescriptor = conglomerateDescriptorArray[n2];
            if (!conglomerateDescriptor.isIndex() || !tableDescriptor.statisticsExist(conglomerateDescriptor)) continue;
            int[] nArray = conglomerateDescriptor.getIndexDescriptor().baseColumnPositions();
            for (int i = 0; i < n3; ++i) {
                Predicate predicate = (Predicate)predicateList.elementAt(i);
                n = predicate.hasEqualOnColumnList(nArray, optimizable);
                if (n < 0) continue;
                bl = false;
                if (predicateWrapperListArray[n2] == null) {
                    predicateWrapperListArray[n2] = new PredicateWrapperList(n3);
                }
                object = new PredicateWrapper(n, predicate, i);
                predicateWrapperListArray[n2].insert((PredicateWrapper)object);
            }
        }
        if (bl) {
            return -1.0;
        }
        n2 = -1;
        for (int i = 0; i < n5; ++i) {
            if (predicateWrapperListArray[i] == null) continue;
            predicateWrapperListArray[i].retainLeadingContiguous();
        }
        this.calculateWeight(predicateWrapperListArray, n3);
        double d = 1.0;
        ArrayList<Predicate> arrayList = new ArrayList<Predicate>();
        do {
            arrayList.clear();
            int n6 = this.chooseLongestMatch(predicateWrapperListArray, arrayList, n3);
            if (n6 == -1) break;
            d *= tableDescriptor.selectivityForConglomerate(conglomerateDescriptorArray[n6], arrayList.size());
            for (n = 0; n < arrayList.size(); ++n) {
                object = arrayList.get(n);
                predicateList.removeOptPredicate((OptimizablePredicate)object);
            }
        } while (predicateList.size() != 0);
        if (predicateList.size() != 0) {
            d *= predicateList.selectivityNoStatistics(optimizable);
        }
        return d;
    }

    private void calculateWeight(PredicateWrapperList[] predicateWrapperListArray, int n) {
        int n2;
        int n3;
        int[] nArray = new int[n];
        for (n3 = 0; n3 < predicateWrapperListArray.length; ++n3) {
            if (predicateWrapperListArray[n3] == null) continue;
            for (n2 = 0; n2 < predicateWrapperListArray[n3].size(); ++n2) {
                int n4 = predicateWrapperListArray[n3].elementAt(n2).getPredicateID();
                nArray[n4] = nArray[n4] + (n - n2);
            }
        }
        for (n3 = 0; n3 < predicateWrapperListArray.length; ++n3) {
            n2 = 0;
            if (predicateWrapperListArray[n3] == null) continue;
            for (int i = 0; i < predicateWrapperListArray[n3].size(); ++i) {
                n2 += nArray[predicateWrapperListArray[n3].elementAt(i).getPredicateID()];
            }
            predicateWrapperListArray[n3].setWeight(n2);
        }
    }

    private int chooseLongestMatch(PredicateWrapperList[] predicateWrapperListArray, List<Predicate> list, int n) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = -1;
        for (int i = 0; i < predicateWrapperListArray.length; ++i) {
            if (predicateWrapperListArray[i] == null || predicateWrapperListArray[i].uniqueSize() == 0) continue;
            if (predicateWrapperListArray[i].uniqueSize() > n3) {
                n3 = predicateWrapperListArray[i].uniqueSize();
                n5 = i;
                n4 = predicateWrapperListArray[i].getWeight();
            }
            if (predicateWrapperListArray[i].uniqueSize() != n3 || predicateWrapperListArray[i].getWeight() > n4) continue;
            n5 = i;
            n3 = predicateWrapperListArray[i].uniqueSize();
            n4 = predicateWrapperListArray[i].getWeight();
        }
        if (n5 == -1) {
            return -1;
        }
        PredicateWrapperList predicateWrapperList = predicateWrapperListArray[n5];
        List<PredicateWrapper> list2 = predicateWrapperList.createLeadingUnique();
        for (n2 = 0; n2 < list2.size(); ++n2) {
            Predicate predicate = list2.get(n2).getPredicate();
            list.add(predicate);
            for (int i = 0; i < predicateWrapperListArray.length; ++i) {
                if (predicateWrapperListArray[i] == null) continue;
                predicateWrapperList = predicateWrapperListArray[i];
                predicateWrapperList.removeElement(predicate);
            }
        }
        for (n2 = 0; n2 < predicateWrapperListArray.length; ++n2) {
            if (predicateWrapperListArray[n2] == null) continue;
            predicateWrapperListArray[n2].retainLeadingContiguous();
        }
        this.calculateWeight(predicateWrapperListArray, n);
        return n5;
    }

    private double selectivityNoStatistics(Optimizable optimizable) throws StandardException {
        double d = 1.0;
        for (int i = 0; i < this.size(); ++i) {
            OptimizablePredicate optimizablePredicate = (OptimizablePredicate)this.elementAt(i);
            d *= optimizablePredicate.selectivity(optimizable);
        }
        return d;
    }

    private static class PredicateWrapperList {
        private final ArrayList<PredicateWrapper> pwList;
        int numPreds;
        int numDuplicates;
        int weight;

        PredicateWrapperList(int n) {
            this.pwList = new ArrayList(n);
        }

        void removeElement(Predicate predicate) {
            for (int i = this.numPreds - 1; i >= 0; --i) {
                Predicate predicate2 = this.elementAt(i).getPredicate();
                if (predicate2 != predicate) continue;
                this.removeElementAt(i);
            }
        }

        void removeElementAt(int n) {
            PredicateWrapper predicateWrapper;
            if (n < this.numPreds - 1 && (predicateWrapper = this.elementAt(n + 1)).getIndexPosition() == n) {
                --this.numDuplicates;
            }
            this.pwList.remove(n);
            --this.numPreds;
        }

        PredicateWrapper elementAt(int n) {
            return this.pwList.get(n);
        }

        void insert(PredicateWrapper predicateWrapper) {
            int n;
            for (n = 0; n < this.pwList.size(); ++n) {
                if (predicateWrapper.getIndexPosition() == this.elementAt(n).getIndexPosition()) {
                    ++this.numDuplicates;
                }
                if (predicateWrapper.before(this.elementAt(n))) break;
            }
            ++this.numPreds;
            this.pwList.add(n, predicateWrapper);
        }

        int size() {
            return this.numPreds;
        }

        int uniqueSize() {
            if (this.numPreds > 0) {
                return this.numPreds - this.numDuplicates;
            }
            return 0;
        }

        void retainLeadingContiguous() {
            int n;
            if (this.pwList.isEmpty()) {
                return;
            }
            if (this.elementAt(0).getIndexPosition() != 0) {
                this.pwList.clear();
                this.numDuplicates = 0;
                this.numPreds = 0;
                return;
            }
            for (n = 0; n < this.numPreds - 1 && this.elementAt(n).contiguous(this.elementAt(n + 1)); ++n) {
            }
            for (int i = this.numPreds - 1; i > n; --i) {
                if (this.elementAt(i).getIndexPosition() == this.elementAt(i - 1).getIndexPosition()) {
                    --this.numDuplicates;
                }
                this.pwList.remove(i);
            }
            this.numPreds = n + 1;
        }

        private List<PredicateWrapper> createLeadingUnique() {
            if (this.numPreds == 0) {
                return null;
            }
            int n = this.elementAt(0).getIndexPosition();
            if (n != 0) {
                return null;
            }
            ArrayList<PredicateWrapper> arrayList = new ArrayList<PredicateWrapper>();
            arrayList.add(this.elementAt(0));
            for (int i = 1; i < this.numPreds; ++i) {
                if (this.elementAt(i).getIndexPosition() == n) continue;
                n = this.elementAt(i).getIndexPosition();
                arrayList.add(this.elementAt(i));
            }
            return arrayList;
        }

        void setWeight(int n) {
            this.weight = n;
        }

        int getWeight() {
            return this.weight;
        }
    }

    private static class PredicateWrapper {
        int indexPosition;
        Predicate pred;
        int predicateID;

        PredicateWrapper(int n, Predicate predicate, int n2) {
            this.indexPosition = n;
            this.pred = predicate;
            this.predicateID = n2;
        }

        int getIndexPosition() {
            return this.indexPosition;
        }

        Predicate getPredicate() {
            return this.pred;
        }

        int getPredicateID() {
            return this.predicateID;
        }

        boolean before(PredicateWrapper predicateWrapper) {
            return this.indexPosition < predicateWrapper.getIndexPosition();
        }

        boolean contiguous(PredicateWrapper predicateWrapper) {
            int n = predicateWrapper.getIndexPosition();
            return this.indexPosition == n || this.indexPosition - n == 1 || this.indexPosition - n == -1;
        }
    }
}

