/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.composite;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.glassfish.admin.rest.composite.RestModel;
import org.glassfish.admin.rest.composite.metadata.RestModelMetadata;

public class RestCollection<T> {
    private List<T> models = new ArrayList<T>();
    private List<RestModelMetadata> metadata = new ArrayList<RestModelMetadata>();

    public void put(String id, T model) {
        this.models.add(model);
        this.metadata.add(new RestModelMetadata(id));
    }

    public T get(String id) {
        return this.get(new RestModelMetadata(id));
    }

    public T remove(String id) {
        return this.remove(new RestModelMetadata(id));
    }

    public boolean containsKey(String id) {
        return this.containsKey(new RestModelMetadata(id));
    }

    public int size() {
        return this.models.size();
    }

    public boolean isEmpty() {
        return this.models.isEmpty();
    }

    public boolean containsKey(Object key) {
        this.checkClass(RestModelMetadata.class, key.getClass());
        RestModelMetadata desired = (RestModelMetadata)key;
        boolean found = false;
        for (RestModelMetadata md : this.metadata) {
            if (!md.equals(desired)) continue;
            found = true;
            break;
        }
        return found;
    }

    public boolean containsValue(Object value) {
        this.checkClass(RestModel.class, value.getClass());
        RestModel desired = (RestModel)value;
        boolean found = false;
        for (T rm : this.models) {
            if (!rm.equals(desired)) continue;
            found = true;
            break;
        }
        return found;
    }

    public T get(Object key) {
        this.checkClass(RestModelMetadata.class, key.getClass());
        RestModelMetadata desired = (RestModelMetadata)key;
        T result = null;
        int total = this.metadata.size();
        for (int index = 0; index < total; ++index) {
            if (!this.metadata.get(index).equals(desired)) continue;
            result = this.models.get(index);
            break;
        }
        return result;
    }

    public T put(RestModelMetadata key, T value) {
        this.models.add(value);
        this.metadata.add(key);
        return value;
    }

    public T remove(Object key) {
        this.checkClass(RestModelMetadata.class, key.getClass());
        RestModelMetadata desired = (RestModelMetadata)key;
        T result = null;
        int total = this.metadata.size();
        for (int index = 0; index < total; ++index) {
            if (!this.metadata.get(index).equals(desired)) continue;
            result = this.models.get(index);
            this.models.remove(index);
            this.metadata.remove(index);
            break;
        }
        return result;
    }

    public void putAll(Map<? extends RestModelMetadata, ? extends T> m) {
        for (Map.Entry<RestModelMetadata, T> entry : m.entrySet()) {
            this.metadata.add(entry.getKey());
            this.models.add(entry.getValue());
        }
    }

    public void clear() {
        this.models.clear();
        this.metadata.clear();
    }

    public Set<RestModelMetadata> keySet() {
        return new TreeSet<RestModelMetadata>(this.metadata);
    }

    public Collection<T> values() {
        return new RestModelSet<T>(this.models);
    }

    public Set<Map.Entry<RestModelMetadata, T>> entrySet() {
        if (this.metadata.size() != this.models.size()) {
            throw new IllegalStateException("InternalError: keys and values out of sync");
        }
        ArrayList<RestCollectionEntry<T>> al = new ArrayList<RestCollectionEntry<T>>();
        for (int i = 0; i < this.metadata.size(); ++i) {
            al.add(new RestCollectionEntry<T>(this.metadata.get(i), this.models.get(i)));
        }
        return new TreeSet<Map.Entry<RestModelMetadata, T>>(al);
    }

    protected void checkClass(Class<?> desired, Class<?> given) throws IllegalArgumentException {
        if (!desired.isAssignableFrom(given)) {
            throw new IllegalArgumentException("Expected " + desired.getName() + ". Found " + given.getName());
        }
    }

    private static class RestModelSet<T>
    extends AbstractSet<T> {
        private List<T> items;

        private RestModelSet(List<T> items) {
            this.items = items;
        }

        @Override
        public Iterator<T> iterator() {
            return this.items.iterator();
        }

        @Override
        public int size() {
            return this.items.size();
        }

        @Override
        public boolean containsAll(Collection<?> objects) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private class RestCollectionEntry<T>
    implements Map.Entry<RestModelMetadata, T>,
    Comparable {
        private RestModelMetadata key;
        private T value;

        public RestCollectionEntry(RestModelMetadata key, T value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public RestModelMetadata getKey() {
            return this.key;
        }

        @Override
        public T getValue() {
            return this.value;
        }

        @Override
        public T setValue(T newValue) {
            this.value = newValue;
            return newValue;
        }

        public int compareTo(Object o) {
            if (!(o instanceof RestCollectionEntry)) {
                throw new IllegalArgumentException("Huh? Not a MapEntry?");
            }
            RestModelMetadata otherKey = ((RestCollectionEntry)o).getKey();
            return this.key.compareTo((Comparable)otherKey);
        }

        @Override
        public int hashCode() {
            int hash = 3;
            return hash;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RestCollectionEntry other = (RestCollectionEntry)obj;
            if (!(this.key == other.key || this.key != null && this.key.equals(other.key))) {
                return false;
            }
            return this.value == other.value || this.value != null && this.value.equals(other.value);
        }
    }
}

