/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.Config;
import io.helidon.config.spi.ConfigFilter;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class OverrideConfigFilter
implements ConfigFilter {
    private final Supplier<List<Map.Entry<Predicate<Config.Key>, String>>> overrideValuesSupplier;

    public OverrideConfigFilter(Supplier<List<Map.Entry<Predicate<Config.Key>, String>>> overrideValuesSupplier) {
        this.overrideValuesSupplier = overrideValuesSupplier;
    }

    public String apply(Config.Key key, String stringValue) {
        List<Map.Entry<Predicate<Config.Key>, String>> overrideValues = this.overrideValuesSupplier.get();
        if (overrideValues != null) {
            for (Map.Entry<Predicate<Config.Key>, String> entry : overrideValues) {
                if (!entry.getKey().test(key)) continue;
                return entry.getValue();
            }
        }
        return stringValue;
    }
}

