/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.mechanisms.openid.controller;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Optional;
import org.glassfish.soteria.Utils;
import org.glassfish.soteria.mechanisms.openid.OpenIdState;
import org.glassfish.soteria.mechanisms.openid.domain.OpenIdConfiguration;
import org.glassfish.soteria.servlet.HttpStorageController;

@ApplicationScoped
public class StateController {
    private static final String STATE_KEY = "oidc.state";
    @Inject
    private OpenIdConfiguration configuration;

    public void store(OpenIdState state, OpenIdConfiguration configuration, HttpServletRequest request, HttpServletResponse response) {
        HttpStorageController storage = HttpStorageController.getInstance(configuration, request, response);
        storage.store(STATE_KEY, state.getValue(), null);
    }

    public Optional<OpenIdState> get(HttpServletRequest request, HttpServletResponse response) {
        return HttpStorageController.getInstance(this.configuration, request, response).getAsString(STATE_KEY).filter(k -> !Utils.isEmpty(k)).map(OpenIdState::new);
    }

    public void remove(HttpServletRequest request, HttpServletResponse response) {
        HttpStorageController.getInstance(this.configuration, request, response).remove(STATE_KEY);
    }
}

