/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.archivist.AppClientArchivist;
import com.sun.enterprise.deployment.deploy.shared.OutputJarArchive;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.api.deployment.archive.WritableArchiveEntry;
import org.glassfish.appclient.server.core.AppClientDeployerHelper;
import org.glassfish.appclient.server.core.jws.servedcontent.DynamicContent;
import org.glassfish.appclient.server.core.jws.servedcontent.FixedContent;
import org.glassfish.appclient.server.core.jws.servedcontent.TokenHelper;
import org.glassfish.deployment.common.Artifacts;
import org.glassfish.deployment.versioning.VersioningSyntaxException;
import org.glassfish.deployment.versioning.VersioningUtils;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;

public class StandaloneAppClientDeployerHelper
extends AppClientDeployerHelper {
    private static final Logger logger = Logger.getLogger("jakarta.enterprise.system.container.appclient", "org.glassfish.appclient.server.LogMessages");
    private Set<Artifacts.FullAndPartURIs> clientLevelDownloads = null;

    StandaloneAppClientDeployerHelper(DeploymentContext dc, ApplicationClientDescriptor bundleDesc, AppClientArchivist archivist, ClassLoader gfClientModuleClassLoader, Application application, ServiceLocator habitat) throws IOException {
        super(dc, bundleDesc, archivist, gfClientModuleClassLoader, application, habitat);
    }

    private String facadeNameOnly(DeploymentContext dc) {
        DeployCommandParameters params = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
        String appName = params.name();
        try {
            return VersioningUtils.getUntaggedName((String)appName) + "Client";
        }
        catch (VersioningSyntaxException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            return appName + "Client";
        }
    }

    @Override
    public File rootForSignedFilesInApp() {
        return new File(this.dc().getScratchDir("xml"), "signed/");
    }

    @Override
    protected void prepareJARs() throws IOException, URISyntaxException {
        super.prepareJARs();
        this.copyOriginalAppClientJAR(this.dc());
    }

    @Override
    protected void addTopLevelContentToClientFacade(OutputJarArchive facadeArchive) throws IOException {
        this.addClientPolicyFiles(facadeArchive);
    }

    @Override
    public void createAndAddLibraryJNLPs(AppClientDeployerHelper helper, TokenHelper tHelper, Map<String, DynamicContent> dynamicContent) {
    }

    @Override
    protected void copyFileToTopLevelJAR(OutputJarArchive clientFacadeArchive, File inputFile, String pathInJar) throws IOException {
        try (WritableArchiveEntry os = clientFacadeArchive.putNextEntry(pathInJar);){
            FileUtils.copy((File)inputFile, (OutputStream)os);
        }
    }

    @Override
    public FixedContent fixedContentWithinEAR(String uriString) {
        return null;
    }

    @Override
    protected String facadeFileNameAndType(DeploymentContext dc) {
        return this.facadeNameOnly(dc) + ".jar";
    }

    @Override
    public URI facadeServerURI(DeploymentContext dc) {
        File genXMLDir = dc.getScratchDir("xml");
        return genXMLDir.toURI().resolve(this.facadeFileNameAndType(dc));
    }

    @Override
    public URI facadeUserURI(DeploymentContext dc) {
        return URI.create(this.facadeFileNameAndType(dc));
    }

    @Override
    public URI groupFacadeUserURI(DeploymentContext dc) {
        return null;
    }

    @Override
    public URI groupFacadeServerURI(DeploymentContext dc) {
        return null;
    }

    @Override
    public URI appClientUserURI(DeploymentContext dc) {
        return URI.create(this.facadeNameOnly(dc) + "/" + String.valueOf(this.appClientURIWithinApp(dc)));
    }

    @Override
    public URI appClientServerURI(DeploymentContext dc) {
        File genXMLDir = dc.getScratchDir("xml");
        return genXMLDir.toURI().resolve(this.appClientURIWithinApp(dc));
    }

    @Override
    public URI appClientServerOriginalAnchor(DeploymentContext dc) {
        return ((ExtendedDeploymentContext)dc).getOriginalSource().getURI();
    }

    @Override
    public URI appClientURIWithinApp(DeploymentContext dc) {
        Object uriText = this.appClientDesc().getModuleDescriptor().getArchiveUri();
        String uriRoot = "";
        Object archiveName = uriText;
        int lastIndex = ((String)uriText).lastIndexOf("/");
        if (lastIndex > -1) {
            uriRoot = ((String)uriText).substring(0, lastIndex);
            archiveName = ((String)uriText).substring(lastIndex);
        }
        try {
            archiveName = VersioningUtils.getUntaggedName((String)archiveName);
        }
        catch (VersioningSyntaxException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        if (!((String)archiveName).endsWith(".jar")) {
            archiveName = (String)archiveName + ".jar";
        }
        uriText = uriRoot + (String)archiveName;
        return URI.create((String)uriText);
    }

    @Override
    protected Set<Artifacts.FullAndPartURIs> clientLevelDownloads() throws IOException {
        if (this.clientLevelDownloads == null) {
            HashSet<Artifacts.FullAndPartURIs> downloads = new HashSet<Artifacts.FullAndPartURIs>();
            downloads.add(new Artifacts.FullAndPartURIs(this.appClientServerURI(this.dc()), this.appClientUserURI(this.dc())));
            downloads.add(new Artifacts.FullAndPartURIs(this.facadeServerURI(this.dc()), this.facadeUserURI(this.dc())));
            this.clientLevelDownloads = downloads;
        }
        return this.clientLevelDownloads;
    }

    @Override
    public Set<Artifacts.FullAndPartURIs> earLevelDownloads() throws IOException {
        return Collections.EMPTY_SET;
    }

    @Override
    public URI appClientUserURIForFacade(DeploymentContext dc) {
        return this.appClientUserURI(dc);
    }

    @Override
    public URI URIWithinAppDir(DeploymentContext dc, URI absoluteURI) {
        return dc.getSource().getURI().relativize(absoluteURI);
    }

    @Override
    public String pathToAppclientWithinApp(DeploymentContext dc) {
        return "";
    }

    @Override
    protected String facadeClassPath() {
        return this.appClientUserURI(this.dc()).toASCIIString();
    }

    protected void copyOriginalAppClientJAR(DeploymentContext dc) throws IOException {
        try (ReadableArchive originalSource = ((ExtendedDeploymentContext)dc).getOriginalSource();){
            originalSource.open(originalSource.getURI());
            try (OutputJarArchive target = new OutputJarArchive();){
                target.create(this.appClientServerURI(dc));
                Manifest originalManifest = originalSource.getManifest();
                try (WritableArchiveEntry os = target.putNextEntry("META-INF/MANIFEST.MF");){
                    originalManifest.write((OutputStream)os);
                }
                StandaloneAppClientDeployerHelper.copyArchive(originalSource, (WritableArchive)target, Collections.emptySet());
            }
        }
    }

    @Override
    protected String PUScanTargets() {
        return null;
    }
}

