/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.beans.PropertyVetoException;
import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.grizzly.config.dom.Http;
import org.glassfish.grizzly.config.dom.NetworkConfig;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.NetworkListeners;
import org.glassfish.grizzly.config.dom.Protocol;
import org.glassfish.grizzly.config.dom.ProtocolFinder;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.glassfish.web.admin.LogFacade;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigCode;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-network-listener")
@PerLookup
@I18n(value="create.network.listener")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class CreateNetworkListener
implements AdminCommand {
    private static final ResourceBundle rb = LogFacade.getLogger().getResourceBundle();
    @Param(name="address", optional=true)
    String address;
    @Param(name="listenerport", optional=false, alias="Port")
    String port;
    @Param(name="threadpool", optional=true, defaultValue="http-thread-pool", alias="threadPool")
    String threadPool;
    @Param(name="protocol", optional=false)
    String protocol;
    @Param(name="name", primary=true)
    String listenerName;
    @Param(name="transport", optional=true, defaultValue="tcp")
    String transport;
    @Param(name="enabled", optional=true, defaultValue="true")
    Boolean enabled;
    @Param(name="jkenabled", optional=true, defaultValue="false", alias="jkEnabled")
    Boolean jkEnabled;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Inject
    @Named(value="default-instance-name")
    Config config;
    @Inject
    ServiceLocator services;
    @Inject
    Domain domain;

    public void execute(AdminCommandContext context) {
        Target targetUtil = (Target)this.services.getService(Target.class, new Annotation[0]);
        Config newConfig = targetUtil.getConfig(this.target);
        if (newConfig != null) {
            this.config = newConfig;
        }
        ActionReport report = context.getActionReport();
        NetworkConfig networkConfig = this.config.getNetworkConfig();
        NetworkListeners nls = networkConfig.getNetworkListeners();
        for (NetworkListener networkListener : nls.getNetworkListener()) {
            if (!networkListener.getName().equals(this.listenerName)) continue;
            report.setMessage(MessageFormat.format(rb.getString("AS-WEB-ADMIN-00010"), this.listenerName));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (!this.verifyUniquePort(networkConfig)) {
            report.setMessage(MessageFormat.format(rb.getString("AS-WEB-ADMIN-00009"), this.port, this.address));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        Protocol prot = networkConfig.findProtocol(this.protocol);
        if (prot == null) {
            report.setMessage(MessageFormat.format(rb.getString("AS-WEB-ADMIN-00013"), this.protocol));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (prot.getHttp() == null && prot.getPortUnification() == null) {
            report.setMessage(MessageFormat.format(rb.getString("AS-WEB-ADMIN-00011"), this.protocol));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply((ConfigCode)new ConfigCode(){

                public Object run(ConfigBeanProxy ... params) throws TransactionFailure, PropertyVetoException {
                    NetworkListeners listeners = (NetworkListeners)params[0];
                    NetworkListener newNetworkListener = (NetworkListener)listeners.createChild(NetworkListener.class);
                    newNetworkListener.setProtocol(CreateNetworkListener.this.protocol);
                    newNetworkListener.setTransport(CreateNetworkListener.this.transport);
                    newNetworkListener.setEnabled(CreateNetworkListener.this.enabled.toString());
                    newNetworkListener.setJkEnabled(CreateNetworkListener.this.jkEnabled.toString());
                    newNetworkListener.setPort(CreateNetworkListener.this.port);
                    newNetworkListener.setThreadPool(CreateNetworkListener.this.threadPool);
                    newNetworkListener.setName(CreateNetworkListener.this.listenerName);
                    newNetworkListener.setAddress(CreateNetworkListener.this.address);
                    listeners.getNetworkListener().add(newNetworkListener);
                    ((VirtualServer)params[1]).addNetworkListener(CreateNetworkListener.this.listenerName);
                    return newNetworkListener;
                }
            }, (ConfigBeanProxy[])new ConfigBeanProxy[]{nls, this.findVirtualServer(prot)});
        }
        catch (TransactionFailure e) {
            e.printStackTrace();
            report.setMessage(MessageFormat.format(rb.getString("AS-WEB-ADMIN-00012"), this.listenerName) + (e.getMessage() == null ? "No reason given" : e.getMessage()));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private VirtualServer findVirtualServer(Protocol protocol) {
        String name = null;
        Http http = protocol.getHttp();
        if (http != null) {
            name = http.getDefaultVirtualServer();
        } else {
            List finders = protocol.getPortUnification().getProtocolFinder();
            for (ProtocolFinder finder : finders) {
                Protocol p;
                if (name != null || (p = finder.findProtocol()).getHttp() == null) continue;
                name = p.getHttp().getDefaultVirtualServer();
            }
        }
        return this.config.getHttpService().getVirtualServerByName(name);
    }

    private boolean verifyUniquePort(NetworkConfig networkConfig) {
        for (NetworkListener listener : networkConfig.getNetworkListeners().getNetworkListener()) {
            if (!listener.getPort().trim().equals(this.port) || !listener.getAddress().trim().equals(this.address)) continue;
            return false;
        }
        return true;
    }
}

