/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.JMQXid;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class TransactionDetails {
    private int type;
    private TransactionUID tid;
    private JMQXid xid;
    private int state;
    private boolean complete;

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public TransactionUID getTid() {
        return this.tid;
    }

    public void setTid(TransactionUID tid) {
        this.tid = tid;
    }

    public void readContent(DataInputStream dis) throws IOException, BrokerException {
        this.type = dis.readByte();
        long tid = dis.readLong();
        TransactionUID txUID = new TransactionUID(tid);
        this.setTid(txUID);
        int state = dis.readInt();
        this.setState(state);
        int completeVal = dis.readInt();
        this.complete = completeVal == 1;
        this.readXid(dis);
    }

    public void writeContent(DataOutputStream dos) throws IOException {
        dos.writeByte(this.type);
        dos.writeLong(this.getTid().longValue());
        dos.writeInt(this.getState());
        if (this.complete) {
            dos.writeInt(1);
        } else {
            dos.writeInt(0);
        }
        this.writeXid(dos);
    }

    protected void readXid(DataInputStream dis) throws IOException {
        boolean xidExists = dis.readBoolean();
        if (xidExists) {
            this.xid = JMQXid.read(dis);
        }
    }

    protected void writeXid(DataOutputStream dos) throws IOException {
        if (this.getXid() == null) {
            dos.writeBoolean(false);
        } else {
            dos.writeBoolean(true);
            this.xid.write(dos);
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("type=").append(this.type);
        s.append(" state=").append(TransactionState.toString(this.state));
        s.append(" txnId = ").append(this.getTid());
        s.append(" Xid = ").append(this.getXid());
        s.append(" complete = ").append(this.isComplete());
        return new String(s);
    }

    public JMQXid getXid() {
        return this.xid;
    }

    public void setXid(JMQXid xid) {
        this.xid = xid;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }
}

