/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq.websocket.stomp;

import com.sun.messaging.bridge.api.StompFrameMessageFactory;
import com.sun.messaging.bridge.api.StompProtocolException;
import com.sun.messaging.bridge.api.StompProtocolHandler;
import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.imq.websocket.stomp.STOMPWebSocket;
import com.sun.messaging.jmq.jmsserver.service.imq.websocket.stomp.StompConnectionImpl;
import com.sun.messaging.jmq.jmsserver.service.imq.websocket.stomp.StompFrameMessageImpl;
import com.sun.messaging.jmq.jmsservice.JMSService;
import com.sun.messaging.jmq.util.log.Logger;
import java.net.InetAddress;
import java.util.StringTokenizer;

public class StompProtocolHandlerImpl
extends StompProtocolHandler {
    private static final Logger logger = Globals.getLogger();
    private static final BrokerResources br = Globals.getBrokerResources();
    private static final Version mqversion = new Version();
    private STOMPWebSocket wsocket = null;
    private JMSService jmsservice = null;

    public StompProtocolHandlerImpl(STOMPWebSocket wsocket, JMSService jmss) {
        super(logger);
        this.wsocket = wsocket;
        this.jmsservice = jmss;
        this.stompConnection = new StompConnectionImpl(this);
    }

    @Override
    public boolean getDEBUG() {
        StompProtocolHandlerImpl stompProtocolHandlerImpl = this;
        return stompProtocolHandlerImpl.wsocket.getDEBUG();
    }

    public JMSService getJMSService() {
        return this.jmsservice;
    }

    public InetAddress getRemoteAddress() {
        return this.wsocket.getRemoteAddress();
    }

    public int getRemotePort() {
        return this.wsocket.getRemotePort();
    }

    @Override
    public String getSupportedVersions() {
        return "1.2";
    }

    @Override
    public String getServerName() {
        return mqversion.getProductName();
    }

    @Override
    public String negotiateVersion(String acceptVersions) throws StompProtocolException {
        if (acceptVersions == null) {
            throw new StompProtocolException(br.getKString("B4452", "1.0"));
        }
        StringTokenizer st = new StringTokenizer(acceptVersions, ",");
        String ver = null;
        while (st.hasMoreElements()) {
            ver = st.nextToken();
            if (Version.compareVersions(ver, "1.2") != 0) continue;
            return "1.2";
        }
        throw new StompProtocolException(br.getKString("B4452", acceptVersions));
    }

    @Override
    public StompFrameMessageFactory getStompFrameMessageFactory() {
        return StompFrameMessageImpl.getFactory();
    }

    @Override
    public String getTemporaryQueuePrefix() {
        return "temporary_destination://queue/";
    }

    @Override
    public String getTemporaryTopicPrefix() {
        return "temporary_destination://topic/";
    }

    @Override
    protected String getKStringI_CLOSE_STOMP_CONN(String stompconn) {
        return br.getKString("B1509", stompconn);
    }

    @Override
    protected String getKStringW_CLOSE_STOMP_CONN_FAILED(String stompconn, String emsg) {
        return br.getKString("B2294", stompconn, emsg);
    }

    @Override
    protected String getKStringE_COMMAND_FAILED(String cmd, String emsg, String stompconn) {
        Object[] args = new String[]{cmd, emsg, stompconn};
        return br.getKString("B3313", args);
    }

    @Override
    protected String getKStringE_UNABLE_SEND_ERROR_MSG(String emsg, String eemsg) {
        return br.getKString("B3314", emsg, eemsg);
    }

    @Override
    protected String getKStringX_SUBID_ALREADY_EXISTS(String subid) {
        return br.getKString("B4470", subid);
    }

    @Override
    protected String getKStringX_UNSUBSCRIBE_WITHOUT_HEADER(String destHeader, String subidHeader) {
        return br.getKString("B4471", destHeader, subidHeader);
    }

    @Override
    protected String getKStringX_HEADER_NOT_SPECIFIED_FOR(String header, String cmd) {
        return br.getKString("B4462", header, cmd);
    }

    @Override
    protected String getKStringX_SUBSCRIBER_ID_NOT_FOUND(String subid) {
        return br.getKString("B4472", subid);
    }

    @Override
    protected String getKStringW_NO_SUBID_TXNACK(String subidHeader, String tid, String subidPrefix, String msgid) {
        return br.getKString("B4462", subidHeader, "ACK[tid=" + tid + ", " + msgid + "]");
    }

    @Override
    protected String getKStringW_NO_SUBID_NONTXNACK(String subidHeader, String subidPrefix, String msgid) {
        return br.getKString("B4462", subidHeader, "ACK[" + msgid + "]");
    }

    @Override
    protected String getKStringX_INVALID_MESSAGE_PROP_NAME(String name) {
        return br.getKString("B4473", name);
    }

    @Override
    protected String getKStringX_INVALID_HEADER_VALUE(String header, String value) {
        return br.getKString("B4463", value, header);
    }

    @Override
    protected String getKStringI_USE_HEADER_IGNORE_OBSOLETE_HEADER_FOR(String useHeader, String ignoreHeaders, String cmd) {
        Object[] args = new String[]{useHeader, ignoreHeaders, cmd};
        return br.getKString("B1510", args);
    }
}

