/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.at;

import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPFactory;
import jakarta.xml.soap.SOAPFault;
import jakarta.xml.ws.WebServiceException;
import jakarta.xml.ws.soap.SOAPFaultException;
import java.util.Locale;
import javax.xml.namespace.QName;

public final class WSATFaultFactory {
    static final String INVALID_STATE = "InvalidState";
    static final String INVALID_PROTOCOL = "InvalidProtocol";
    static final String INVALID_PARAMETERS = "InvalidParameters";
    static final String NO_ACTIVITY = "NoActivity";
    static final String CONTEXT_REFUSED = "ContextRefused";
    static final String ALREADY_REGISTERED = "AlreadyRegistered";
    static final String INCONSISTENT_INTERNAL_STATE = "InconsistentInternalState";
    static final String HTTP_SCHEMAS_XMLSOAP_ORG_WS_2004_10_WSAT_FAULT = "http://schemas.xmlsoap.org/ws/2004/10/wsat/fault";
    private static final String CLIENT = "Client";
    static final QName FAULT_CODE_Q_NAME11 = new QName("http://www.w3.org/2003/05/soap-envelope", "Client");
    private static final String SENDER = "Sender";
    static final QName FAULT_CODE_Q_NAME = new QName("http://www.w3.org/2003/05/soap-envelope", "Sender");
    private static boolean m_isSOAP11 = true;

    private WSATFaultFactory() {
    }

    public static void throwInvalidStateFault() {
        WSATFaultFactory.throwSpecifiedWSATFault("The message was invalid for the current state of the activity.", INVALID_STATE);
    }

    public static void throwInvalidProtocolFault() {
        WSATFaultFactory.throwSpecifiedWSATFault("The protocol is invalid or is not supported by the coordinator.", INVALID_PROTOCOL);
    }

    public static void throwInvalidParametersFault() {
        WSATFaultFactory.throwSpecifiedWSATFault("The message contained invalid parameters and could not be processed.", INVALID_PARAMETERS);
    }

    public static void throwNoActivityFault() {
        WSATFaultFactory.throwSpecifiedWSATFault("The participant is not responding and is presumed to have ended.", NO_ACTIVITY);
    }

    public static void throwContextRefusedFault() {
        WSATFaultFactory.throwSpecifiedWSATFault("The coordination context that was provided could not be accepted.", CONTEXT_REFUSED);
    }

    public static void throwAlreadyRegisteredFault() {
        WSATFaultFactory.throwSpecifiedWSATFault("The participant has already registered for the same protocol.", ALREADY_REGISTERED);
    }

    public static void throwInconsistentInternalStateFault() {
        WSATFaultFactory.throwSpecifiedWSATFault("A global consistency failure has occurred. This is an unrecoverable condition.", INCONSISTENT_INTERNAL_STATE);
    }

    static void setSOAPVersion11(boolean isSOAPVersion11) {
        m_isSOAP11 = isSOAPVersion11;
    }

    private static void throwSpecifiedWSATFault(String reasonString, String subCode) {
        try {
            SOAPFault fault;
            if (m_isSOAP11) {
                fault = SOAPFactory.newInstance().createFault(reasonString, new QName(HTTP_SCHEMAS_XMLSOAP_ORG_WS_2004_10_WSAT_FAULT, subCode, "wsat"));
            } else {
                fault = SOAPFactory.newInstance((String)"SOAP 1.2 Protocol").createFault();
                fault.setFaultCode(FAULT_CODE_Q_NAME);
                fault.appendFaultSubcode(new QName(HTTP_SCHEMAS_XMLSOAP_ORG_WS_2004_10_WSAT_FAULT, subCode, "wsat"));
                fault.addFaultReasonText(reasonString, Locale.ENGLISH);
            }
            throw new SOAPFaultException(fault);
        }
        catch (SOAPException e) {
            throw new WebServiceException((Throwable)e);
        }
    }
}

