/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.trust.sts;

import com.sun.xml.ws.api.security.trust.BaseSTS;
import com.sun.xml.ws.api.security.trust.WSTrustContract;
import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.api.security.trust.config.STSConfiguration;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.impl.bindings.AppliesTo;
import com.sun.xml.ws.security.impl.IssuedTokenContextImpl;
import com.sun.xml.ws.security.trust.WSTrustElementFactory;
import com.sun.xml.ws.security.trust.WSTrustFactory;
import com.sun.xml.ws.security.trust.WSTrustVersion;
import com.sun.xml.ws.security.trust.elements.BaseSTSRequest;
import com.sun.xml.ws.security.trust.elements.BaseSTSResponse;
import com.sun.xml.ws.security.trust.elements.RequestSecurityToken;
import com.sun.xml.ws.security.trust.impl.DefaultSTSConfiguration;
import com.sun.xml.ws.security.trust.impl.DefaultTrustSPMetadata;
import com.sun.xml.ws.security.trust.util.WSTrustUtil;
import com.sun.xml.wss.SecurityEnvironment;
import com.sun.xml.wss.SubjectAccessor;
import com.sun.xml.wss.WSITXMLFactory;
import com.sun.xml.wss.XWSSecurityException;
import jakarta.xml.ws.WebServiceException;
import jakarta.xml.ws.handler.MessageContext;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class BaseSTSImpl
implements BaseSTS {
    public static final int DEFAULT_TIMEOUT = 36000;
    public static final String DEFAULT_ISSUER = "SampleSunSTS";
    public static final String STS_CONFIGURATION = "STSConfiguration";
    public static final String DEFAULT_IMPL = "com.sun.xml.ws.security.trust.impl.IssueSamlTokenContractImpl";
    public static final String DEFAULT_APPLIESTO = "default";
    public static final String APPLIES_TO = "AppliesTo";
    public static final String LIFETIME = "LifeTime";
    public static final String ALIAS = "CertAlias";
    public static final String ENCRYPT_KEY = "encryptIssuedKey";
    public static final String ENCRYPT_TOKEN = "encryptIssuedToken";
    public static final String CONTRACT = "Contract";
    public static final String ISSUER = "Issuer";
    public static final String TOKEN_TYPE = "TokenType";
    public static final String KEY_TYPE = "KeyType";
    public static final String SERVICE_PROVIDERS = "ServiceProviders";
    public static final String END_POINT = "endPoint";
    private static final QName Q_EK = new QName("", "encryptIssuedKey");
    private static final QName Q_ET = new QName("", "encryptIssuedToken");
    private static final QName Q_EP = new QName("", "endPoint");
    protected WSTrustVersion wstVer = WSTrustVersion.WS_TRUST_10;

    @Override
    public Source invoke(Source rstElement) {
        STSConfiguration config = this.getConfiguration();
        Source rstrEle = null;
        try {
            WSTrustElementFactory eleFac = WSTrustElementFactory.newInstance(this.wstVer);
            RequestSecurityToken rst = this.parseRST(rstElement, config);
            String appliesTo = null;
            AppliesTo applTo = rst.getAppliesTo();
            if (applTo != null) {
                appliesTo = WSTrustUtil.getAppliesToURI(applTo);
            }
            if (appliesTo == null) {
                appliesTo = DEFAULT_APPLIESTO;
            }
            if (rst.getRequestType().toString().equals(this.wstVer.getIssueRequestTypeURI())) {
                rstrEle = this.issue(config, appliesTo, eleFac, rst);
            } else if (rst.getRequestType().toString().equals(this.wstVer.getCancelRequestTypeURI())) {
                rstrEle = this.cancel(config, appliesTo, eleFac, rst);
            } else if (rst.getRequestType().toString().equals(this.wstVer.getRenewRequestTypeURI())) {
                rstrEle = this.renew(config, appliesTo, eleFac, rst);
            } else if (rst.getRequestType().toString().equals(this.wstVer.getValidateRequestTypeURI())) {
                rstrEle = this.validate(config, appliesTo, eleFac, rst);
            }
        }
        catch (Exception ex) {
            throw new WebServiceException((Throwable)ex);
        }
        return rstrEle;
    }

    protected abstract MessageContext getMessageContext();

    STSConfiguration getConfiguration() {
        STSConfiguration rtConfig;
        MessageContext msgCtx = this.getMessageContext();
        SecurityEnvironment secEnv = (SecurityEnvironment)msgCtx.get((Object)"SecurityEnvironment");
        WSTrustVersion wstVersion = (WSTrustVersion)msgCtx.get((Object)"WSTrustVersion");
        String authnCtxClass = (String)msgCtx.get((Object)"AuthnContextClass");
        if (wstVersion != null) {
            this.wstVer = wstVersion;
        }
        if ((rtConfig = WSTrustFactory.getRuntimeSTSConfiguration()) != null) {
            if (rtConfig.getCallbackHandler() == null) {
                rtConfig.getOtherOptions().put("SecurityEnvironment", secEnv);
            }
            if (wstVersion == null && (wstVersion = (WSTrustVersion)rtConfig.getOtherOptions().get("WSTrustVersion")) != null) {
                this.wstVer = wstVersion;
            }
            rtConfig.getOtherOptions().put("WSTrustVersion", this.wstVer);
            return rtConfig;
        }
        DefaultSTSConfiguration config = new DefaultSTSConfiguration();
        config.getOtherOptions().put("SecurityEnvironment", secEnv);
        Iterator iterator = (Iterator)msgCtx.get((Object)"http://schemas.sun.com/ws/2006/05/trust/server");
        if (iterator == null) {
            throw new WebServiceException("STS configuration information is not available");
        }
        while (iterator.hasNext()) {
            PolicyAssertion assertion = (PolicyAssertion)iterator.next();
            if (!STS_CONFIGURATION.equals(assertion.getName().getLocalPart())) continue;
            config.setEncryptIssuedToken(Boolean.parseBoolean(assertion.getAttributeValue(Q_ET)));
            config.setEncryptIssuedKey(Boolean.parseBoolean(assertion.getAttributeValue(Q_EK)));
            Iterator<PolicyAssertion> stsConfig = assertion.getParametersIterator();
            while (stsConfig.hasNext()) {
                PolicyAssertion serviceSTSPolicy = stsConfig.next();
                if (LIFETIME.equals(serviceSTSPolicy.getName().getLocalPart())) {
                    config.setIssuedTokenTimeout(Integer.parseInt(serviceSTSPolicy.getValue()));
                    continue;
                }
                if (CONTRACT.equals(serviceSTSPolicy.getName().getLocalPart())) {
                    config.setType(serviceSTSPolicy.getValue());
                    continue;
                }
                if (ISSUER.equals(serviceSTSPolicy.getName().getLocalPart())) {
                    config.setIssuer(serviceSTSPolicy.getValue());
                    continue;
                }
                if (!SERVICE_PROVIDERS.equals(serviceSTSPolicy.getName().getLocalPart())) continue;
                Iterator<PolicyAssertion> serviceProviders = serviceSTSPolicy.getParametersIterator();
                String endpointUri = null;
                while (serviceProviders.hasNext()) {
                    PolicyAssertion serviceProvider = serviceProviders.next();
                    endpointUri = serviceProvider.getAttributeValue(Q_EP);
                    if (endpointUri == null) {
                        endpointUri = serviceProvider.getAttributeValue(new QName("", END_POINT.toLowerCase()));
                    }
                    DefaultTrustSPMetadata data = new DefaultTrustSPMetadata(endpointUri);
                    Iterator<PolicyAssertion> spConfig = serviceProvider.getParametersIterator();
                    while (spConfig.hasNext()) {
                        PolicyAssertion policy = spConfig.next();
                        if (ALIAS.equals(policy.getName().getLocalPart())) {
                            data.setCertAlias(policy.getValue());
                            continue;
                        }
                        if (TOKEN_TYPE.equals(policy.getName().getLocalPart())) {
                            data.setTokenType(policy.getValue());
                            continue;
                        }
                        if (!KEY_TYPE.equals(policy.getName().getLocalPart())) continue;
                        data.setKeyType(policy.getValue());
                    }
                    config.addTrustSPMetadata(data, endpointUri);
                }
            }
        }
        config.getOtherOptions().put("WSTrustVersion", this.wstVer);
        if (authnCtxClass != null) {
            config.getOtherOptions().put("AuthnContextClass", authnCtxClass);
        }
        config.getOtherOptions().putAll((Map<String, Object>)msgCtx);
        return config;
    }

    private Source issue(STSConfiguration config, String appliesTo, WSTrustElementFactory eleFac, BaseSTSRequest rst) throws WSTrustException {
        WSTrustContract<BaseSTSRequest, BaseSTSResponse> contract = WSTrustFactory.newWSTrustContract(config, appliesTo);
        IssuedTokenContextImpl context = new IssuedTokenContextImpl();
        try {
            context.setRequestorSubject(SubjectAccessor.getRequesterSubject(this.getMessageContext()));
        }
        catch (XWSSecurityException ex) {
            throw new WSTrustException("error getting subject", ex);
        }
        BaseSTSResponse response = contract.issue(rst, context);
        return eleFac.toSource(response);
    }

    private Source cancel(STSConfiguration config, String appliesTo, WSTrustElementFactory eleFac, BaseSTSRequest rst) {
        return null;
    }

    private Source renew(STSConfiguration config, String appliesTo, WSTrustElementFactory eleFac, RequestSecurityToken rst) throws WSTrustException {
        WSTrustContract<BaseSTSRequest, BaseSTSResponse> contract = WSTrustFactory.newWSTrustContract(config, appliesTo);
        IssuedTokenContextImpl context = new IssuedTokenContextImpl();
        BaseSTSResponse rstr = contract.renew(rst, context);
        Source rstrEle = eleFac.toSource(rstr);
        return rstrEle;
    }

    private Source validate(STSConfiguration config, String appliesTo, WSTrustElementFactory eleFac, BaseSTSRequest rst) throws WSTrustException {
        WSTrustContract<BaseSTSRequest, BaseSTSResponse> contract = WSTrustFactory.newWSTrustContract(config, appliesTo);
        IssuedTokenContextImpl context = new IssuedTokenContextImpl();
        BaseSTSResponse rstr = contract.validate(rst, context);
        Source rstrEle = eleFac.toSource(rstr);
        return rstrEle;
    }

    private RequestSecurityToken parseRST(Source source, STSConfiguration config) throws WSTrustException {
        Element ele = null;
        try {
            DOMResult result = new DOMResult();
            TransformerFactory tfactory = WSITXMLFactory.createTransformerFactory(WSITXMLFactory.DISABLE_SECURE_PROCESSING);
            Transformer tf = tfactory.newTransformer();
            tf.transform(source, result);
            Node node = result.getNode();
            if (node instanceof Document) {
                ele = ((Document)node).getDocumentElement();
            } else if (node instanceof Element) {
                ele = (Element)node;
            }
        }
        catch (Exception xe) {
            throw new WSTrustException("Error occurred while trying to parse RST stream", xe);
        }
        WSTrustElementFactory fact = WSTrustElementFactory.newInstance(this.wstVer);
        RequestSecurityToken rst = fact.createRSTFrom(ele);
        NodeList list = ele.getElementsByTagNameNS("*", "Assertion");
        if (list.getLength() > 0) {
            Element assertion = (Element)list.item(0);
            config.getOtherOptions().put("SamlAssertionElementInRST", assertion);
        }
        return rst;
    }
}

