/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.admin.apps.console.AGraphics;
import com.sun.messaging.jmq.admin.apps.console.ConsoleUtils;
import com.sun.messaging.jmq.admin.apps.console.ObjStoreAdminCObj;
import com.sun.messaging.jmq.admin.apps.console.ObjStoreConFactoryListCObj;
import com.sun.messaging.jmq.admin.apps.console.ObjStoreDestListCObj;
import com.sun.messaging.jmq.admin.objstore.ObjStore;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;
import com.sun.messaging.jmq.admin.util.Globals;
import javax.swing.ImageIcon;
import javax.swing.tree.MutableTreeNode;

public class ObjStoreCObj
extends ObjStoreAdminCObj {
    private static final long serialVersionUID = -2162555967144727101L;
    private transient ObjStore os = null;
    private ObjStoreDestListCObj objStoreDestList = null;
    private ObjStoreConFactoryListCObj objStoreConFactoryList = null;
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();

    public ObjStoreCObj(ObjStore os) {
        this.os = os;
        this.objStoreDestList = new ObjStoreDestListCObj(os);
        this.objStoreConFactoryList = new ObjStoreConFactoryListCObj(os);
        this.insert(this.objStoreDestList, 0);
        this.insert(this.objStoreConFactoryList, 1);
    }

    public void setObjStore(ObjStore os) {
        this.os = os;
    }

    public ObjStore getObjStore() {
        return this.os;
    }

    @Override
    public String getExplorerLabel() {
        if (this.os.getDescription() != null) {
            return this.os.getDescription();
        }
        return this.os.getID();
    }

    @Override
    public String getExplorerToolTip() {
        return null;
    }

    @Override
    public ImageIcon getExplorerIcon() {
        if (this.os.isOpen()) {
            return AGraphics.adminImages[5];
        }
        return AGraphics.adminImages[18];
    }

    public ObjStoreDestListCObj getObjStoreDestListCObj() {
        return this.objStoreDestList;
    }

    public ObjStoreConFactoryListCObj getObjStoreConFactoryListCObj() {
        return this.objStoreConFactoryList;
    }

    @Override
    public String getActionLabel(int actionFlag, boolean forMenu) {
        if (forMenu) {
            switch (actionFlag) {
                case 1024: {
                    return acr.getString("A1025");
                }
                case 2048: {
                    return acr.getString("A1028");
                }
                case 2: {
                    return acr.getString("A1018");
                }
                case 32: {
                    return acr.getString("A1005");
                }
            }
        } else {
            switch (actionFlag) {
                case 1024: {
                    return acr.getString("A1140");
                }
                case 2048: {
                    return acr.getString("A1143");
                }
                case 2: {
                    return acr.getString("A1133");
                }
                case 32: {
                    return acr.getString("A1122");
                }
            }
        }
        return null;
    }

    @Override
    public ImageIcon getActionIcon(int actionFlag) {
        switch (actionFlag) {
            case 1024: {
                return AGraphics.adminImages[31];
            }
            case 2048: {
                return AGraphics.adminImages[33];
            }
        }
        return null;
    }

    @Override
    public void insert(MutableTreeNode node, int newIndex) {
        if (node instanceof ObjStoreDestListCObj || node instanceof ObjStoreConFactoryListCObj) {
            super.insert(node, newIndex);
        } else {
            super.insert(node, newIndex);
        }
    }

    @Override
    public int getExplorerPopupMenuItemMask() {
        return 3106;
    }

    @Override
    public int getActiveActions() {
        int mask = this.os.isOpen() ? 18466 : 1058;
        return mask;
    }

    @Override
    public String getInspectorPanelClassName() {
        return ConsoleUtils.getPackageName(this) + ".ObjStoreInspector";
    }

    @Override
    public String getInspectorPanelId() {
        return "Object Store";
    }

    @Override
    public String getInspectorPanelHeader() {
        return this.getInspectorPanelId();
    }
}

