/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.keyinfo;

import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.SecurityContextToken;
import com.sun.xml.ws.security.SecurityContextTokenInfo;
import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;
import com.sun.xml.ws.security.opt.api.keyinfo.BuilderResult;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.keyinfo.SecurityContextToken13;
import com.sun.xml.ws.security.opt.impl.keyinfo.TokenBuilder;
import com.sun.xml.ws.security.opt.impl.reference.DirectReference;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import com.sun.xml.wss.impl.policy.mls.KeyBindingBase;
import com.sun.xml.wss.impl.policy.mls.SecureConversationTokenKeyBinding;
import com.sun.xml.wss.logging.impl.opt.token.LogStringsMessages;
import java.util.logging.Level;
import javax.crypto.spec.SecretKeySpec;

public class SCTBuilder
extends TokenBuilder {
    private SecureConversationTokenKeyBinding sctBinding = null;

    public SCTBuilder(JAXBFilterProcessingContext context, SecureConversationTokenKeyBinding kb) {
        super(context);
        this.sctBinding = kb;
    }

    @Override
    public BuilderResult process() throws XWSSecurityException {
        String sctWsuId;
        BuilderResult sctResult = new BuilderResult();
        String dataEncAlgo = SecurityUtil.getDataEncryptionAlgo(this.context);
        String sctPolicyId = this.sctBinding.getUUID();
        SecurityHeaderElement sct = this.context.getSecurityHeader().getChildElement(sctPolicyId);
        IssuedTokenContext ictx = this.context.getSecureConversationContext();
        String sctVersion = this.sctBinding.getIncludeToken();
        boolean includeToken = KeyBindingBase.INCLUDE_ALWAYS.equals(sctVersion) || KeyBindingBase.INCLUDE_ALWAYS_TO_RECIPIENT.equals(sctVersion) || KeyBindingBase.INCLUDE_ALWAYS_VER2.equals(sctVersion) || KeyBindingBase.INCLUDE_ALWAYS_TO_RECIPIENT_VER2.equals(sctVersion);
        SecurityContextToken sct1 = null;
        if (sct == null) {
            sct1 = (SecurityContextToken)ictx.getSecurityToken();
            if (sct1 == null) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1809_SCT_NOT_FOUND());
                throw new XWSSecurityException("SecureConversation Token not Found");
            }
            sct = this.context.getSecurityHeader().getChildElement(sct1.getWsuId());
            if (sct == null) {
                sct1 = SecurityUtil.getSCT(sct1, this.context.getSOAPVersion());
                if (includeToken) {
                    if (this.context.getSecurityPolicyVersion().equals("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702")) {
                        this.context.getSecurityHeader().add((SecurityContextToken13)sct1);
                    } else {
                        this.context.getSecurityHeader().add((com.sun.xml.ws.security.opt.impl.keyinfo.SecurityContextToken)sct1);
                    }
                }
                sct = this.context.getSecurityPolicyVersion().equals("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702") ? (SecurityContextToken13)sct1 : (com.sun.xml.ws.security.opt.impl.keyinfo.SecurityContextToken)sct1;
            }
        }
        if ((sctWsuId = sct.getId()) == null) {
            sct.setId(this.context.generateID());
            sctWsuId = sct.getId();
        }
        SecretKeySpec dataProtectionKey = null;
        DirectReference directRef = this.elementFactory.createDirectReference();
        if (includeToken) {
            directRef.setURI("#" + sctWsuId);
        } else {
            directRef.setURI(sct1.getIdentifier().toString());
        }
        if (!KeyBindingBase.INCLUDE_ALWAYS_TO_RECIPIENT.equals(this.sctBinding.getIncludeToken()) || !KeyBindingBase.INCLUDE_ALWAYS.equals(this.sctBinding.getIncludeToken())) {
            if (this.context.getSecurityPolicyVersion().equals("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702")) {
                directRef.setValueType("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/sct");
            } else {
                directRef.setValueType("http://schemas.xmlsoap.org/ws/2005/02/sc/sct");
            }
        }
        if (sct1.getInstance() != null && !this.context.isExpired()) {
            directRef.setAttribute(this.context.getWSSCVersion(this.context.getSecurityPolicyVersion()), "Instance", sct1.getInstance());
        }
        byte[] proofKey = null;
        if (sct1.getInstance() != null) {
            if (this.context.isExpired()) {
                proofKey = ictx.getProofKey();
            } else if (ictx.getSecurityContextTokenInfo() != null) {
                SecurityContextTokenInfo sctInstanceInfo = ictx.getSecurityContextTokenInfo();
                proofKey = sctInstanceInfo.getInstanceSecret(sct1.getInstance());
            } else {
                proofKey = ictx.getProofKey();
            }
        } else {
            proofKey = ictx.getProofKey();
        }
        String jceAlgo = SecurityUtil.getSecretKeyAlgorithm(dataEncAlgo);
        dataProtectionKey = new SecretKeySpec(proofKey, jceAlgo);
        this.buildKeyInfo(directRef, this.context.generateID());
        sctResult.setKeyInfo(this.keyInfo);
        sctResult.setDataProtectionKey(dataProtectionKey);
        return sctResult;
    }
}

