/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.wasp.taglibs.standard.tlv;

import jakarta.servlet.jsp.tagext.PageData;
import jakarta.servlet.jsp.tagext.ValidationMessage;
import java.util.Set;
import java.util.Stack;
import org.glassfish.wasp.taglibs.standard.resources.Resources;
import org.glassfish.wasp.taglibs.standard.tlv.JstlBaseTLV;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class JstlXmlTLV
extends JstlBaseTLV {
    private final String CHOOSE = "choose";
    private final String WHEN = "when";
    private final String OTHERWISE = "otherwise";
    private final String PARSE = "parse";
    private final String PARAM = "param";
    private final String TRANSFORM = "transform";
    private final String JSP_TEXT = "jsp:text";
    private final String VALUE = "value";
    private final String SOURCE = "xml";

    public ValidationMessage[] validate(String prefix, String uri, PageData page) {
        return super.validate(4, prefix, uri, page);
    }

    @Override
    protected DefaultHandler getHandler() {
        return new Handler();
    }

    private class Handler
    extends DefaultHandler {
        private int depth = 0;
        private Stack<Integer> chooseDepths = new Stack();
        private Stack<Boolean> chooseHasOtherwise = new Stack();
        private Stack<Boolean> chooseHasWhen = new Stack();
        private String lastElementName = null;
        private boolean bodyNecessary = false;
        private boolean bodyIllegal = false;
        private Stack<Integer> transformWithSource = new Stack();

        private Handler() {
        }

        @Override
        public void startElement(String nameSpace, String localName, String qualifiedNamed, Attributes attributes) {
            Set expAtts;
            if (localName == null) {
                localName = JstlXmlTLV.this.getLocalPart(qualifiedNamed);
            }
            if (qualifiedNamed.equals("jsp:text")) {
                return;
            }
            if (this.bodyIllegal) {
                JstlXmlTLV.this.fail(Resources.getMessage("TLV_ILLEGAL_BODY", this.lastElementName));
            }
            if (qualifiedNamed.startsWith(JstlXmlTLV.this.prefix + ":") && (expAtts = (Set)JstlXmlTLV.this.config.get(localName)) != null) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String vMsg;
                    String attName = attributes.getLocalName(i);
                    if (!expAtts.contains(attName) || (vMsg = JstlXmlTLV.this.validateExpression(localName, attName, attributes.getValue(i))) == null) continue;
                    JstlXmlTLV.this.fail(vMsg);
                }
            }
            if (qualifiedNamed.startsWith(JstlXmlTLV.this.prefix + ":") && !JstlXmlTLV.this.hasNoInvalidScope(attributes)) {
                JstlXmlTLV.this.fail(Resources.getMessage("TLV_INVALID_ATTRIBUTE", "scope", qualifiedNamed, attributes.getValue("scope")));
            }
            if (qualifiedNamed.startsWith(JstlXmlTLV.this.prefix + ":") && JstlXmlTLV.this.hasEmptyVar(attributes)) {
                JstlXmlTLV.this.fail(Resources.getMessage("TLV_EMPTY_VAR", qualifiedNamed));
            }
            if (qualifiedNamed.startsWith(JstlXmlTLV.this.prefix + ":") && JstlXmlTLV.this.hasDanglingScope(attributes)) {
                JstlXmlTLV.this.fail(Resources.getMessage("TLV_DANGLING_SCOPE", qualifiedNamed));
            }
            if (this.chooseChild()) {
                if (JstlXmlTLV.this.isXmlTag(nameSpace, localName, "when")) {
                    this.chooseHasWhen.pop();
                    this.chooseHasWhen.push(Boolean.TRUE);
                }
                if (!JstlXmlTLV.this.isXmlTag(nameSpace, localName, "when") && !JstlXmlTLV.this.isXmlTag(nameSpace, localName, "otherwise")) {
                    JstlXmlTLV.this.fail(Resources.getMessage("TLV_ILLEGAL_CHILD_TAG", JstlXmlTLV.this.prefix, "choose", qualifiedNamed));
                }
                if (this.chooseHasOtherwise.peek().booleanValue()) {
                    JstlXmlTLV.this.fail(Resources.getMessage("TLV_ILLEGAL_ORDER", qualifiedNamed, JstlXmlTLV.this.prefix, "otherwise", "choose"));
                }
                if (JstlXmlTLV.this.isXmlTag(nameSpace, localName, "otherwise")) {
                    this.chooseHasOtherwise.pop();
                    this.chooseHasOtherwise.push(Boolean.TRUE);
                }
            }
            if (!this.transformWithSource.empty() && this.topDepth(this.transformWithSource) == this.depth - 1 && !JstlXmlTLV.this.isXmlTag(nameSpace, localName, "param")) {
                JstlXmlTLV.this.fail(Resources.getMessage("TLV_ILLEGAL_BODY", JstlXmlTLV.this.prefix + ":transform"));
            }
            if (JstlXmlTLV.this.isXmlTag(nameSpace, localName, "choose")) {
                this.chooseDepths.push(this.depth);
                this.chooseHasWhen.push(Boolean.FALSE);
                this.chooseHasOtherwise.push(Boolean.FALSE);
            }
            this.bodyIllegal = false;
            this.bodyNecessary = false;
            if (JstlXmlTLV.this.isXmlTag(nameSpace, localName, "parse")) {
                if (JstlXmlTLV.this.hasAttribute(attributes, "xml")) {
                    this.bodyIllegal = true;
                }
            } else if (JstlXmlTLV.this.isXmlTag(nameSpace, localName, "param")) {
                if (JstlXmlTLV.this.hasAttribute(attributes, "value")) {
                    this.bodyIllegal = true;
                } else {
                    this.bodyNecessary = true;
                }
            } else if (JstlXmlTLV.this.isXmlTag(nameSpace, localName, "transform") && JstlXmlTLV.this.hasAttribute(attributes, "xml")) {
                this.transformWithSource.push(this.depth);
            }
            this.lastElementName = qualifiedNamed;
            JstlXmlTLV.this.lastElementId = attributes.getValue("http://java.sun.com/JSP/Page", "id");
            ++this.depth;
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.bodyNecessary = false;
            String s = new String(ch, start, length).trim();
            if (s.equals("")) {
                return;
            }
            if (this.bodyIllegal) {
                JstlXmlTLV.this.fail(Resources.getMessage("TLV_ILLEGAL_BODY", this.lastElementName));
            }
            if (this.chooseChild()) {
                String msg = Resources.getMessage("TLV_ILLEGAL_TEXT_BODY", JstlXmlTLV.this.prefix, "choose", s.length() < 7 ? s : s.substring(0, 7));
                JstlXmlTLV.this.fail(msg);
            }
            if (!this.transformWithSource.empty() && this.topDepth(this.transformWithSource) == this.depth - 1) {
                JstlXmlTLV.this.fail(Resources.getMessage("TLV_ILLEGAL_BODY", JstlXmlTLV.this.prefix + ":transform"));
            }
        }

        @Override
        public void endElement(String ns, String ln, String qn) {
            if (qn.equals("jsp:text")) {
                return;
            }
            if (this.bodyNecessary) {
                JstlXmlTLV.this.fail(Resources.getMessage("TLV_MISSING_BODY", this.lastElementName));
            }
            this.bodyIllegal = false;
            if (JstlXmlTLV.this.isXmlTag(ns, ln, "choose")) {
                Boolean b = this.chooseHasWhen.pop();
                if (!b.booleanValue()) {
                    JstlXmlTLV.this.fail(Resources.getMessage("TLV_PARENT_WITHOUT_SUBTAG", "choose", "when"));
                }
                this.chooseDepths.pop();
                this.chooseHasOtherwise.pop();
            }
            if (!this.transformWithSource.empty() && this.topDepth(this.transformWithSource) == this.depth - 1) {
                this.transformWithSource.pop();
            }
            --this.depth;
        }

        private boolean chooseChild() {
            return !this.chooseDepths.empty() && this.depth - 1 == this.chooseDepths.peek();
        }

        private int topDepth(Stack<Integer> s) {
            return s.peek();
        }
    }
}

