/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.protocol;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.security.secext10.SecurityTokenReferenceType;
import jakarta.xml.ws.EndpointReference;

public class CreateSequenceData {
    @NotNull
    private final EndpointReference acksToEpr;
    private final long duration;
    @Nullable
    private final String offeredSequenceId;
    private final long offeredSequenceExpiry;
    @Nullable
    private final SecurityTokenReferenceType strType;
    @NotNull
    private final Sequence.IncompleteSequenceBehavior offeredSequenceIncompleteBehavior;

    public static Builder getBuilder(EndpointReference acksToEpr) {
        return new Builder(acksToEpr);
    }

    private CreateSequenceData(@NotNull EndpointReference acksToEpr, @Nullable long exipry, @Nullable SecurityTokenReferenceType strType, @Nullable String offeredSequenceId, @Nullable long offeredSequenceExpiry, @NotNull Sequence.IncompleteSequenceBehavior offeredSequenceIncompleteBehavior) {
        this.acksToEpr = acksToEpr;
        this.duration = exipry;
        this.offeredSequenceId = offeredSequenceId;
        this.offeredSequenceExpiry = offeredSequenceExpiry;
        this.strType = strType;
        this.offeredSequenceIncompleteBehavior = offeredSequenceIncompleteBehavior;
    }

    @NotNull
    public EndpointReference getAcksToEpr() {
        return this.acksToEpr;
    }

    public long getDuration() {
        return this.duration;
    }

    public boolean doesNotExpire() {
        return this.duration == -1L;
    }

    @Nullable
    public SecurityTokenReferenceType getStrType() {
        return this.strType;
    }

    @Nullable
    public String getOfferedSequenceId() {
        return this.offeredSequenceId;
    }

    public long getOfferedSequenceExpiry() {
        return this.offeredSequenceExpiry;
    }

    public boolean offeredSequenceDoesNotExpire() {
        return this.offeredSequenceExpiry == -1L;
    }

    public Sequence.IncompleteSequenceBehavior getOfferedSequenceIncompleteBehavior() {
        return this.offeredSequenceIncompleteBehavior;
    }

    public static class Builder {
        @NotNull
        private final EndpointReference acksToEpr;
        private long duration;
        @Nullable
        private SecurityTokenReferenceType strType;
        @Nullable
        private String offeredSequenceId;
        private long offeredSequenceExpiry;
        private Sequence.IncompleteSequenceBehavior offeredSequenceIncompleteBehavior;

        private Builder(EndpointReference acksToEpr) {
            this.acksToEpr = acksToEpr;
            this.duration = -1L;
            this.offeredSequenceExpiry = -1L;
            this.offeredSequenceIncompleteBehavior = Sequence.IncompleteSequenceBehavior.getDefault();
        }

        public void duration(long expiry) {
            this.duration = expiry;
        }

        public Builder strType(SecurityTokenReferenceType value) {
            this.strType = value;
            return this;
        }

        public void offeredSequenceExpiry(long offeredSequenceExpiry) {
            this.offeredSequenceExpiry = offeredSequenceExpiry;
        }

        public Builder offeredInboundSequenceId(String value) {
            this.offeredSequenceId = value;
            return this;
        }

        public void offeredSequenceIncompleteBehavior(Sequence.IncompleteSequenceBehavior value) {
            this.offeredSequenceIncompleteBehavior = value;
        }

        public CreateSequenceData build() {
            return new CreateSequenceData(this.acksToEpr, this.duration, this.strType, this.offeredSequenceId, this.offeredSequenceExpiry, this.offeredSequenceIncompleteBehavior);
        }
    }
}

