/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.basic.algorithm;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.glassfish.pfl.basic.algorithm.ClassAnalyzer;
import org.glassfish.pfl.basic.contain.Pair;
import org.glassfish.pfl.basic.func.UnaryPredicate;

public class AnnotationAnalyzer {
    private final Map<AnnotatedElement, Map<Class<?>, Annotation>> annotationCache = new WeakHashMap();
    private final Map<AnnotatedElement, Map<Class<?>, Annotation>> addedAnnotations = new HashMap();

    private synchronized <K, V> void putIfNotPresent(Map<K, V> map, K key, V value) {
        if (!map.containsKey(key)) {
            map.put(key, value);
        }
    }

    public synchronized void addAnnotation(AnnotatedElement element, Annotation annotation) {
        Class<? extends Annotation> annotationType;
        Annotation ann;
        if (annotation == null) {
            throw new RuntimeException("Cannot add null annotation to annotated element " + element);
        }
        Map<Class<?>, Annotation> map = this.addedAnnotations.get(element);
        if (map == null) {
            map = new HashMap();
            this.addedAnnotations.put(element, map);
        }
        if ((ann = map.get(annotationType = annotation.annotationType())) != null) {
            throw new RuntimeException("Duplicate annotatio " + annotation.getClass().getName() + " for element " + element);
        }
        map.put(annotationType, annotation);
    }

    public synchronized void addInheritedAnnotations(Class<?> cls, Class<?> ancestor) {
        if (!ancestor.isAssignableFrom(cls)) {
            throw new RuntimeException("Ancestor " + ancestor + " is not assignment compatible with " + cls);
        }
        Map<Class<?>, Annotation> classAnnos = this.getAnnotations(cls, false);
        this.addedAnnotations.put(ancestor, classAnnos);
        ClassAnalyzer clsCA = ClassAnalyzer.getClassAnalyzer(cls);
        ClassAnalyzer ancestorCA = ClassAnalyzer.getClassAnalyzer(ancestor);
        final HashSet ancestorClasses = new HashSet();
        ancestorCA.findClasses(new UnaryPredicate<Class<?>>(){

            @Override
            public boolean evaluate(Class<?> arg) {
                ancestorClasses.add(arg);
                return true;
            }
        });
        final HashMap map = new HashMap();
        clsCA.findMethods(new UnaryPredicate<Method>(){

            @Override
            public boolean evaluate(Method arg) {
                if (!ancestorClasses.contains(arg.getDeclaringClass())) {
                    Pair key = new Pair(arg.getName(), Arrays.asList(arg.getParameterTypes()));
                    Map annos = map.computeIfAbsent(key, k -> new HashMap());
                    for (Annotation anno : arg.getDeclaredAnnotations()) {
                        AnnotationAnalyzer.this.putIfNotPresent(annos, anno.annotationType(), anno);
                    }
                }
                return true;
            }
        });
        ancestorCA.findMethods(new UnaryPredicate<Method>(){

            @Override
            public boolean evaluate(Method arg) {
                Pair key = new Pair(arg.getName(), Arrays.asList(arg.getParameterTypes()));
                Map annos = (Map)map.get(key);
                if (annos != null && !annos.isEmpty()) {
                    AnnotationAnalyzer.this.addedAnnotations.put(arg, annos);
                    map.remove(key);
                }
                return true;
            }
        });
    }

    public Map<Class<?>, Annotation> getAnnotations(Class<?> cls) {
        return this.getAnnotations(cls, true);
    }

    private Map<Class<?>, Annotation> getAnnotations(Class<?> cls, final boolean includeAddedAnnotations) {
        Map<Class<?>, Annotation> result = this.annotationCache.get(cls);
        if (result == null) {
            final HashMap res = new HashMap();
            ClassAnalyzer ca = ClassAnalyzer.getClassAnalyzer(cls);
            ca.findClasses(new UnaryPredicate<Class<?>>(){

                @Override
                public boolean evaluate(Class<?> arg) {
                    Map<Class<?>, Annotation> emap;
                    Annotation[] annots;
                    for (Annotation anno : annots = arg.getDeclaredAnnotations()) {
                        AnnotationAnalyzer.this.putIfNotPresent(res, anno.annotationType(), anno);
                    }
                    if (includeAddedAnnotations && (emap = AnnotationAnalyzer.this.addedAnnotations.get(arg)) != null) {
                        for (Map.Entry<Class<?>, Annotation> entry : emap.entrySet()) {
                            AnnotationAnalyzer.this.putIfNotPresent(res, entry.getKey(), entry.getValue());
                        }
                    }
                    return true;
                }
            });
            this.annotationCache.put(cls, res);
            return res;
        }
        return result;
    }

    public Map<Class<?>, Annotation> getAnnotations(Method method) {
        return this.getAnnotations(method, true);
    }

    private Map<Class<?>, Annotation> getAnnotations(Method method, final boolean includeAddedAnnotations) {
        Map<Class<?>, Annotation> result = this.annotationCache.get(method);
        if (result == null) {
            Class<?> cls = method.getDeclaringClass();
            final HashMap res = new HashMap();
            final String methodName = method.getName();
            final Class[] methodParamTypes = method.getParameterTypes();
            ClassAnalyzer ca = ClassAnalyzer.getClassAnalyzer(cls);
            ca.findClasses(new UnaryPredicate<Class<?>>(){

                @Override
                public boolean evaluate(Class<?> arg) {
                    Map<Class<?>, Annotation> emap;
                    Method overriddenMethod = null;
                    try {
                        overriddenMethod = arg.getDeclaredMethod(methodName, methodParamTypes);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (overriddenMethod == null) {
                        return true;
                    }
                    if (includeAddedAnnotations && (emap = AnnotationAnalyzer.this.addedAnnotations.get(overriddenMethod)) != null) {
                        for (Map.Entry entry : emap.entrySet()) {
                            AnnotationAnalyzer.this.putIfNotPresent(res, (Class)entry.getKey(), (Annotation)entry.getValue());
                        }
                    }
                    Annotation[] annots = overriddenMethod.getDeclaredAnnotations();
                    for (Annotation anno : annots) {
                        AnnotationAnalyzer.this.putIfNotPresent(res, anno.annotationType(), anno);
                    }
                    return true;
                }
            });
            this.annotationCache.put(method, res);
            return res;
        }
        return result;
    }

    private Map<Class<?>, Annotation> makeAnnoMap(Annotation[] annos) {
        HashMap result = new HashMap();
        for (Annotation anno : annos) {
            result.put(anno.annotationType(), anno);
        }
        return result;
    }

    public List<Map<Class<?>, Annotation>> getParameterAnnotations(Method method) {
        Annotation[][] pannos;
        ArrayList result = new ArrayList();
        for (Annotation[] annos : pannos = method.getParameterAnnotations()) {
            Map<Class<?>, Annotation> element = this.makeAnnoMap(annos);
            result.add(element);
        }
        return result;
    }

    public Map<Class<?>, Annotation> getAnnotations(Constructor<?> cons) {
        return this.makeAnnoMap(cons.getDeclaredAnnotations());
    }

    public List<Map<Class<?>, Annotation>> getParameterAnnotations(Constructor<?> cons) {
        Annotation[][] pannos;
        ArrayList result = new ArrayList();
        for (Annotation[] annos : pannos = cons.getParameterAnnotations()) {
            Map<Class<?>, Annotation> element = this.makeAnnoMap(annos);
            result.add(element);
        }
        return result;
    }

    public Map<Class<?>, Annotation> getAnnotations(Field fld) {
        return this.makeAnnoMap(fld.getDeclaredAnnotations());
    }

    public Map<Class<?>, Annotation> getAnnotations(Package pkg) {
        return this.makeAnnoMap(pkg.getDeclaredAnnotations());
    }

    public Map<Class<?>, Annotation> getAnnotations(AnnotatedElement elem) {
        if (elem instanceof Class) {
            return this.getAnnotations((Class)elem);
        }
        if (elem instanceof Method) {
            return this.getAnnotations((Method)elem);
        }
        if (elem instanceof Constructor) {
            return this.getAnnotations((Constructor)elem);
        }
        if (elem instanceof Field) {
            return this.getAnnotations((Field)elem);
        }
        if (elem instanceof Package) {
            return this.getAnnotations((Package)elem);
        }
        return null;
    }

    public <A extends Annotation> A getAnnotation(AnnotatedElement elem, Class<A> cls) {
        Annotation anno = this.getAnnotations(elem).get(cls);
        return (A)((Annotation)cls.cast(anno));
    }
}

