/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.util;

import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.config.util.PortConstants;
import com.sun.enterprise.config.util.Strings;
import com.sun.enterprise.util.net.NetUtils;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jvnet.hk2.config.TransactionFailure;

final class PortUtils {
    private PortUtils() {
    }

    static void checkInternalConsistency(Server server) throws TransactionFailure {
        List<SystemProperty> sysProps = server.getSystemProperty();
        TreeSet<Integer> ports = new TreeSet<Integer>();
        for (SystemProperty sp : sysProps) {
            String name = sp.getName();
            if (!PortConstants.PORTSLIST.contains(name)) continue;
            String val = sp.getValue();
            try {
                boolean wasAdded = ports.add(Integer.parseInt(val));
                if (wasAdded) continue;
                throw new TransactionFailure(Strings.get("PortUtils.duplicate_port", val, server.getName()));
            }
            catch (TransactionFailure tf) {
                throw tf;
            }
            catch (Exception e) {
                throw new TransactionFailure(Strings.get("PortUtils.non_int_port", val, server.getName()));
            }
        }
        PortUtils.checkForLegalPorts(ports, server.getName());
    }

    private static void checkForLegalPorts(Set<Integer> ports, String serverName) throws TransactionFailure {
        for (int port : ports) {
            if (NetUtils.isPortValid((int)port)) continue;
            throw new TransactionFailure(Strings.get("PortUtils.illegal_port_number", port, serverName, 65535));
        }
    }
}

