/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.ssl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLEngineFactory;

public class SSLEngineConfigurator
implements SSLEngineFactory {
    private static final Logger LOGGER = Grizzly.logger(SSLEngineConfigurator.class);
    private final Object sync = new Object();
    protected volatile SSLContextConfigurator sslContextConfiguration;
    protected volatile SSLContext sslContext;
    protected boolean clientMode;
    private SSLParameters sslParameters;

    public SSLEngineConfigurator(SSLContext sslContext) {
        this(sslContext, true, false, false);
    }

    public SSLEngineConfigurator(SSLContext sslContext, boolean clientMode, boolean needClientAuth, boolean wantClientAuth) {
        if (sslContext == null) {
            throw new IllegalArgumentException("SSLContext can not be null");
        }
        this.sslContextConfiguration = null;
        this.sslContext = sslContext;
        this.clientMode = clientMode;
        this.sslParameters = sslContext.getDefaultSSLParameters();
        if (needClientAuth) {
            this.sslParameters.setNeedClientAuth(true);
        }
        if (wantClientAuth) {
            this.sslParameters.setWantClientAuth(true);
        }
    }

    public SSLEngineConfigurator(SSLContextConfigurator sslContextConfiguration) {
        this(sslContextConfiguration, true, false, false);
    }

    public SSLEngineConfigurator(SSLContextConfigurator sslContextConfiguration, boolean clientMode, boolean needClientAuth, boolean wantClientAuth) {
        if (sslContextConfiguration == null) {
            throw new IllegalArgumentException("SSLContextConfigurator can not be null");
        }
        this.sslContextConfiguration = sslContextConfiguration;
        this.clientMode = clientMode;
        this.sslParameters = new SSLParameters();
        if (needClientAuth) {
            this.sslParameters.setNeedClientAuth(true);
        }
        if (wantClientAuth) {
            this.sslParameters.setWantClientAuth(true);
        }
    }

    public SSLEngineConfigurator(SSLEngineConfigurator pattern) {
        this.sslContextConfiguration = pattern.sslContextConfiguration;
        this.sslContext = pattern.sslContext;
        this.clientMode = pattern.clientMode;
        this.sslParameters = this.copy(pattern.sslParameters);
    }

    protected SSLEngineConfigurator() {
        this.sslParameters = new SSLParameters();
    }

    public SSLEngine createSSLEngine() {
        return this.createSSLEngine(null, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SSLEngine createSSLEngine(String peerHost, int peerPort) {
        if (this.sslContext == null) {
            Object object = this.sync;
            synchronized (object) {
                if (this.sslContext == null) {
                    this.sslContext = this.sslContextConfiguration.createSSLContext(true);
                }
            }
        }
        SSLEngine sslEngine = this.sslContext.createSSLEngine(peerHost, peerPort);
        this.configure(sslEngine);
        return sslEngine;
    }

    public SSLEngine configure(SSLEngine sslEngine) {
        String[] enabledProtocols;
        SSLParameters params = this.copy(this.sslParameters);
        String[] enabledCipherSuites = params.getCipherSuites();
        if (enabledCipherSuites != null) {
            enabledCipherSuites = SSLEngineConfigurator.configureEnabledCiphers(sslEngine, enabledCipherSuites);
            params.setCipherSuites(enabledCipherSuites);
        }
        if ((enabledProtocols = params.getProtocols()) != null) {
            enabledProtocols = SSLEngineConfigurator.configureEnabledProtocols(sslEngine, enabledProtocols);
            params.setProtocols(enabledProtocols);
        }
        sslEngine.setUseClientMode(this.clientMode);
        sslEngine.setSSLParameters(this.sslParameters);
        return sslEngine;
    }

    public boolean isClientMode() {
        return this.clientMode;
    }

    public SSLEngineConfigurator setClientMode(boolean clientMode) {
        this.clientMode = clientMode;
        return this;
    }

    public boolean isNeedClientAuth() {
        return this.sslParameters.getNeedClientAuth();
    }

    public SSLEngineConfigurator setNeedClientAuth(boolean needClientAuth) {
        this.sslParameters.setNeedClientAuth(needClientAuth);
        return this;
    }

    public boolean isWantClientAuth() {
        return this.sslParameters.getWantClientAuth();
    }

    public SSLEngineConfigurator setWantClientAuth(boolean wantClientAuth) {
        this.sslParameters.setWantClientAuth(wantClientAuth);
        return this;
    }

    public SSLEngineConfigurator setSSLParameters(SSLParameters sslParameters) {
        this.sslParameters = this.copy(sslParameters);
        return this;
    }

    public String[] getEnabledCipherSuites() {
        return this.sslParameters.getCipherSuites();
    }

    public SSLEngineConfigurator setEnabledCipherSuites(String[] enabledCipherSuites) {
        this.sslParameters.setCipherSuites(enabledCipherSuites);
        return this;
    }

    public String[] getEnabledProtocols() {
        return this.sslParameters.getProtocols();
    }

    public SSLEngineConfigurator setEnabledProtocols(String[] enabledProtocols) {
        this.sslParameters.setProtocols(enabledProtocols);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLContext getSslContext() {
        if (this.sslContext == null) {
            Object object = this.sync;
            synchronized (object) {
                if (this.sslContext == null) {
                    this.sslContext = this.sslContextConfiguration.createSSLContext(true);
                }
            }
        }
        return this.sslContext;
    }

    private static String[] configureEnabledProtocols(SSLEngine sslEngine, String[] requestedProtocols) {
        String[] supportedProtocols = sslEngine.getSupportedProtocols();
        String[] protocols = null;
        ArrayList<String> list = null;
        block0: for (String supportedProtocol : supportedProtocols) {
            for (String protocol : requestedProtocols) {
                if (!supportedProtocol.equals(protocol = protocol.trim())) continue;
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(protocol);
                continue block0;
            }
        }
        if (list != null) {
            protocols = list.toArray(new String[list.size()]);
        }
        return protocols;
    }

    private static String[] configureEnabledCiphers(SSLEngine sslEngine, String[] requestedCiphers) {
        String[] supportedCiphers = sslEngine.getSupportedCipherSuites();
        String[] ciphers = null;
        ArrayList<String> list = null;
        block0: for (String supportedCipher : supportedCiphers) {
            for (String cipher : requestedCiphers) {
                if (!supportedCipher.equals(cipher = cipher.trim())) continue;
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(cipher);
                continue block0;
            }
        }
        if (list != null) {
            ciphers = list.toArray(new String[list.size()]);
        }
        return ciphers;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SSLEngineConfigurator");
        sb.append("{clientMode=").append(this.clientMode);
        sb.append(", enabledCipherSuites=").append(this.sslParameters.getCipherSuites() == null ? "null" : Arrays.toString(this.sslParameters.getCipherSuites()));
        sb.append(", enabledProtocols=").append(this.sslParameters.getProtocols() == null ? "null" : Arrays.toString(this.sslParameters.getProtocols()));
        sb.append(", needClientAuth=").append(this.sslParameters.getNeedClientAuth());
        sb.append(", wantClientAuth=").append(this.sslParameters.getWantClientAuth());
        sb.append('}');
        return sb.toString();
    }

    public SSLEngineConfigurator copy() {
        return new SSLEngineConfigurator(this);
    }

    private SSLParameters copy(SSLParameters src) {
        SSLParameters dest = new SSLParameters();
        dest.setCipherSuites(src.getCipherSuites());
        dest.setProtocols(src.getProtocols());
        if (src.getNeedClientAuth()) {
            dest.setNeedClientAuth(src.getNeedClientAuth());
        }
        if (src.getWantClientAuth()) {
            dest.setWantClientAuth(src.getWantClientAuth());
        }
        dest.setAlgorithmConstraints(src.getAlgorithmConstraints());
        dest.setApplicationProtocols(src.getApplicationProtocols());
        dest.setEnableRetransmissions(src.getEnableRetransmissions());
        dest.setEndpointIdentificationAlgorithm(src.getEndpointIdentificationAlgorithm());
        dest.setMaximumPacketSize(src.getMaximumPacketSize());
        dest.setSNIMatchers(src.getSNIMatchers());
        dest.setServerNames(src.getServerNames());
        dest.setUseCipherSuitesOrder(src.getUseCipherSuitesOrder());
        return dest;
    }
}

