/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.descriptor;

import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.TypeUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.ejb.deployment.descriptor.CMRFieldInfo;
import org.glassfish.ejb.deployment.descriptor.EjbBundleDescriptorImpl;
import org.glassfish.ejb.deployment.descriptor.EjbCMPEntityDescriptor;
import org.glassfish.ejb.deployment.descriptor.FieldDescriptor;
import org.glassfish.ejb.deployment.descriptor.PersistentFieldInfo;
import org.glassfish.ejb.deployment.descriptor.QueryDescriptor;
import org.glassfish.ejb.deployment.descriptor.RelationRoleDescriptor;
import org.glassfish.ejb.deployment.descriptor.RelationshipDescriptor;

public final class PersistenceDescriptor
extends Descriptor {
    private static final long serialVersionUID = 1L;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(PersistenceDescriptor.class);
    private Set<FieldDescriptor> cmpFields = new HashSet<FieldDescriptor>();
    private Set<FieldDescriptor> pkeyFields = new HashSet<FieldDescriptor>();
    private boolean pkeyIsOneField;
    private boolean pkeyFieldSpecified = true;
    private String primaryKeyClassName;
    private boolean pkeyStuffInitialized;
    private boolean pkeyFieldsAllPrimitive;
    private EjbCMPEntityDescriptor parentDesc;
    private transient Class<?> persistentClass;
    private transient Class<?> stateClass;
    private transient Class<?> primaryKeyClass;
    private PersistentFieldInfo[] persFieldInfo;
    private PersistentFieldInfo[] persNoPkeyFieldInfo;
    private PersistentFieldInfo[] pkeyFieldInfo;
    private boolean fieldInfoInitialized;
    private PersistentFieldInfo[] fkeyFields;
    private CMRFieldInfo[] cmrFieldInfo;
    private transient Field[] pkeyClassPkeyFields;
    private final Hashtable<MethodDescriptor, QueryDescriptor> queries = new Hashtable();

    public PersistenceDescriptor() {
    }

    public PersistenceDescriptor(PersistenceDescriptor pers) {
        super((Descriptor)pers);
        this.getCMPFields().addAll(pers.getCMPFields());
    }

    public String getCMRFieldReturnType(String field) {
        if (field.isBlank()) {
            return Collection.class.getName();
        }
        try {
            Class<?> persClass = this.getPersistentClass();
            String methodName = "get" + field.substring(0, 1).toUpperCase(Locale.US) + field.substring(1);
            Method method = TypeUtil.getMethod(persClass, (ClassLoader)persClass.getClassLoader(), (String)methodName, (String[])new String[0]);
            return method.getReturnType().getName();
        }
        catch (Throwable t) {
            if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
                DOLUtils.getDefaultLogger().log(Level.FINE, t.toString(), t);
            }
            return Collection.class.getName();
        }
    }

    public void setParentDescriptor(EjbCMPEntityDescriptor parentDesc) {
        this.parentDesc = parentDesc;
    }

    public Descriptor getParentDescriptor() {
        return this.parentDesc;
    }

    public EjbBundleDescriptorImpl getEjbBundleDescriptor() {
        return this.parentDesc.getEjbBundleDescriptor();
    }

    private Set<RelationshipDescriptor> getRelationships() {
        Set<RelationshipDescriptor> allRelationships = this.getEjbBundleDescriptor().getRelationships();
        HashSet<RelationshipDescriptor> myRelationships = new HashSet<RelationshipDescriptor>();
        for (RelationshipDescriptor next : allRelationships) {
            if (!next.hasParticipant((Descriptor)this.parentDesc)) continue;
            myRelationships.add(next);
        }
        return myRelationships;
    }

    public CMRFieldInfo[] getCMRFieldInfo() {
        if (this.cmrFieldInfo == null) {
            try {
                this.initCMRFieldStuff();
            }
            catch (Exception ex) {
                DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.invalidDescriptorMappingFailure", new Object[]{ex.toString()});
                throw new DeploymentException((Throwable)ex);
            }
        }
        return this.cmrFieldInfo;
    }

    public CMRFieldInfo getCMRFieldInfoByName(String fieldName) {
        CMRFieldInfo[] cmrf;
        for (CMRFieldInfo element : cmrf = this.getCMRFieldInfo()) {
            if (!element.name.equals(fieldName)) continue;
            return element;
        }
        throw new DeploymentException("CMRFieldInfo not found for field " + fieldName);
    }

    public void invalidate() {
        this.cmrFieldInfo = null;
        this.persFieldInfo = null;
        this.fieldInfoInitialized = false;
        this.pkeyStuffInitialized = false;
    }

    private void initCMRFieldStuff() throws Exception {
        if (!this.fieldInfoInitialized) {
            this.initializeFieldInfo();
        }
        Set<RelationshipDescriptor> relationships = this.getRelationships();
        CMRFieldInfo[] cmrFieldInfo2 = new CMRFieldInfo[relationships.size() * 2];
        int count = 0;
        for (RelationshipDescriptor rd : relationships) {
            RelationRoleDescriptor source = rd.getSource();
            RelationRoleDescriptor sink = rd.getSink();
            RelationRoleDescriptor[] myroles = source.getPersistenceDescriptor() == sink.getPersistenceDescriptor() ? new RelationRoleDescriptor[]{source, sink} : new RelationRoleDescriptor[]{source.getPersistenceDescriptor() == this ? source : sink};
            for (RelationRoleDescriptor myrole : myroles) {
                String type;
                CMRFieldInfo finfo = new CMRFieldInfo();
                cmrFieldInfo2[count++] = finfo;
                PersistenceDescriptor partnerPers = myrole.getPartner().getPersistenceDescriptor();
                EjbCMPEntityDescriptor partner = myrole.getPartner().getOwner();
                if (!partner.isLocalInterfacesSupported() && myrole.getCMRField() != null) {
                    throw new RuntimeException("No local interface for target bean of CMR field");
                }
                if (!myrole.getPartner().getIsMany()) {
                    type = partner.isLocalInterfacesSupported() ? partner.getLocalClassName() : partner.getPrimaryKeyClassName();
                } else {
                    type = myrole.getCMRFieldType();
                    if (type == null) {
                        type = "java.util.Collection";
                    }
                }
                finfo.type = this.getClass(type);
                finfo.name = myrole.getCMRField();
                if (finfo.name == null) {
                    finfo.name = myrole.composeReverseCmrFieldName();
                }
                finfo.role = myrole;
                myrole.setCMRFieldInfo(finfo);
                if (!rd.isOneOne() || this.fkeyFields == null) continue;
                PersistentFieldInfo[] partnerPkeyFields = partnerPers.getPkeyFieldInfo();
                PersistentFieldInfo[] cmrFkeyFields = new PersistentFieldInfo[partnerPkeyFields.length];
                for (int i = 0; i < partnerPkeyFields.length; ++i) {
                    String fkeyName = "_" + finfo.name + "_" + partnerPkeyFields[i].name;
                    for (PersistentFieldInfo fkeyField : this.fkeyFields) {
                        if (!fkeyField.name.equals(fkeyName)) continue;
                        cmrFkeyFields[i] = fkeyField;
                    }
                }
                finfo.fkeyFields = cmrFkeyFields;
            }
        }
        this.cmrFieldInfo = new CMRFieldInfo[count];
        System.arraycopy(cmrFieldInfo2, 0, this.cmrFieldInfo, 0, count);
        for (int i = this.cmrFieldInfo.length - 1; i > 0; --i) {
            for (int j = 0; j < i; ++j) {
                if (this.cmrFieldInfo[j].name.compareTo(this.cmrFieldInfo[j + 1].name) <= 0) continue;
                CMRFieldInfo tmp = this.cmrFieldInfo[j];
                this.cmrFieldInfo[j] = this.cmrFieldInfo[j + 1];
                this.cmrFieldInfo[j + 1] = tmp;
            }
        }
    }

    public void clearCMPFields() {
        this.cmpFields.clear();
        this.setCMPFields(this.cmpFields);
    }

    public void addCMPField(String field) {
        this.addCMPField(new FieldDescriptor(field));
    }

    public void addCMPField(FieldDescriptor fieldDesc) {
        this.cmpFields.add(fieldDesc);
        this.setCMPFields(this.cmpFields);
    }

    public void removeCMPField(String field) {
        this.removeCMPField(new FieldDescriptor(field));
    }

    public void removeCMPField(FieldDescriptor fieldDesc) {
        this.cmpFields.remove((Object)fieldDesc);
        this.setCMPFields(this.cmpFields);
    }

    public void setCMPFields(Set<FieldDescriptor> cmpFields) {
        this.cmpFields = cmpFields;
        this.persFieldInfo = null;
        this.fieldInfoInitialized = false;
    }

    public boolean isCMPField(String field) {
        return this.getCMPFields().contains((Object)new FieldDescriptor(field));
    }

    public Set<FieldDescriptor> getCMPFields() {
        return this.cmpFields;
    }

    public void setPkeyFields(Set<FieldDescriptor> pkeyFields) {
        this.pkeyFields = pkeyFields;
        this.fieldInfoInitialized = false;
        this.persFieldInfo = null;
        this.pkeyStuffInitialized = false;
    }

    public Set<FieldDescriptor> getPkeyFields() {
        if (!this.pkeyStuffInitialized) {
            this.initPkeyInfo();
        }
        return this.pkeyFields;
    }

    public boolean isPkeyField(String field) {
        return this.isPkeyField(new FieldDescriptor(field));
    }

    public boolean isPkeyField(FieldDescriptor fieldDesc) {
        return this.getPkeyFields().contains((Object)fieldDesc);
    }

    private void initPkeyInfo() {
        try {
            this.pkeyIsOneField = false;
            this.pkeyFieldSpecified = true;
            this.primaryKeyClassName = this.parentDesc.getPrimaryKeyClassName();
            FieldDescriptor fd = this.parentDesc.getPrimaryKeyFieldDesc();
            if (this.pkeyFields == null || this.pkeyFields.isEmpty()) {
                this.pkeyFields = new HashSet<FieldDescriptor>();
                if (fd != null) {
                    this.pkeyFields.add(fd);
                } else if (!this.primaryKeyClassName.equals("java.lang.Object")) {
                    this.primaryKeyClass = this.getClass(this.primaryKeyClassName);
                    Field[] fields = this.primaryKeyClass.getFields();
                    this.pkeyFieldsAllPrimitive = true;
                    for (Field field : fields) {
                        int m = field.getModifiers();
                        if (Modifier.isStatic(m) || Modifier.isFinal(m)) continue;
                        if (!field.getType().isPrimitive()) {
                            this.pkeyFieldsAllPrimitive = false;
                        }
                        this.pkeyFields.add(new FieldDescriptor(field.getName()));
                    }
                } else {
                    this.primaryKeyClass = this.getClass(this.primaryKeyClassName);
                    this.pkeyIsOneField = true;
                    this.pkeyFieldSpecified = false;
                }
            }
            if (fd != null) {
                this.pkeyIsOneField = true;
            }
            this.pkeyStuffInitialized = true;
        }
        catch (Exception ex) {
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.invalidDescriptorMappingFailure", new Object[]{ex.toString()});
            throw new DeploymentException((Throwable)ex);
        }
    }

    public boolean primaryKeyIsOneField() {
        if (!this.pkeyStuffInitialized) {
            this.initPkeyInfo();
        }
        return this.pkeyIsOneField;
    }

    public boolean primaryKeyIsSpecified() {
        if (!this.pkeyStuffInitialized) {
            this.initPkeyInfo();
        }
        return this.pkeyFieldSpecified;
    }

    public boolean primaryKeyFieldsAllPrimitive() {
        if (!this.pkeyStuffInitialized) {
            this.initPkeyInfo();
        }
        return this.pkeyFieldsAllPrimitive;
    }

    public Class<?> getPrimaryKeyClass() {
        if (!this.pkeyStuffInitialized) {
            this.initPkeyInfo();
        }
        return this.primaryKeyClass;
    }

    public Class<?> getPersistentClass() {
        if (this.persistentClass == null) {
            this.persistentClass = this.getClass(this.parentDesc.getEjbClassName());
        }
        return this.persistentClass;
    }

    public Class<?> getStateClass() {
        if (this.stateClass == null) {
            this.stateClass = this.getPersistentClass();
            if (this.parentDesc.isEJB20()) {
                if (!Modifier.isAbstract(this.stateClass.getModifiers())) {
                    throw new DeploymentException("2.x CMP bean class " + this.stateClass.getName() + " must be decleared abstract or cmp-version for the corresponding bean must be set to 1.x.");
                }
                String stateClassName = this.parentDesc.getStateImplClassName();
                this.stateClass = this.getClass(stateClassName);
            }
        }
        return this.stateClass;
    }

    private Class<?> getClass(String className) {
        try {
            return this.getEjbBundleDescriptor().getClassLoader().loadClass(className);
        }
        catch (Exception ex) {
            throw new DeploymentException((Throwable)ex);
        }
    }

    public void setFkeyFields(PersistentFieldInfo[] fkeyFields) {
        this.fkeyFields = fkeyFields;
        this.fieldInfoInitialized = false;
        this.persFieldInfo = null;
    }

    public PersistentFieldInfo[] getFkeyFields() {
        if (!this.fieldInfoInitialized) {
            this.initializeFieldInfo();
        }
        return this.fkeyFields;
    }

    public PersistentFieldInfo[] getPersistentFieldInfo() {
        if (!this.fieldInfoInitialized) {
            this.initializeFieldInfo();
        }
        return this.persFieldInfo;
    }

    public PersistentFieldInfo getPersistentFieldInfoByName(String fieldName) {
        if (!this.fieldInfoInitialized) {
            this.initializeFieldInfo();
        }
        for (PersistentFieldInfo element : this.persFieldInfo) {
            if (!element.name.equals(fieldName)) continue;
            return element;
        }
        throw new DeploymentException("PersistentFieldInfo not found for field " + fieldName);
    }

    public PersistentFieldInfo[] getNonPkeyPersFieldInfo() {
        if (!this.fieldInfoInitialized) {
            this.initializeFieldInfo();
        }
        return this.persNoPkeyFieldInfo;
    }

    public PersistentFieldInfo[] getPkeyFieldInfo() {
        if (!this.fieldInfoInitialized) {
            this.initializeFieldInfo();
        }
        return this.pkeyFieldInfo;
    }

    public PersistentFieldInfo getPkeyFieldInfoByName(String fieldName) {
        if (!this.fieldInfoInitialized) {
            this.initializeFieldInfo();
        }
        for (PersistentFieldInfo element : this.pkeyFieldInfo) {
            if (!element.name.equals(fieldName)) continue;
            return element;
        }
        throw new DeploymentException("PersistentFieldInfo not found for pkey field " + fieldName);
    }

    public Field[] getPkeyClassFields() {
        if (!this.fieldInfoInitialized) {
            this.initializeFieldInfo();
        }
        return this.pkeyClassPkeyFields;
    }

    private void initializeFieldInfo() {
        int i;
        int cmpFieldCount;
        if (!this.pkeyStuffInitialized) {
            this.initPkeyInfo();
        }
        if ((cmpFieldCount = this.cmpFields.size()) == 0) {
            throw new DeploymentException("No cmp field defined for CMP EJB " + this.parentDesc.getName());
        }
        int fkeyCount = 0;
        if (this.fkeyFields != null) {
            fkeyCount = this.fkeyFields.length;
        }
        this.persFieldInfo = new PersistentFieldInfo[cmpFieldCount + fkeyCount];
        int fcount = 0;
        for (FieldDescriptor cmpField : this.cmpFields) {
            this.persFieldInfo[fcount] = new PersistentFieldInfo();
            this.persFieldInfo[fcount].name = cmpField.getName();
            ++fcount;
        }
        if (this.fkeyFields != null) {
            PersistentFieldInfo[] persistentFieldInfoArray = this.fkeyFields;
            int cmpField = persistentFieldInfoArray.length;
            for (int j = 0; j < cmpField; ++j) {
                PersistentFieldInfo fkeyField;
                this.persFieldInfo[fcount] = fkeyField = persistentFieldInfoArray[j];
                ++fcount;
            }
        }
        for (int i2 = this.persFieldInfo.length - 1; i2 > 0; --i2) {
            for (int j = 0; j < i2; ++j) {
                if (this.persFieldInfo[j].name.compareTo(this.persFieldInfo[j + 1].name) <= 0) continue;
                PersistentFieldInfo tmp = this.persFieldInfo[j];
                this.persFieldInfo[j] = this.persFieldInfo[j + 1];
                this.persFieldInfo[j + 1] = tmp;
            }
        }
        this.pkeyFieldInfo = new PersistentFieldInfo[this.pkeyFields.size()];
        if (this.pkeyFieldSpecified) {
            StringBuilder nonPersFieldsInPK = new StringBuilder();
            for (FieldDescriptor fd : this.pkeyFields) {
                boolean isPersistent = false;
                PersistentFieldInfo[] persistentFieldInfoArray = this.persFieldInfo;
                int n = persistentFieldInfoArray.length;
                for (int j = 0; j < n; ++j) {
                    PersistentFieldInfo element = persistentFieldInfoArray[j];
                    if (!fd.getName().equals(element.name)) continue;
                    isPersistent = true;
                    break;
                }
                if (isPersistent) continue;
                if (nonPersFieldsInPK.length() != 0) {
                    nonPersFieldsInPK.append(", ");
                }
                nonPersFieldsInPK.append(fd.getName());
            }
            if (nonPersFieldsInPK.length() != 0) {
                throw new DeploymentException(localStrings.getLocalString("enterprise.deployment.pkhasnopersistentfields", "CMP bean [{0}], primary key class [{1}] has public non-persistent field(s) [{2}].", new Object[]{this.getParentDescriptor().getName(), this.primaryKeyClassName, nonPersFieldsInPK.toString()}));
            }
            this.persNoPkeyFieldInfo = new PersistentFieldInfo[this.persFieldInfo.length - this.pkeyFieldInfo.length];
            int pkeyCount = 0;
            int noPkeyCount = 0;
            for (PersistentFieldInfo element : this.persFieldInfo) {
                boolean isPkey = false;
                for (FieldDescriptor fd : this.pkeyFields) {
                    if (!fd.getName().equals(element.name)) continue;
                    isPkey = true;
                    break;
                }
                if (isPkey) {
                    this.pkeyFieldInfo[pkeyCount++] = element;
                    continue;
                }
                this.persNoPkeyFieldInfo[noPkeyCount++] = element;
            }
        }
        if (this.pkeyIsOneField && this.pkeyFieldSpecified) {
            this.pkeyFieldInfo[0].type = this.getPrimaryKeyClass();
        }
        for (i = 0; i < this.persFieldInfo.length; ++i) {
            if (this.persFieldInfo[i].type != null) continue;
            this.persFieldInfo[i].type = this.getCMPFieldType(this.persFieldInfo[i].name);
        }
        try {
            if (this.persistentClass != null && !Modifier.isAbstract(this.persistentClass.getModifiers())) {
                for (i = 0; i < this.persFieldInfo.length; ++i) {
                    this.persFieldInfo[i].field = this.getField(this.getStateClass(), this.persFieldInfo[i].name);
                }
            }
            if (!this.pkeyIsOneField && this.primaryKeyClass != null && !Modifier.isAbstract(this.primaryKeyClass.getModifiers())) {
                this.pkeyClassPkeyFields = new Field[this.pkeyFieldInfo.length];
                for (i = 0; i < this.pkeyFieldInfo.length; ++i) {
                    this.pkeyClassPkeyFields[i] = this.primaryKeyClass.getField(this.pkeyFieldInfo[i].name);
                }
            }
        }
        catch (NoSuchFieldException ex) {
            if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
                DOLUtils.getDefaultLogger().log(Level.FINE, ex.toString(), ex);
            }
            throw new DeploymentException((Throwable)ex);
        }
        this.fieldInfoInitialized = true;
    }

    private Field getField(Class<?> c, String name) throws NoSuchFieldException {
        Field field;
        try {
            field = c.getDeclaredField(name);
        }
        catch (NoSuchFieldException ex) {
            return null;
        }
        if (field == null) {
            field = c.getField(name);
        }
        return field;
    }

    public Class<?> getTypeFor(String field) {
        return this.getCMPFieldType(field);
    }

    private Class<?> getCMPFieldType(String field) {
        Class<?> pclass = this.getPersistentClass();
        if (Modifier.isAbstract(pclass.getModifiers())) {
            String javaBeanName = PersistenceDescriptor.capitalize(field);
            String getter = "get" + javaBeanName;
            try {
                Method method = pclass.getMethod(getter, null);
                return method.getReturnType();
            }
            catch (Exception ex) {
                throw new RuntimeException("Cannot find accessor " + getter + " for CMP field " + field);
            }
        }
        try {
            Field f = this.getField(this.getStateClass(), field);
            return f.getType();
        }
        catch (NoSuchFieldException ex) {
            throw new RuntimeException("Cant find CMP field " + field + " in class " + this.getStateClass().getName());
        }
    }

    public static String capitalize(String name) {
        if (Character.isUpperCase(name.charAt(0))) {
            throw new DeploymentException("CMP/CMR field " + name + " must start with a lower case character.");
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public void setQueryFor(MethodDescriptor method, QueryDescriptor query) {
        this.queries.put(method, query);
    }

    public QueryDescriptor getQueryFor(MethodDescriptor method) {
        return this.queries.get(method);
    }

    public void removeQueryFor(MethodDescriptor method) {
        this.queries.remove(method);
    }

    public void setQueryFor(Method method, QueryDescriptor query) {
        MethodDescriptor md = new MethodDescriptor(method, "");
        this.setQueryFor(md, query);
    }

    public QueryDescriptor getQueryFor(Method method) {
        MethodDescriptor md = new MethodDescriptor(method, "");
        return this.queries.get(md);
    }

    public Set<MethodDescriptor> getQueriedMethods() {
        return this.queries.keySet();
    }

    public void print(StringBuffer toStringBuffer) {
        super.print(toStringBuffer);
        toStringBuffer.append("\n Entity descriptor");
        toStringBuffer.append("\n cmpFields ").append(this.cmpFields);
    }
}

