/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.impl;

import com.sun.jdo.api.persistence.enhancer.impl.ClassControl;
import com.sun.jdo.api.persistence.enhancer.meta.JDOMetaData;
import com.sun.jdo.api.persistence.enhancer.util.ClassFileSource;
import com.sun.jdo.api.persistence.enhancer.util.ClassPath;
import com.sun.jdo.api.persistence.enhancer.util.Support;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;

public final class Environment
extends Support {
    private PrintWriter out = new PrintWriter(System.out, true);
    private PrintWriter err = new PrintWriter(System.err, true);
    private boolean timingOption = false;
    private boolean verboseOption = false;
    private boolean quietOption = false;
    private boolean noWriteOption = false;
    private boolean disableThisHookHoisting;
    private boolean disableInitializerAnnotationSuppression;
    private boolean forceOverwriteOption = false;
    private boolean updateInPlaceOption = false;
    private int errorsEncountered = 0;
    private File destinationDirectory = null;
    private Hashtable classMap = new Hashtable(11);
    private HashMap missingClasses = new HashMap(11);
    private ClassPath classPathOption = new ClassPath("");
    private ClassPath destClassPath;
    private Hashtable fieldSuppressions = new Hashtable();
    private Hashtable classSuppressions = new Hashtable();
    private JDOMetaData jdoMetaData;
    private String lastErrorMessage = null;

    public void setDoTimingStatistics(boolean dontOpt) {
        this.timingOption = dontOpt;
    }

    public boolean doTimingStatistics() {
        return this.timingOption;
    }

    public void error(String error) {
        ++this.errorsEncountered;
        this.lastErrorMessage = Environment.getI18N("enhancer.enumerated_error", this.errorsEncountered, error);
        this.err.println(this.lastErrorMessage);
    }

    public void warning(String warn) {
        if (!this.quietOption) {
            this.out.println(Environment.getI18N("enhancer.warning", warn));
        }
    }

    public void warning(String warn, String classname) {
        if (!this.quietOption && !this.classWarningsSuppressed(classname)) {
            this.out.println(Environment.getI18N("enhancer.warning", warn));
        }
    }

    public void warning(String warn, String classname, String fieldname) {
        if (!(this.quietOption || this.classWarningsSuppressed(classname) || this.fieldWarningsSuppressed(classname, fieldname))) {
            this.out.print(Environment.getI18N("enhancer.warning", warn));
        }
    }

    public void message(String mess) {
        if (this.verboseOption) {
            this.out.println("JDO ENHANCER: " + mess);
        }
    }

    public void messageNL(String mess) {
        if (this.verboseOption) {
            this.out.println();
            this.out.println("JDO ENHANCER: " + mess);
        }
    }

    public int errorCount() {
        return this.errorsEncountered;
    }

    public final String getLastErrorMessage() {
        return this.lastErrorMessage;
    }

    public boolean forceOverwrite() {
        return this.forceOverwriteOption;
    }

    public boolean updateInPlace() {
        return this.updateInPlaceOption;
    }

    public File destinationDirectory() {
        return this.destinationDirectory;
    }

    public boolean writeClasses() {
        return !this.noWriteOption && this.errorsEncountered == 0;
    }

    public boolean doThisOptimization() {
        return !this.disableThisHookHoisting;
    }

    public boolean doInitializerOptimization() {
        return !this.disableInitializerAnnotationSuppression;
    }

    public JDOMetaData getJDOMetaData() {
        return this.jdoMetaData;
    }

    public void setJDOMetaData(JDOMetaData jdoMetaData) {
        this.jdoMetaData = jdoMetaData;
    }

    public void addClass(ClassControl cc) {
        String className = cc.className();
        ClassControl existCC = this.getClass(className);
        if (existCC != null) {
            if (!existCC.source().sameAs(cc.source())) {
                this.error(Environment.getI18N("enhancer.class_already_entered", cc.userClassName(), cc.sourceName(), existCC.sourceName()));
                return;
            }
            if (cc.persistType() == 0 || existCC.persistType() == 2 || existCC.persistType() == 1 && cc.persistType() != 2) {
                return;
            }
        }
        if (existCC == null && cc.sourceName() != null) {
            this.message("adding class " + cc.userClassName() + " from " + cc.sourceName());
        }
        this.classMap.put(className, cc);
    }

    public boolean canFindClass(String className) {
        return this.findClass(className) != null;
    }

    public ClassControl getClass(String className) {
        return (ClassControl)this.classMap.get(className);
    }

    public Iterator getClasses() {
        return this.classMap.values().iterator();
    }

    public ClassControl findClass(String className) {
        ClassControl cc = (ClassControl)this.classMap.get(className);
        if (cc == null && this.missingClasses.get(className) == null) {
            cc = this.lookupClass(className);
            if (cc != null) {
                this.message("Reading class " + cc.userClassName() + " from " + cc.sourceName());
                this.classMap.put(className, cc);
            } else {
                this.missingClasses.put(className, className);
            }
        }
        return cc;
    }

    public ClassControl lookupClass(String className) {
        ClassFileSource source = this.classPathOption.findClass(className);
        while (source != null) {
            try {
                ClassControl cc = new ClassControl(source, this);
                if (cc.className() != null && cc.className().equals(className)) {
                    return cc;
                }
            }
            catch (ClassFormatError classFormatError) {
                // empty catch block
            }
            source = source.nextSource(className);
        }
        return null;
    }

    public ArrayList collectClasses(int persistType) {
        ArrayList<ClassControl> v = new ArrayList<ClassControl>();
        for (ClassControl cc : this.classMap.values()) {
            if (cc.persistType() != persistType) continue;
            v.add(cc);
        }
        return v;
    }

    public ArrayList collectClasses() {
        ArrayList v = new ArrayList();
        Iterator e = this.classMap.values().iterator();
        while (e.hasNext()) {
            v.add(e.next());
        }
        return v;
    }

    public ClassFileSource lookupDestClass(String className) {
        if (this.destClassPath == null && this.destinationDirectory != null) {
            this.destClassPath = new ClassPath(this.destinationDirectory.getPath());
        }
        return this.destClassPath == null ? null : this.destClassPath.findClass(className);
    }

    public void setDestinationDirectory(String dir) {
        File dest = new File(dir);
        if (this.destinationDirectory != null) {
            this.error(Environment.getI18N("destination_directory_already_set", dir, this.destinationDirectory.getPath()));
            return;
        }
        if (!dest.isDirectory()) {
            this.error(Environment.getI18N("enhancer.destination_directory_not_exist", dir));
            return;
        }
        this.destinationDirectory = dest;
    }

    public void excludeDestinationDirectory() {
        if (this.destinationDirectory != null) {
            this.classPathOption.remove(this.destinationDirectory);
        }
    }

    public void moveDestinationDirectoryToEnd() {
        if (this.destinationDirectory != null && this.classPathOption.remove(this.destinationDirectory)) {
            this.classPathOption.append(this.destinationDirectory);
        }
    }

    public void setOutputWriter(PrintWriter out) {
        this.out = out;
    }

    public PrintWriter getOutputWriter() {
        return this.out;
    }

    public void setErrorWriter(PrintWriter err) {
        this.err = err;
    }

    public PrintWriter getErrorWriter() {
        return this.err;
    }

    public void setVerbose(boolean beVerbose) {
        this.verboseOption = beVerbose;
    }

    public boolean isVerbose() {
        return this.verboseOption;
    }

    public void setQuiet(boolean beQuiet) {
        this.quietOption = beQuiet;
    }

    public void setNoWrite(boolean dontWrite) {
        this.noWriteOption = dontWrite;
    }

    public void setNoThisOptimization(boolean dontOpt) {
        this.disableThisHookHoisting = dontOpt;
    }

    public void setNoInitializerOptimization(boolean dontOpt) {
        this.disableInitializerAnnotationSuppression = dontOpt;
    }

    public void setNoOptimization(boolean dontOpt) {
        this.disableThisHookHoisting = dontOpt;
        this.disableInitializerAnnotationSuppression = dontOpt;
    }

    public void setForceOverwrite(boolean forceOverwrite) {
        this.forceOverwriteOption = forceOverwrite;
    }

    public void suppressClassWarnings(String className) {
        this.classSuppressions.put(className, className);
    }

    public void suppressFieldWarnings(String fullFieldName) {
        this.fieldSuppressions.put(fullFieldName, fullFieldName);
    }

    static String validVMPackage(String pkg) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < pkg.length()) {
            if (i != 0) {
                if (pkg.charAt(i) != '.') {
                    return null;
                }
                buf.append("/");
                if (++i == pkg.length()) {
                    return null;
                }
            }
            if (!Character.isJavaIdentifierStart(pkg.charAt(i))) {
                return null;
            }
            buf.append(pkg.charAt(i++));
            while (i < pkg.length() && Character.isJavaIdentifierPart(pkg.charAt(i))) {
                buf.append(pkg.charAt(i++));
            }
        }
        return buf.toString();
    }

    private boolean classWarningsSuppressed(String classname) {
        return this.classSuppressions.get(classname) != null;
    }

    private boolean fieldWarningsSuppressed(String classname, String fieldName) {
        return this.fieldSuppressions.get(classname + "." + fieldName) != null;
    }

    public void reset() {
        this.errorsEncountered = 0;
        this.classMap.clear();
        this.missingClasses.clear();
        this.fieldSuppressions.clear();
        this.classSuppressions.clear();
    }
}

