/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.metadata.cache;

import jakarta.enterprise.context.NormalScope;
import jakarta.inject.Scope;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.Set;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotation;
import org.jboss.weld.logging.ReflectionLogger;
import org.jboss.weld.metadata.cache.AnnotationModel;
import org.jboss.weld.util.collections.Arrays2;

public class ScopeModel<T extends Annotation>
extends AnnotationModel<T> {
    private static final Set<Class<? extends Annotation>> META_ANNOTATIONS = Arrays2.asSet(Scope.class, NormalScope.class);
    private final boolean normal;
    private final boolean passivating;

    public ScopeModel(EnhancedAnnotation<T> enhancedAnnotatedAnnotation) {
        super(enhancedAnnotatedAnnotation);
        if (this.isValid()) {
            if (enhancedAnnotatedAnnotation.isAnnotationPresent(NormalScope.class)) {
                this.passivating = enhancedAnnotatedAnnotation.getAnnotation(NormalScope.class).passivating();
                this.normal = true;
            } else {
                this.normal = false;
                this.passivating = false;
            }
        } else {
            this.normal = false;
            this.passivating = false;
        }
    }

    @Override
    protected void check(EnhancedAnnotation<T> annotatedAnnotation) {
        super.check(annotatedAnnotation);
        if (this.isValid()) {
            if (!annotatedAnnotation.isAnnotationPresent(Target.class)) {
                ReflectionLogger.LOG.missingTarget(annotatedAnnotation);
            } else if (!Arrays2.unorderedEquals((Object[])annotatedAnnotation.getAnnotation(Target.class).value(), new Object[]{ElementType.METHOD, ElementType.FIELD, ElementType.TYPE})) {
                ReflectionLogger.LOG.missingTargetMethodFieldType(annotatedAnnotation);
            }
        }
    }

    public boolean isNormal() {
        return this.normal;
    }

    public boolean isPassivating() {
        return this.passivating;
    }

    @Override
    protected Set<Class<? extends Annotation>> getMetaAnnotationTypes() {
        return META_ANNOTATIONS;
    }

    @Override
    public String toString() {
        String valid = this.isValid() ? "Valid " : "Invalid";
        String normal = this.isNormal() ? "normal " : "non-normal ";
        String passivating = this.isPassivating() ? "passivating " : "pon-passivating ";
        return valid + normal + passivating + " scope model for " + String.valueOf(this.getRawType());
    }
}

