/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanAttributes;
import java.lang.reflect.Method;
import java.util.Set;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.bean.AbstractBean;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.AbstractProducerBean;
import org.jboss.weld.bean.BeanIdentifiers;
import org.jboss.weld.bean.DisposalMethod;
import org.jboss.weld.bean.ProducerMethodIdentifier;
import org.jboss.weld.bean.StringBeanIdentifier;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.injection.producer.ProducerMethodProducer;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.serialization.spi.BeanIdentifier;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.Proxies;
import org.jboss.weld.util.reflection.Formats;

public class ProducerMethod<X, T>
extends AbstractProducerBean<X, T, Method> {
    private final boolean proxiable;
    private final AnnotatedMethod<? super X> annotatedMethod;
    private volatile EnhancedAnnotatedMethod<T, ? super X> enhancedAnnotatedMethod;

    public static <X, T> ProducerMethod<X, T> of(BeanAttributes<T> attributes, EnhancedAnnotatedMethod<T, ? super X> method, AbstractClassBean<X> declaringBean, DisposalMethod<X, ?> disposalMethod, BeanManagerImpl beanManager, ServiceRegistry services) {
        return new ProducerMethod<X, T>(ProducerMethod.createId(attributes, method, declaringBean), attributes, method, declaringBean, disposalMethod, beanManager, services);
    }

    private static BeanIdentifier createId(BeanAttributes<?> attributes, EnhancedAnnotatedMethod<?, ?> method, AbstractClassBean<?> declaringBean) {
        if (Dependent.class.equals(attributes.getScope()) || ApplicationScoped.class.equals(attributes.getScope())) {
            return new ProducerMethodIdentifier(method, declaringBean);
        }
        return new StringBeanIdentifier(BeanIdentifiers.forProducerMethod(method, declaringBean));
    }

    protected ProducerMethod(BeanIdentifier identifier, BeanAttributes<T> attributes, EnhancedAnnotatedMethod<T, ? super X> method, AbstractClassBean<X> declaringBean, DisposalMethod<X, ?> disposalMethod, BeanManagerImpl beanManager, ServiceRegistry services) {
        super(attributes, identifier, declaringBean, beanManager, services);
        this.enhancedAnnotatedMethod = method;
        this.annotatedMethod = method.slim();
        this.initType();
        this.proxiable = Proxies.isTypesProxyable(method.getTypeClosure(), beanManager.getServices());
        this.setProducer(new ProducerMethodProducer<X, T>(method, disposalMethod){

            @Override
            public BeanManagerImpl getBeanManager() {
                return ProducerMethod.this.beanManager;
            }

            @Override
            public Bean<X> getDeclaringBean() {
                return ProducerMethod.this.getDeclaringBean();
            }

            @Override
            public Bean<T> getBean() {
                return ProducerMethod.this;
            }
        });
        this.processExplicitPriority();
    }

    @Override
    public AnnotatedMethod<? super X> getAnnotated() {
        return this.annotatedMethod;
    }

    @Override
    public EnhancedAnnotatedMethod<T, ? super X> getEnhancedAnnotated() {
        return Beans.checkEnhancedAnnotatedAvailable(this.enhancedAnnotatedMethod);
    }

    @Override
    public void cleanupAfterBoot() {
        this.enhancedAnnotatedMethod = null;
    }

    @Override
    protected void specialize() {
        Set<AbstractBean<?, ?>> specializedBeans = this.getSpecializedBeans();
        if (specializedBeans.isEmpty()) {
            throw BeanLogger.LOG.producerMethodNotSpecializing(this, Formats.formatAsStackTraceElement(this.annotatedMethod.getJavaMember()));
        }
    }

    @Override
    public String toString() {
        return "Producer Method [" + Formats.formatType(this.getAnnotated().getBaseType()) + "] with qualifiers [" + Formats.formatAnnotations(this.getQualifiers()) + "] declared as [" + String.valueOf(this.getAnnotated()) + "]";
    }

    @Override
    public boolean isProxyable() {
        return this.proxiable;
    }
}

