/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.diagnostics.AbstractDiagnostic;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.validation.EObjectDiagnosticImpl;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureNames;
import org.eclipse.xtext.xbase.scoping.batch.IIdentifiableElementDescription;
import org.eclipse.xtext.xbase.scoping.featurecalls.OperatorMapping;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.arguments.IFeatureCallArgumentSlot;
import org.eclipse.xtext.xbase.typesystem.computation.IFeatureLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ILinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationState;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractPendingLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.AmbiguousFeatureLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.CandidateCompareResult;
import org.eclipse.xtext.xbase.typesystem.internal.ExpressionTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.FeatureLinkHelper;
import org.eclipse.xtext.xbase.typesystem.internal.ImplicitFirstArgument;
import org.eclipse.xtext.xbase.typesystem.internal.ImplicitReceiver;
import org.eclipse.xtext.xbase.typesystem.internal.ResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.SuspiciouslyOverloadedCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.TypeExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.util.FeatureKinds;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xbase.typesystem.util.DeferredTypeParameterHintCollector;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.VarianceInfo;
import org.eclipse.xtext.xbase.util.XExpressionHelper;

public class FeatureLinkingCandidate
extends AbstractPendingLinkingCandidate<XAbstractFeatureCall>
implements IFeatureLinkingCandidate,
IFeatureNames {
    public FeatureLinkingCandidate(XAbstractFeatureCall featureCall, IIdentifiableElementDescription description, ITypeExpectation expectation, ExpressionTypeComputationState state) {
        super(featureCall, description, expectation, state);
    }

    @Override
    protected ILinkingCandidate createAmbiguousLinkingCandidate(AbstractPendingLinkingCandidate<?> second) {
        return new AmbiguousFeatureLinkingCandidate(this, second);
    }

    @Override
    protected ILinkingCandidate createSuspiciousLinkingCandidate(AbstractPendingLinkingCandidate<?> chosenCandidate) {
        return new SuspiciouslyOverloadedCandidate((FeatureLinkingCandidate)chosenCandidate, this);
    }

    @Override
    protected boolean isRawTypeContext() {
        if (this.isThisOrSuper()) {
            return false;
        }
        LightweightTypeReference receiverType = this.getReceiverType();
        return receiverType != null && receiverType.isRawType();
    }

    @Override
    protected void initializeMapping(JvmTypeParameter typeParameter, Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> result) {
        ITypeReferenceOwner owner = this.getState().getReferenceOwner();
        if (typeParameter.getDeclarator() instanceof JvmType && owner.getDeclaredTypeParameters().contains(typeParameter)) {
            ParameterizedTypeReference typeReference = owner.newParameterizedTypeReference((JvmType)typeParameter);
            result.put(typeParameter, new LightweightMergedBoundTypeArgument(typeReference, VarianceInfo.INVARIANT));
        } else {
            super.initializeMapping(typeParameter, result);
        }
    }

    @Override
    protected List<XExpression> getArguments() {
        List<XExpression> syntacticArguments = this.getSyntacticArguments();
        XExpression firstArgument = this.getFirstArgument();
        if (firstArgument != null) {
            return this.createArgumentList(firstArgument, syntacticArguments);
        }
        return syntacticArguments;
    }

    @Override
    public boolean validate(IAcceptor<? super AbstractDiagnostic> result) {
        EObjectDiagnosticImpl diagnostic;
        String message;
        XAbstractFeatureCall featureCall = this.getFeatureCall();
        if (this.isReassignFirstArgument(featureCall)) {
            XBinaryOperation binaryOperation = (XBinaryOperation)featureCall;
            LightweightTypeReference actualType = this.getDeclaredType(featureCall.getFeature());
            LightweightTypeReference expectedType = this.getActualType(binaryOperation.getLeftOperand());
            if (!expectedType.getIdentifier().equals(actualType.getIdentifier())) {
                EObjectDiagnosticImpl diagnostic2 = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.incompatible_types", String.format("Type mismatch: cannot convert from %s to %s", actualType.getHumanReadableName(), expectedType.getHumanReadableName()), this.getExpression(), (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, -1, null);
                result.accept((Object)diagnostic2);
                return false;
            }
        }
        if (this.isInvalidStaticSyntax()) {
            Severity severity = this.getSeverity("org.eclipse.xtext.xbase.validation.IssueCodes.instance_access_to_static_member");
            if (severity != Severity.IGNORE) {
                message = String.format("The static %1$s %2$s%3$s should be accessed in a static way", this.getFeatureTypeName(), this.getFeature().getSimpleName(), this.getFeatureParameterTypesAsString());
                diagnostic = new EObjectDiagnosticImpl(severity, "org.eclipse.xtext.xbase.validation.IssueCodes.instance_access_to_static_member", message, this.getExpression(), (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, -1, null);
                result.accept((Object)diagnostic);
                return false;
            }
            return true;
        }
        if (!this.isStatic() && this.isStaticAccessSyntax()) {
            EObject featureOwner = this.getFeature().eContainer();
            message = String.format("Cannot make a static reference to the non-static %1$s %2$s%3$s", this.getFeatureTypeName(), this.getFeature().getSimpleName(), this.getFeatureParameterTypesAsString());
            if (featureOwner instanceof JvmDeclaredType) {
                message = message + " from the type " + ((JvmDeclaredType)featureOwner).getSimpleName();
            }
            diagnostic = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.static_access_to_instance_member", message, this.getExpression(), (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, -1, null);
            result.accept((Object)diagnostic);
            return false;
        }
        if (super.validate(result)) {
            List<JvmDeclaredType> enclosingTypes;
            LightweightTypeReference receiverType;
            JvmMember member;
            XMemberFeatureCall memberFeatureCall;
            XExpression target;
            Severity severity;
            JvmOperation operation;
            String message2;
            if (this.isOperationCallSyntax() && !(this.getFeature() instanceof JvmExecutable)) {
                String typeName = this.getFeatureTypeName();
                String code = "org.eclipse.xtext.xbase.validation.IssueCodes.field_access_with_parentheses";
                if (!(this.getFeature() instanceof JvmField)) {
                    code = "org.eclipse.xtext.xbase.validation.IssueCodes.local_var_access_with_parentheses";
                }
                message2 = "Cannot access the " + typeName + " " + this.getFeature().getSimpleName() + " with parentheses";
                EObjectDiagnosticImpl diagnostic3 = new EObjectDiagnosticImpl(Severity.ERROR, code, message2, this.getExpression(), (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, -1, null);
                result.accept((Object)diagnostic3);
                return false;
            }
            JvmIdentifiableElement feature = this.getFeature();
            if (feature instanceof JvmType) {
                QualifiedName featureName = this.description.getName();
                if (!this.getState().isInstanceContext()) {
                    if (!SELF.equals((Object)featureName)) {
                        message2 = String.format("Cannot use %s in a static context", featureName);
                        EObjectDiagnosticImpl diagnostic4 = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.static_access_to_instance_member", message2, this.getExpression(), (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, -1, null);
                        result.accept((Object)diagnostic4);
                        return false;
                    }
                } else if (this.getExpression() instanceof XMemberFeatureCall && !SELF.equals((Object)featureName)) {
                    XMemberFeatureCall memberFeatureCall2 = (XMemberFeatureCall)this.getExpression();
                    XAbstractFeatureCall target2 = (XAbstractFeatureCall)memberFeatureCall2.getMemberCallTarget();
                    final JvmType referencedType = (JvmType)target2.getFeature();
                    List<JvmDeclaredType> enclosingTypes2 = this.getState().getFeatureScopeSession().getEnclosingTypes();
                    if (SUPER.equals((Object)featureName) && referencedType instanceof JvmGenericType && ((JvmGenericType)referencedType).isInterface() && !enclosingTypes2.isEmpty()) {
                        if (!Iterables.any((Iterable)enclosingTypes2.get(0).getSuperTypes(), (Predicate)new Predicate<JvmTypeReference>(){

                            public boolean apply(JvmTypeReference input) {
                                return input.getType() == referencedType;
                            }
                        })) {
                            String message3 = String.format("The enclosing type does not extend or implement the interface %s", referencedType.getSimpleName());
                            EObjectDiagnosticImpl diagnostic5 = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.no_enclosing_instance_available", message3, this.getExpression(), (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, -1, null);
                            result.accept((Object)diagnostic5);
                            return false;
                        }
                    } else if (!enclosingTypes2.contains(referencedType)) {
                        String message4 = String.format("No enclosing instance of the type %s is accessible in scope", referencedType.getSimpleName());
                        EObjectDiagnosticImpl diagnostic6 = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.no_enclosing_instance_available", message4, this.getExpression(), (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, -1, null);
                        result.accept((Object)diagnostic6);
                        return false;
                    }
                } else if (this.getExpression() instanceof XFeatureCall && SUPER.equals((Object)featureName)) {
                    EObject typeSource;
                    XClosure closure;
                    List<JvmDeclaredType> enclosingTypes3 = this.getState().getFeatureScopeSession().getEnclosingTypes();
                    JvmDeclaredType declaringType = null;
                    if (!enclosingTypes3.isEmpty()) {
                        declaringType = enclosingTypes3.get(0);
                    }
                    if (declaringType instanceof JvmGenericType && ((JvmGenericType)declaringType).isInterface()) {
                        if (!this.getState().isIgnored("org.eclipse.xtext.xbase.validation.IssueCodes.unqualified_super_call")) {
                            EObjectDiagnosticImpl diagnostic7 = new EObjectDiagnosticImpl(this.getSeverity("org.eclipse.xtext.xbase.validation.IssueCodes.unqualified_super_call"), "org.eclipse.xtext.xbase.validation.IssueCodes.unqualified_super_call", "Unqualified super reference is not allowed in interface context", this.getExpression(), (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, -1, null);
                            result.accept((Object)diagnostic7);
                            return false;
                        }
                    } else if (declaringType != null && declaringType != feature && declaringType.isLocal() && (closure = (XClosure)EcoreUtil2.getContainerOfType((EObject)featureCall, XClosure.class)) != null && (typeSource = this.getState().getReferenceOwner().getServices().getJvmModelAssociations().getPrimarySourceElement((EObject)declaringType)) != null && EcoreUtil.isAncestor((EObject)typeSource, (EObject)closure)) {
                        EObjectDiagnosticImpl diagnostic8 = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_super_call", "Cannot call super of an anonymous class from a lambda expression", this.getExpression(), (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, -1, null);
                        result.accept((Object)diagnostic8);
                        return false;
                    }
                }
            }
            if (feature instanceof XVariableDeclaration) {
                EObjectDiagnosticImpl diagnostic9;
                XVariableDeclaration casted = (XVariableDeclaration)feature;
                if (casted.isWriteable() && (message2 = this.getState().getResolver().getInvalidWritableVariableAccessMessage(casted, this.getFeatureCall(), this.getState().getResolvedTypes())) != null) {
                    diagnostic9 = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_mutable_variable_access", message2, this.getExpression(), (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, -1, null);
                    result.accept((Object)diagnostic9);
                    return false;
                }
                if (EcoreUtil.isAncestor((EObject)casted, (EObject)this.getFeatureCall())) {
                    message2 = String.format("The local variable %s may not have been initialized", feature.getSimpleName());
                    diagnostic9 = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.illegal_forward_reference", message2, this.getExpression(), (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, -1, null);
                    result.accept((Object)diagnostic9);
                    return false;
                }
            }
            if (feature instanceof JvmOperation && (operation = (JvmOperation)feature).isAbstract() && featureCall instanceof XMemberFeatureCall && (severity = this.getSeverity("org.eclipse.xtext.xbase.validation.IssueCodes.abstract_method_invocation")) != Severity.IGNORE && (target = (memberFeatureCall = (XMemberFeatureCall)featureCall).getMemberCallTarget()) instanceof XAbstractFeatureCall && SUPER.getFirstSegment().equals(((XAbstractFeatureCall)target).getConcreteSyntaxFeatureName())) {
                JvmIdentifiableElement targetFeature = ((XAbstractFeatureCall)target).getFeature();
                String message5 = String.format("Cannot directly invoke the abstract method %s%s of the type %s", operation.getSimpleName(), this.getFeatureParameterTypesAsString((JvmExecutable)operation), targetFeature.getSimpleName());
                EObjectDiagnosticImpl diagnostic10 = new EObjectDiagnosticImpl(severity, "org.eclipse.xtext.xbase.validation.IssueCodes.abstract_method_invocation", message5, (EObject)memberFeatureCall, (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, -1, null);
                result.accept((Object)diagnostic10);
                return false;
            }
            if (feature instanceof JvmMember && (member = (JvmMember)feature).getVisibility() == JvmVisibility.PRIVATE && (receiverType = this.getReceiverType()) != null && receiverType.getType() != member.getDeclaringType() && (enclosingTypes = this.getState().getFeatureScopeSession().getEnclosingTypes()).contains(member.getDeclaringType())) {
                String message6 = String.format("Cannot access the private %s %s%s in a subclass context", this.getFeatureTypeName(), member.getSimpleName(), this.getFeatureParameterTypesAsString());
                String[] issueData = null;
                issueData = new String[]{"subclass-context", member.getDeclaringType().getSimpleName()};
                EObjectDiagnosticImpl diagnostic11 = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.invisible_feature", message6, (EObject)featureCall, (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, -1, issueData);
                result.accept((Object)diagnostic11);
                return false;
            }
        }
        if (this.isGetClassOnTypeLiteral() && "class".equals(this.description.getName().getFirstSegment())) {
            LightweightTypeReference receiverType = this.getSyntacticReceiverType();
            if (receiverType == null) {
                throw new IllegalStateException();
            }
            receiverType = receiverType.getTypeArguments().get(0);
            message = String.format("The syntax for type literals is typeof(%s) or %s.", receiverType.getHumanReadableName(), receiverType.getHumanReadableName());
            diagnostic = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.unexpected_invocation_on_type_literal", message, this.getExpression(), (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, -1, null);
            result.accept((Object)diagnostic);
            return false;
        }
        return true;
    }

    @Override
    protected boolean validateArity(IAcceptor<? super AbstractDiagnostic> result) {
        JvmIdentifiableElement feature;
        XExpression implicitReceiver;
        if (this.getFeatureCall() instanceof XFeatureCall && (implicitReceiver = this.getImplicitReceiver()) instanceof XFeatureCall && (feature = ((XFeatureCall)implicitReceiver).getFeature()) instanceof JvmType && !this.getState().isInstanceContext()) {
            return false;
        }
        return super.validateArity(result);
    }

    protected boolean isReassignFirstArgument(XAbstractFeatureCall featureCall) {
        if (featureCall instanceof XBinaryOperation) {
            XBinaryOperation binaryOperation = (XBinaryOperation)featureCall;
            return binaryOperation.isReassignFirstArgument();
        }
        return false;
    }

    protected boolean isInvalidStaticSyntax() {
        boolean result;
        boolean bl = result = this.isStatic() && !this.isExtension() && this.isAssignmentOrMemberFeatureCall() && !this.isStaticWithDeclaringType();
        return result;
    }

    protected boolean isStaticWithDeclaringType() {
        XAbstractFeatureCall featureCall = this.getFeatureCall();
        if (featureCall instanceof XMemberFeatureCall) {
            return ((XMemberFeatureCall)featureCall).isStaticWithDeclaringType();
        }
        if (featureCall instanceof XAssignment) {
            return this.isStaticWithDeclaringType((XAssignment)featureCall);
        }
        return false;
    }

    protected boolean isStaticWithDeclaringType(XAssignment assignment) {
        return assignment.isExplicitStatic() || this.isImplicitlyStatic(assignment);
    }

    protected boolean isImplicitlyStatic(XAssignment assignment) {
        return assignment.isStatic() && this.isTypeLiteral(assignment.getAssignable());
    }

    protected boolean isTypeLiteral(XExpression expression) {
        return expression instanceof XAbstractFeatureCall && ((XAbstractFeatureCall)expression).isTypeLiteral();
    }

    protected boolean isOperationCallSyntax() {
        XAbstractFeatureCall featureCall = this.getFeatureCall();
        if (featureCall instanceof XBinaryOperation || featureCall instanceof XAssignment) {
            return false;
        }
        return featureCall.isExplicitOperationCallOrBuilderSyntax();
    }

    @Override
    protected String getFeatureTypeName() {
        JvmIdentifiableElement feature = this.getFeature();
        String result = FeatureKinds.getTypeName(feature);
        return result;
    }

    protected boolean isStaticAccessSyntax() {
        XAbstractFeatureCall featureCall = this.getFeatureCall();
        if (featureCall instanceof XMemberFeatureCall) {
            return ((XMemberFeatureCall)featureCall).isExplicitStatic();
        }
        return false;
    }

    protected boolean isAssignmentOrMemberFeatureCall() {
        if (this.getImplicitReceiverType() != null) {
            return true;
        }
        XAbstractFeatureCall featureCall = this.getFeatureCall();
        if (featureCall instanceof XAssignment) {
            return this.isSimpleAssignment((XAssignment)featureCall);
        }
        return featureCall instanceof XMemberFeatureCall;
    }

    protected boolean isSimpleAssignment(XAssignment assignment) {
        return assignment.getAssignable() != null;
    }

    protected List<XExpression> createArgumentList(XExpression head, List<XExpression> tail) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)(tail.size() + 1));
        result.add(head);
        int size = tail.size();
        for (int i = 0; i < size; ++i) {
            XExpression expression = tail.get(i);
            result.add(expression);
        }
        return result;
    }

    @Override
    protected List<XExpression> getSyntacticArguments() {
        return new FeatureLinkHelper().getSyntacticArguments(this.getFeatureCall());
    }

    @Override
    public boolean isExtension() {
        return this.description.isExtension();
    }

    @Override
    protected boolean hasReceiver() {
        return !this.isStatic();
    }

    @Override
    public boolean isStatic() {
        return this.description.isStatic();
    }

    protected boolean isSyntacticReceiverPossibleArgument() {
        return this.description.isSyntacticReceiverPossibleArgument();
    }

    @Override
    public boolean isTypeLiteral() {
        return false;
    }

    @Override
    protected CandidateCompareResult getExpectedTypeCompareResultOther(AbstractPendingLinkingCandidate<?> right) {
        if (!(right instanceof FeatureLinkingCandidate) || this.getState().isIgnored("org.eclipse.xtext.xbase.validation.IssueCodes.suspiciously_overloaded_feature")) {
            return CandidateCompareResult.OTHER;
        }
        FeatureLinkingCandidate casted = (FeatureLinkingCandidate)right;
        XExpression otherImplicitReceiver = casted.getImplicitReceiver();
        if (otherImplicitReceiver != null) {
            JvmIdentifiableElement otherImplicitReceiverFeature;
            if (this.isStatic() == casted.isStatic() && otherImplicitReceiver instanceof XAbstractFeatureCall && this.getImplicitReceiver() instanceof XAbstractFeatureCall && (otherImplicitReceiverFeature = ((XAbstractFeatureCall)otherImplicitReceiver).getFeature()) != ((XAbstractFeatureCall)this.getImplicitReceiver()).getFeature()) {
                return CandidateCompareResult.SUSPICIOUS_OTHER;
            }
        } else if (this.isStatic() && casted.isStatic()) {
            JvmIdentifiableElement otherFeature = casted.getFeature();
            if (this.getFeature().eContainer() != otherFeature.eContainer() && otherFeature.eResource() == ((XAbstractFeatureCall)this.getExpression()).eResource() && EcoreUtil.isAncestor((EObject)otherFeature.eContainer(), (EObject)this.getFeature())) {
                return CandidateCompareResult.SUSPICIOUS_OTHER;
            }
        }
        return CandidateCompareResult.OTHER;
    }

    @Override
    protected int getConformanceFlags(int idx, boolean recompute) {
        if (this.isStatic() && idx == -1) {
            return 0x100200;
        }
        if (idx == 0) {
            if (this.getReceiver() != null) {
                int result = this.getReceiverConformanceFlags();
                return result;
            }
        } else if (idx == 1 && this.getExpression() instanceof XAssignment && this.getFeature() instanceof JvmField) {
            return super.getConformanceFlags(0, recompute);
        }
        return super.getConformanceFlags(idx, recompute);
    }

    @Override
    protected boolean isLambdaExpression(int argumentIdx) {
        if (this.isStatic() && argumentIdx == -1) {
            return false;
        }
        if (argumentIdx == 0 && this.getReceiver() != null) {
            return this.getReceiver() instanceof XClosure;
        }
        return super.isLambdaExpression(argumentIdx);
    }

    @Override
    protected LightweightTypeReference getSubstitutedExpectedType(int idx) {
        if (idx == -1) {
            return null;
        }
        if (idx == 0 && this.getReceiver() != null) {
            return null;
        }
        return super.getSubstitutedExpectedType(idx);
    }

    protected boolean isExplicitOperationCall() {
        return this.getFeatureCall().isExplicitOperationCallOrBuilderSyntax();
    }

    @Override
    protected CandidateCompareResult compareByName(AbstractPendingLinkingCandidate<?> right) {
        boolean otherCompoundOperator;
        if (!(right instanceof FeatureLinkingCandidate)) {
            return super.compareByName(right);
        }
        FeatureLinkingCandidate other = (FeatureLinkingCandidate)right;
        boolean thisCompoundOperator = this.isCompoundOperator();
        if (thisCompoundOperator == (otherCompoundOperator = other.isCompoundOperator())) {
            return CandidateCompareResult.AMBIGUOUS;
        }
        if (thisCompoundOperator) {
            return CandidateCompareResult.THIS;
        }
        return CandidateCompareResult.OTHER;
    }

    @Override
    protected CandidateCompareResult compareByArgumentTypes(AbstractPendingLinkingCandidate<?> right) {
        CandidateCompareResult result = super.compareByArgumentTypes(right);
        if (result == CandidateCompareResult.AMBIGUOUS && !right.isTypeLiteral()) {
            result = this.compareByNameAndStaticFlag(right);
        }
        return result;
    }

    @Override
    protected CandidateCompareResult compareByArgumentTypes(AbstractPendingLinkingCandidate<?> right, boolean recompute) {
        CandidateCompareResult result = super.compareByArgumentTypes(right, recompute);
        if (result == CandidateCompareResult.AMBIGUOUS && this.getExpression() instanceof XAssignment && this.description.isValidStaticState() == right.description.isValidStaticState() && this.getFeature() instanceof JvmExecutable != right.getFeature() instanceof JvmExecutable) {
            if (this.getFeature() instanceof JvmExecutable) {
                return CandidateCompareResult.OTHER;
            }
            return CandidateCompareResult.THIS;
        }
        return result;
    }

    protected CandidateCompareResult compareByNameAndStaticFlag(AbstractPendingLinkingCandidate<?> right) {
        if (!this.getFeature().getSimpleName().equals(right.getFeature().getSimpleName())) {
            if (this.description.isValidStaticState() == right.description.isValidStaticState()) {
                String concreteSyntax = this.description.getName().getFirstSegment();
                if (this.getFeature().getSimpleName().equals(concreteSyntax) && this.getFeatureCall().isExplicitOperationCallOrBuilderSyntax() == this.getFeature() instanceof JvmExecutable) {
                    return CandidateCompareResult.THIS;
                }
                if (right.getFeature().getSimpleName().equals(concreteSyntax) && this.getFeatureCall().isExplicitOperationCallOrBuilderSyntax() == right.getFeature() instanceof JvmExecutable) {
                    return CandidateCompareResult.OTHER;
                }
            }
            if (this.isStatic() != right.description.isStatic()) {
                if (this.isStatic()) {
                    return CandidateCompareResult.OTHER;
                }
                return CandidateCompareResult.THIS;
            }
        } else if (right instanceof FeatureLinkingCandidate) {
            FeatureLinkingCandidate casted = (FeatureLinkingCandidate)right;
            if (this.getFeature() instanceof JvmField == casted.getFeature() instanceof JvmField) {
                if (this.isStatic()) {
                    if (!casted.isStatic()) {
                        return CandidateCompareResult.OTHER;
                    }
                } else if (casted.isStatic()) {
                    return CandidateCompareResult.THIS;
                }
                if (this.description.isValidStaticState() != right.description.isValidStaticState()) {
                    if (this.description.isValidStaticState()) {
                        return CandidateCompareResult.THIS;
                    }
                    return CandidateCompareResult.OTHER;
                }
            }
        }
        if (!(this.getExpression() instanceof XAssignment) && this.isExplicitOperationCall()) {
            if (this.getFeature() instanceof JvmExecutable) {
                if (!(right.getFeature() instanceof JvmExecutable)) {
                    return CandidateCompareResult.THIS;
                }
            } else if (right.getFeature() instanceof JvmExecutable) {
                return CandidateCompareResult.OTHER;
            }
        } else if (this.getFeature() instanceof JvmExecutable) {
            if (!(right.getFeature() instanceof JvmExecutable)) {
                return CandidateCompareResult.OTHER;
            }
        } else if (right.getFeature() instanceof JvmExecutable) {
            return CandidateCompareResult.THIS;
        }
        return CandidateCompareResult.AMBIGUOUS;
    }

    protected boolean isCompoundOperator() {
        if (!(this.getFeatureCall() instanceof XBinaryOperation)) {
            return false;
        }
        String methodName = this.getFeature().getSimpleName();
        return this.getState().getReferenceOwner().getServices().getOperatorMapping().isCompoundMethod(methodName);
    }

    @Override
    protected CandidateCompareResult compareByBucket(AbstractPendingLinkingCandidate<?> right) {
        if (this.isExtension() && right.isExtension()) {
            if (this.description.getShadowingKey().equals(right.description.getShadowingKey())) {
                if (this.description.getBucketId() == right.description.getBucketId()) {
                    return CandidateCompareResult.AMBIGUOUS;
                }
                if (this.isAmbiguousExtensionProvider(right)) {
                    return CandidateCompareResult.AMBIGUOUS;
                }
                return CandidateCompareResult.THIS;
            }
            return CandidateCompareResult.AMBIGUOUS;
        }
        return super.compareByBucket(right);
    }

    protected boolean isAmbiguousExtensionProvider(AbstractPendingLinkingCandidate<?> right) {
        XExpression otherImplicitReceiver;
        XExpression implicitReceiver = this.getImplicitReceiver();
        if (implicitReceiver instanceof XAbstractFeatureCall && (otherImplicitReceiver = right.description.getImplicitReceiver()) instanceof XAbstractFeatureCall) {
            JvmIdentifiableElement feature = ((XAbstractFeatureCall)implicitReceiver).getFeature();
            JvmIdentifiableElement otherFeature = ((XAbstractFeatureCall)otherImplicitReceiver).getFeature();
            if (feature.eContainer() == otherFeature.eContainer()) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected CandidateCompareResult compareTo(AbstractPendingLinkingCandidate<?> right, boolean invalid) {
        CandidateCompareResult compareResult = this.compareByAssignmentName(right);
        switch (compareResult) {
            case SUSPICIOUS_OTHER: {
                throw new IllegalStateException();
            }
            case EQUALLY_INVALID: {
                invalid = true;
                break;
            }
            case OTHER: 
            case THIS: {
                return compareResult;
            }
        }
        return super.compareTo(right, invalid);
    }

    protected CandidateCompareResult compareByAssignmentName(AbstractPendingLinkingCandidate<?> right) {
        if (this.getExpression() instanceof XAssignment) {
            if (this.isValidAssignmentName(this.description)) {
                if (!this.isValidAssignmentName(right.description)) {
                    return CandidateCompareResult.THIS;
                }
            } else {
                if (this.isValidAssignmentName(right.description)) {
                    return CandidateCompareResult.OTHER;
                }
                return CandidateCompareResult.EQUALLY_INVALID;
            }
        }
        return CandidateCompareResult.AMBIGUOUS;
    }

    protected boolean isValidAssignmentName(IIdentifiableElementDescription description) {
        JvmIdentifiableElement candidate = description.getElementOrProxy();
        if (candidate.eClass() == TypesPackage.Literals.JVM_OPERATION) {
            if (candidate.getSimpleName().equals(description.getName().getFirstSegment())) {
                return false;
            }
            if (!candidate.getSimpleName().startsWith("set")) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected CandidateCompareResult compareByArityWith(AbstractPendingLinkingCandidate<?> right) {
        CandidateCompareResult result = super.compareByArityWith(right);
        if (result == CandidateCompareResult.AMBIGUOUS) {
            boolean isExecutable = this.getFeature() instanceof JvmExecutable;
            if (isExecutable != right.getFeature() instanceof JvmExecutable && this.isVisible() == right.isVisible() && this.isTypeLiteral() == right.isTypeLiteral()) {
                if (!(this.getExpression() instanceof XAssignment) && this.isExplicitOperationCall()) {
                    if (isExecutable) {
                        return CandidateCompareResult.THIS;
                    }
                    return CandidateCompareResult.OTHER;
                }
            } else if (this.getFeature() == right.getFeature() && right instanceof FeatureLinkingCandidate) {
                FeatureLinkingCandidate casted = (FeatureLinkingCandidate)right;
                if (this.isStatic() && casted.isStatic()) {
                    if (this.getImplicitReceiver() != casted.getImplicitReceiver()) {
                        if (this.getImplicitReceiver() != null) {
                            return CandidateCompareResult.OTHER;
                        }
                        return CandidateCompareResult.THIS;
                    }
                    if (this.getReceiver() == casted.getReceiver() && this.isSyntacticReceiverPossibleArgument() == casted.isSyntacticReceiverPossibleArgument()) {
                        return CandidateCompareResult.THIS;
                    }
                }
            }
        }
        return result;
    }

    @Override
    protected CandidateCompareResult compareByArgumentTypesFlags(AbstractPendingLinkingCandidate<?> right, int leftIdx, int rightIdx, int leftConformance, int rightConformance) {
        boolean rightFirstArgumentMismatch;
        CandidateCompareResult result = super.compareByArgumentTypesFlags(right, leftIdx, rightIdx, leftConformance, rightConformance);
        if (result != CandidateCompareResult.EQUALLY_INVALID && result != CandidateCompareResult.AMBIGUOUS || (leftConformance & 0x200) != 0 || !(right instanceof FeatureLinkingCandidate)) {
            return result;
        }
        boolean firstArgumentMismatch = this.isFirstArgument(leftIdx);
        if (firstArgumentMismatch != (rightFirstArgumentMismatch = ((FeatureLinkingCandidate)right).isFirstArgument(rightIdx))) {
            if (firstArgumentMismatch) {
                return CandidateCompareResult.OTHER;
            }
            return CandidateCompareResult.THIS;
        }
        return result;
    }

    protected boolean isFirstArgument(int argumentIndex) {
        if (argumentIndex > 1 || this.getFirstArgument() == null) {
            return false;
        }
        if (this.isStatic()) {
            return argumentIndex == 0;
        }
        return argumentIndex == 1;
    }

    @Override
    protected CandidateCompareResult compareByArgumentTypes(AbstractPendingLinkingCandidate<?> right, int leftBoxing, int rightBoxing, int leftDemand, int rightDemand) {
        if (leftDemand != rightDemand) {
            if (leftDemand < rightDemand) {
                return CandidateCompareResult.THIS;
            }
            return CandidateCompareResult.OTHER;
        }
        if (right instanceof FeatureLinkingCandidate) {
            FeatureLinkingCandidate casted = (FeatureLinkingCandidate)right;
            return this.compareByArgumentTypes(casted, leftBoxing, rightBoxing);
        }
        return this.compareByBoxing(leftBoxing, rightBoxing);
    }

    protected CandidateCompareResult compareByArgumentTypes(FeatureLinkingCandidate right, int leftBoxing, int rightBoxing) {
        if (this.isExtension() != right.isExtension()) {
            if (this.description.isValidStaticState() != right.description.isValidStaticState()) {
                if (this.description.isValidStaticState()) {
                    return CandidateCompareResult.THIS;
                }
                return CandidateCompareResult.OTHER;
            }
            if (this.isExtension()) {
                return CandidateCompareResult.OTHER;
            }
            return CandidateCompareResult.THIS;
        }
        if (this.isExtension() && this.isStatic() != right.isStatic()) {
            if (this.isStatic()) {
                return CandidateCompareResult.OTHER;
            }
            return CandidateCompareResult.THIS;
        }
        return this.compareByArgumentTypesAndStaticFlag(right, leftBoxing, rightBoxing);
    }

    protected CandidateCompareResult compareByArgumentTypesAndStaticFlag(FeatureLinkingCandidate right, int leftBoxing, int rightBoxing) {
        if (this.isStatic() != right.isStatic()) {
            if (this.isSyntacticReceiverPossibleArgument() != right.isSyntacticReceiverPossibleArgument()) {
                if (this.isStatic() && !this.isSyntacticReceiverPossibleArgument()) {
                    return CandidateCompareResult.THIS;
                }
                if (right.isStatic() && !right.isSyntacticReceiverPossibleArgument()) {
                    return CandidateCompareResult.OTHER;
                }
            } else if (this.getFeature() instanceof JvmField == right.getFeature() instanceof JvmField) {
                if (this.isStatic()) {
                    if (this.getImplicitReceiver() != null && right.getImplicitReceiver() == null) {
                        return CandidateCompareResult.OTHER;
                    }
                } else if (this.getImplicitReceiver() != null && right.getImplicitReceiver() == null) {
                    return CandidateCompareResult.THIS;
                }
            }
        }
        return this.compareByBoxing(leftBoxing, rightBoxing);
    }

    @Override
    protected void preApply() {
        this.applyImplicitReceiver();
        super.preApply();
        XExpression implicitFirstArgument = this.getImplicitFirstArgument();
        if (implicitFirstArgument != null) {
            new ImplicitFirstArgument(this.getFeatureCall(), (XAbstractFeatureCall)implicitFirstArgument, this.getState()).applyToComputationState();
        }
        this.getState().markAsRefinedTypeIfNecessary(this);
        this.discardRefinementTypeIfReassigned();
    }

    protected void applyImplicitReceiver() {
        XExpression implicitReceiver;
        if (!this.isStatic() && (implicitReceiver = this.getImplicitReceiver()) != null) {
            ResolvedTypes resolvedTypes = this.getState().getResolvedTypes();
            LightweightTypeReference receiverType = this.getImplicitReceiverType();
            if (receiverType == null) {
                throw new IllegalStateException("Cannot determine the receiver's type");
            }
            LightweightTypeReference expectedReceiverType = new FeatureLinkHelper().getExpectedReceiverType(this.getFeature(), receiverType);
            if (expectedReceiverType != null) {
                expectedReceiverType = expectedReceiverType.copyInto(resolvedTypes.getReferenceOwner());
            }
            if (receiverType.isSynonym()) {
                receiverType = receiverType.getMultiTypeComponents().get(0);
            }
            TypeExpectation expectation = new TypeExpectation(expectedReceiverType, this.getState(), false);
            resolvedTypes.acceptType(implicitReceiver, expectation, receiverType.copyInto(resolvedTypes.getReferenceOwner()), false, 0x400000);
            if (implicitReceiver instanceof XAbstractFeatureCall) {
                new ImplicitReceiver(this.getFeatureCall(), (XAbstractFeatureCall)implicitReceiver, this.getState()).applyToComputationState();
            } else {
                throw new IllegalStateException("unexpected implicit receiver, was: " + implicitReceiver);
            }
        }
    }

    @Override
    protected void resolveAgainstActualType(LightweightTypeReference declaredType, LightweightTypeReference actualType, AbstractTypeComputationState state) {
        super.resolveAgainstActualType(declaredType, actualType, state);
        if (!this.isStatic() || (actualType.hasTypeArguments() || actualType.isArray()) && this.getDeclaredTypeParameters().isEmpty()) {
            DeferredTypeParameterHintCollector collector = new DeferredTypeParameterHintCollector(state.getReferenceOwner());
            collector.processPairedReferences(declaredType, actualType);
        }
    }

    @Override
    public XAbstractFeatureCall getFeatureCall() {
        return (XAbstractFeatureCall)this.getExpression();
    }

    @Override
    protected List<JvmTypeReference> getPlainSyntacticTypeArguments() {
        return this.getFeatureCall().getTypeArguments();
    }

    @Override
    protected void resolveArgumentType(XExpression argument, LightweightTypeReference declaredType, ITypeComputationState argumentState) {
        if (argument == this.getSyntacticReceiverIfPossibleArgument()) {
            LightweightTypeReference receiverType = this.getSyntacticReceiverType();
            if (receiverType != null) {
                this.resolveKnownArgumentType(argument, receiverType, declaredType, argumentState);
            }
        } else if (argument == this.getImplicitFirstArgument()) {
            LightweightTypeReference argumentType = this.getImplicitFirstArgumentType();
            if (argumentType != null) {
                this.resolveKnownArgumentType(argument, argumentType, declaredType, argumentState);
            }
        } else {
            super.resolveArgumentType(argument, declaredType, argumentState);
        }
    }

    protected void resolveKnownArgumentType(XExpression argument, LightweightTypeReference knownType, LightweightTypeReference declaredType, ITypeComputationState argumentState) {
        if (!(argumentState instanceof AbstractLinkingCandidate.ArgumentTypeComputationState)) {
            throw new IllegalArgumentException("argumentState was " + argumentState);
        }
        AbstractLinkingCandidate.ArgumentTypeComputationState castedArgumentState = (AbstractLinkingCandidate.ArgumentTypeComputationState)argumentState;
        ResolvedTypes resolvedTypes = this.getState().getResolvedTypes();
        LightweightTypeReference copiedDeclaredType = declaredType != null ? declaredType.copyInto(resolvedTypes.getReferenceOwner()) : null;
        TypeExpectation expectation = new TypeExpectation(copiedDeclaredType, castedArgumentState, false);
        LightweightTypeReference copiedReceiverType = knownType.copyInto(resolvedTypes.getReferenceOwner());
        int defaultFlags = castedArgumentState.getDefaultFlags();
        resolvedTypes.acceptType(argument, expectation, copiedReceiverType, false, 0x400000 | defaultFlags);
        if (copiedDeclaredType != null) {
            this.resolveAgainstActualType(copiedDeclaredType, copiedReceiverType, castedArgumentState);
        }
    }

    @Override
    protected void computeVarArgumentType(IFeatureCallArgumentSlot slot, TypeParameterSubstitutor<?> substitutor) {
        List<XExpression> arguments;
        if (this.isExtension() && (arguments = slot.getArgumentExpressions()).size() == 1 && arguments.get(0) == this.getFirstArgument()) {
            this.computeFixedArityArgumentType(slot, substitutor);
            return;
        }
        super.computeVarArgumentType(slot, substitutor);
    }

    @Override
    protected Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> getDeclaratorParameterMapping() {
        if (this.isStatic()) {
            if (this.getFeature() instanceof JvmConstructor) {
                return this.description.getImplicitReceiverTypeParameterMapping();
            }
            return super.getDeclaratorParameterMapping();
        }
        if (this.getImplicitReceiver() != null) {
            return this.description.getImplicitReceiverTypeParameterMapping();
        }
        return this.description.getSyntacticReceiverTypeParameterMapping();
    }

    protected XExpression getReceiver() {
        if (this.isStatic()) {
            return null;
        }
        XExpression result = this.getImplicitReceiver();
        if (result != null) {
            return result;
        }
        return this.getSyntacticReceiverIfPossibleArgument();
    }

    protected LightweightTypeReference getReceiverType() {
        if (this.isStatic()) {
            return null;
        }
        LightweightTypeReference result = this.getImplicitReceiver() != null ? this.getImplicitReceiverType() : this.getSyntacticReceiverType();
        return result;
    }

    protected int getReceiverConformanceFlags() {
        if (this.isStatic()) {
            throw new IllegalStateException();
        }
        if (this.getImplicitReceiver() != null) {
            return this.description.getImplicitReceiverConformanceFlags();
        }
        if (this.getSyntacticReceiverIfPossibleArgument() != null) {
            return this.description.getSyntacticReceiverConformanceFlags();
        }
        throw new IllegalStateException();
    }

    protected XExpression getFirstArgument() {
        if (!this.isExtension()) {
            return null;
        }
        XExpression firstArgument = this.getImplicitFirstArgument();
        if (firstArgument != null) {
            return firstArgument;
        }
        return this.getSyntacticReceiverIfPossibleArgument();
    }

    protected LightweightTypeReference getFirstArgumentType() {
        if (!this.isExtension()) {
            return null;
        }
        LightweightTypeReference result = this.getImplicitFirstArgumentType();
        if (result != null) {
            return result;
        }
        return this.getSyntacticReceiverType();
    }

    protected XExpression getImplicitReceiver() {
        return this.description.getImplicitReceiver();
    }

    protected LightweightTypeReference getImplicitReceiverType() {
        return this.description.getImplicitReceiverType();
    }

    protected XExpression getSyntacticReceiver() {
        return this.description.getSyntacticReceiver();
    }

    protected XExpression getSyntacticReceiverIfPossibleArgument() {
        if (this.description.isSyntacticReceiverPossibleArgument()) {
            return this.getSyntacticReceiver();
        }
        return null;
    }

    protected LightweightTypeReference getSyntacticReceiverType() {
        return this.description.getSyntacticReceiverType();
    }

    protected XExpression getImplicitFirstArgument() {
        return this.description.getImplicitFirstArgument();
    }

    protected LightweightTypeReference getImplicitFirstArgumentType() {
        return this.description.getImplicitFirstArgumentType();
    }

    @Override
    protected LightweightTypeReference getDeclaredType(JvmIdentifiableElement feature) {
        if (feature instanceof JvmConstructor) {
            return this.getState().getReferenceOwner().toLightweightTypeReference(this.getState().getTypeReferences().getTypeForName(Void.TYPE, (Notifier)feature, new JvmTypeReference[0]));
        }
        if (this.isGetClass(feature)) {
            LightweightTypeReference receiverType = this.getReceiverType();
            if (receiverType == null) {
                throw new IllegalStateException("Cannot determine the receiver's type");
            }
            List<JvmType> rawTypes = receiverType.getRawTypes();
            if (rawTypes.isEmpty()) {
                return super.getDeclaredType(feature);
            }
            ITypeReferenceOwner owner = receiverType.getOwner();
            ParameterizedTypeReference result = owner.newParameterizedTypeReference(((JvmOperation)feature).getReturnType().getType());
            WildcardTypeReference wildcard = owner.newWildcardTypeReference();
            wildcard.addUpperBound(owner.toPlainTypeReference(rawTypes.get(0)));
            result.addTypeArgument(wildcard);
            return result;
        }
        return super.getDeclaredType(feature);
    }

    protected boolean isGetClassOnTypeLiteral() {
        IFeatureLinkingCandidate linkingCandidate;
        XExpression receiver;
        JvmIdentifiableElement feature = this.getFeature();
        return this.isGetClass(feature) && (receiver = this.getSyntacticReceiver()) instanceof XAbstractFeatureCall && (linkingCandidate = this.getState().getResolvedTypes().getLinkingCandidate((XAbstractFeatureCall)receiver)) != null && linkingCandidate.isTypeLiteral();
    }

    protected boolean isGetClass(JvmIdentifiableElement feature) {
        JvmOperation getClassOperation;
        return feature instanceof JvmOperation && feature.getSimpleName().equals("getClass") && (getClassOperation = (JvmOperation)feature).getParameters().isEmpty() && "java.lang.Object".equals(getClassOperation.getDeclaringType().getIdentifier());
    }

    @Override
    public void applyToModel(IResolvedTypes resolvedTypes) {
        this.resolveLinkingProxy(XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, 0);
        XAbstractFeatureCall featureCall = this.getFeatureCall();
        if (featureCall instanceof XMemberFeatureCall) {
            XMemberFeatureCall casted = (XMemberFeatureCall)featureCall;
            XExpression syntacticReceiver = casted.getMemberCallTarget();
            if (this.isStaticWithDeclaringType(syntacticReceiver) || this.isThisOrSuper()) {
                casted.setStaticWithDeclaringType(true);
            }
        } else if (featureCall instanceof XAssignment) {
            XAssignment casted = (XAssignment)featureCall;
            XExpression syntacticReceiver = casted.getAssignable();
            if (this.isStaticWithDeclaringType(syntacticReceiver)) {
                casted.setStaticWithDeclaringType(true);
            }
        } else if (featureCall instanceof XBinaryOperation) {
            XBinaryOperation binaryOperation = (XBinaryOperation)featureCall;
            CommonTypeComputationServices services = this.getState().getReferenceOwner().getServices();
            OperatorMapping operatorMapping = services.getOperatorMapping();
            if (operatorMapping.getCompoundOperators().contains(this.description.getName())) {
                JvmIdentifiableElement feature = this.description.getElementOrProxy();
                String methodName = feature.getSimpleName();
                if (operatorMapping.isCompoundMethod(methodName)) {
                    XExpressionHelper expressionHelper = services.getExpressionHelper();
                    if (expressionHelper.findReassignFirstArgumentAnnotation(feature) != null) {
                        binaryOperation.setReassignFirstArgument(true);
                    }
                } else {
                    binaryOperation.setReassignFirstArgument(true);
                }
            }
        }
    }

    private boolean isThisOrSuper() {
        return (THIS.equals((Object)this.description.getName()) || SUPER.equals((Object)this.description.getName())) && this.description.getElementOrProxy() instanceof JvmType && !this.isSyntacticReceiverPossibleArgument();
    }

    private boolean isStaticWithDeclaringType(XExpression syntacticReceiver) {
        IFeatureLinkingCandidate candidate;
        return this.isStatic() && syntacticReceiver instanceof XAbstractFeatureCall && !this.isExtension() && (candidate = this.getState().getResolvedTypes().getLinkingCandidate((XAbstractFeatureCall)syntacticReceiver)) != null && candidate.isTypeLiteral();
    }

    @Override
    protected Severity getUnhandledExceptionSeverity(JvmExecutable executable) {
        if (this.getFeature() instanceof JvmConstructor) {
            return Severity.ERROR;
        }
        return super.getUnhandledExceptionSeverity(executable);
    }
}

