/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.trace.internal;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.trace.internal.Messages;
import org.eclipse.ui.trace.internal.datamodel.TracingCollections;
import org.eclipse.ui.trace.internal.datamodel.TracingComponentDebugOption;
import org.eclipse.ui.trace.internal.utils.TracingUtils;

public class TracingComponentColumnEditingSupport
extends EditingSupport {
    private int columnIndex;
    private CellEditor textEditor;
    private ComboBoxCellEditor comboEditor;

    public TracingComponentColumnEditingSupport(ColumnViewer viewer, int index) {
        super(viewer);
        this.columnIndex = index;
        switch (this.columnIndex) {
            case 1: {
                this.textEditor = new TextCellEditor((Composite)viewer.getControl(), 0);
                this.comboEditor = new ComboBoxCellEditor((Composite)viewer.getControl(), new String[]{Messages.TracingComponentColumnEditingSupport_true, Messages.TracingComponentColumnEditingSupport_false}, 72);
                this.comboEditor.setActivationStyle(3);
                break;
            }
            default: {
                this.textEditor = null;
                this.comboEditor = null;
            }
        }
    }

    protected boolean canEdit(Object element) {
        boolean canEdit = false;
        switch (this.columnIndex) {
            case 1: {
                return true;
            }
        }
        canEdit = false;
        return canEdit;
    }

    protected CellEditor getCellEditor(Object element) {
        if (element instanceof TracingComponentDebugOption) {
            TracingComponentDebugOption option = (TracingComponentDebugOption)element;
            if (TracingUtils.isValueBoolean(option.getOptionPathValue())) {
                return this.comboEditor;
            }
            return this.textEditor;
        }
        return null;
    }

    protected Object getValue(Object element) {
        Object value = null;
        switch (this.columnIndex) {
            case 1: {
                if (element instanceof TracingComponentDebugOption) {
                    String optionPathValue = ((TracingComponentDebugOption)element).getOptionPathValue();
                    if (TracingUtils.isValueBoolean(optionPathValue)) {
                        value = Boolean.parseBoolean(optionPathValue) ? 0 : 1;
                        break;
                    }
                    value = optionPathValue;
                    break;
                }
                if (!(element instanceof String)) break;
                value = element;
            }
        }
        return value;
    }

    protected void setValue(Object element, Object value) {
        switch (this.columnIndex) {
            case 1: {
                TracingComponentDebugOption[] identicalOptions;
                if (!(element instanceof TracingComponentDebugOption)) break;
                TracingComponentDebugOption option = (TracingComponentDebugOption)element;
                String updatedValue = String.valueOf(value);
                if (value instanceof Integer) {
                    updatedValue = String.valueOf((Integer)value == 0);
                }
                if (option.getOptionPathValue().equals(updatedValue)) {
                    return;
                }
                TracingComponentDebugOption[] tracingComponentDebugOptionArray = identicalOptions = TracingCollections.getInstance().getTracingDebugOptions(option.getOptionPath());
                int n = identicalOptions.length;
                int n2 = 0;
                while (n2 < n) {
                    TracingComponentDebugOption identicalOption = tracingComponentDebugOptionArray[n2];
                    TracingCollections.getInstance().getModifiedDebugOptions().removeDebugOption(identicalOption.clone());
                    identicalOption.setOptionPathValue(updatedValue);
                    TracingCollections.getInstance().getModifiedDebugOptions().addDebugOption(identicalOption);
                    this.getViewer().update((Object)identicalOption, null);
                    ++n2;
                }
                break;
            }
        }
    }
}

