/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.callhierarchy;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.internal.corext.callhierarchy.CallHierarchyVisitor;
import org.eclipse.jdt.internal.corext.callhierarchy.IMethodWrapperDynamic;
import org.eclipse.jdt.internal.corext.callhierarchy.MethodCall;
import org.eclipse.jdt.internal.corext.callhierarchy.MethodWrapperDynamicCore;
import org.eclipse.jdt.internal.corext.callhierarchy.RealCallers;

public abstract class MethodWrapper
extends PlatformObject {
    public static IMethodWrapperDynamic fMethodWrapperCore = new MethodWrapperDynamicCore();
    private Map<String, MethodCall> fElements = null;
    private Map<String, Map<String, MethodCall>> fMethodCache;
    private final MethodCall fMethodCall;
    private final MethodWrapper fParent;
    private int fLevel;
    private int fFieldSearchMode;

    public static final void setMethodWrapperDynamic(IMethodWrapperDynamic core) {
        fMethodWrapperCore = core;
    }

    public MethodWrapper(MethodWrapper parent, MethodCall methodCall) {
        Assert.isNotNull((Object)methodCall);
        if (parent == null) {
            this.setMethodCache(new HashMap<String, Map<String, MethodCall>>());
            this.fLevel = 1;
        } else {
            this.setMethodCache(parent.getMethodCache());
            this.fLevel = parent.getLevel() + 1;
        }
        this.fMethodCall = methodCall;
        this.fParent = parent;
    }

    public <T> T getAdapter(Class<T> adapter) {
        return fMethodWrapperCore.getAdapter(this, adapter);
    }

    public MethodWrapper[] getCalls(IProgressMonitor progressMonitor) {
        if (this.fElements == null) {
            this.doFindChildren(progressMonitor);
        }
        MethodWrapper[] result = new MethodWrapper[this.fElements.size()];
        int i = 0;
        for (String string : this.fElements.keySet()) {
            MethodCall methodCall = this.getMethodCallFromMap(this.fElements, string);
            result[i++] = this.createMethodWrapper(methodCall);
        }
        return result;
    }

    public int getLevel() {
        return this.fLevel;
    }

    public IMember getMember() {
        return this.getMethodCall().getMember();
    }

    public MethodCall getMethodCall() {
        return this.fMethodCall;
    }

    public String getName() {
        if (this.getMethodCall() != null) {
            return this.getMethodCall().getMember().getElementName();
        }
        return "";
    }

    public MethodWrapper getParent() {
        return this.fParent;
    }

    public int getFieldSearchMode() {
        if (this.fFieldSearchMode != 0) {
            return this.fFieldSearchMode;
        }
        MethodWrapper parent = this.getParent();
        while (parent != null) {
            if (parent.fFieldSearchMode != 0) {
                return parent.fFieldSearchMode;
            }
            parent = parent.getParent();
        }
        return 2;
    }

    public void setFieldSearchMode(int fieldSearchMode) {
        this.fFieldSearchMode = fieldSearchMode;
    }

    public boolean equals(Object oth) {
        return fMethodWrapperCore.equals(this, oth);
    }

    public int hashCode() {
        int result = 0;
        if (this.fParent != null) {
            result = 1000003 * result + this.fParent.hashCode();
        }
        if (this.getMethodCall() != null) {
            result = 1000003 * result + this.getMethodCall().getMember().hashCode();
        }
        return result;
    }

    private void setMethodCache(Map<String, Map<String, MethodCall>> methodCache) {
        this.fMethodCache = methodCache;
    }

    protected abstract String getTaskName();

    private void addCallToCache(MethodCall methodCall) {
        Map<String, MethodCall> cachedCalls = this.lookupMethod(this.getMethodCall());
        cachedCalls.put(methodCall.getKey(), methodCall);
    }

    protected abstract MethodWrapper createMethodWrapper(MethodCall var1);

    private void doFindChildren(IProgressMonitor progressMonitor) {
        Map<String, MethodCall> existingResults = this.lookupMethod(this.getMethodCall());
        if (existingResults != null && !existingResults.isEmpty()) {
            this.fElements = new HashMap<String, MethodCall>();
            this.fElements.putAll(existingResults);
        } else {
            this.initCalls();
            if (progressMonitor != null) {
                progressMonitor.beginTask(this.getTaskName(), 100);
            }
            try {
                try {
                    this.performSearch(progressMonitor);
                }
                catch (OperationCanceledException e) {
                    this.fElements = null;
                    throw e;
                }
            }
            finally {
                if (progressMonitor != null) {
                    progressMonitor.done();
                }
            }
        }
    }

    public boolean isRecursive() {
        if (this.fParent instanceof RealCallers) {
            return false;
        }
        MethodWrapper current = this.getParent();
        while (current != null) {
            if (this.getMember().getHandleIdentifier().equals(current.getMember().getHandleIdentifier())) {
                return true;
            }
            current = current.getParent();
        }
        return false;
    }

    public abstract boolean canHaveChildren();

    protected abstract Map<String, MethodCall> findChildren(IProgressMonitor var1);

    private Map<String, Map<String, MethodCall>> getMethodCache() {
        return this.fMethodCache;
    }

    private void initCalls() {
        this.fElements = new HashMap<String, MethodCall>();
        this.initCacheForMethod();
    }

    private Map<String, MethodCall> lookupMethod(MethodCall methodCall) {
        return this.getMethodCache().get(methodCall.getKey());
    }

    private void performSearch(IProgressMonitor progressMonitor) {
        this.fElements = this.findChildren(progressMonitor);
        for (String string : this.fElements.keySet()) {
            this.checkCanceled(progressMonitor);
            MethodCall methodCall = this.getMethodCallFromMap(this.fElements, string);
            this.addCallToCache(methodCall);
        }
    }

    private MethodCall getMethodCallFromMap(Map<String, MethodCall> elements, String key) {
        return elements.get(key);
    }

    private void initCacheForMethod() {
        HashMap cachedCalls = new HashMap();
        this.getMethodCache().put(this.getMethodCall().getKey(), cachedCalls);
    }

    protected void checkCanceled(IProgressMonitor progressMonitor) {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public void accept(CallHierarchyVisitor visitor, IProgressMonitor progressMonitor) {
        if (this.getParent() != null && this.getParent().isRecursive()) {
            return;
        }
        this.checkCanceled(progressMonitor);
        visitor.preVisit(this);
        if (visitor.visit(this)) {
            MethodWrapper[] methodWrapperArray = this.getCalls(progressMonitor);
            int n = methodWrapperArray.length;
            int n2 = 0;
            while (n2 < n) {
                MethodWrapper methodWrapper = methodWrapperArray[n2];
                methodWrapper.accept(visitor, progressMonitor);
                ++n2;
            }
        }
        visitor.postVisit(this);
        if (progressMonitor != null) {
            progressMonitor.worked(1);
        }
    }

    public void removeFromCache() {
        this.fElements = null;
        this.fMethodCache.remove(this.getMethodCall().getKey());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MethodWrapper [");
        if (this.fMethodCall != null) {
            builder.append(this.fMethodCall);
        }
        if (this.fParent != null) {
            builder.append(", ");
            builder.append("parent=");
            builder.append((Object)this.fParent);
        }
        builder.append("]");
        return builder.toString();
    }
}

