/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.eclipse;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.eclipse.DiagramTextProviderInfo;
import net.sourceforge.plantuml.eclipse.DiagramTextProviderProcessor;
import net.sourceforge.plantuml.eclipse.DiagramTextProviderRegistry;
import net.sourceforge.plantuml.eclipse.utils.DiagramTextProvider;
import net.sourceforge.plantuml.eclipse.utils.ILinkOpener;
import net.sourceforge.plantuml.eclipse.utils.PlantumlUtil;
import net.sourceforge.plantuml.preferences.DiagramTextProvidersPreferencePage;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin
implements DiagramTextProviderRegistry {
    public static final String PLUGIN_ID = "net.sourceforge.plantuml.eclipse";
    private static Activator plugin;
    private IResourceChangeListener resourceListener;
    private List<DiagramTextProvider> diagramTextProviders = null;
    private Map<DiagramTextProvider, DiagramTextProviderInfo> diagramTextProviderInfo = null;
    private final Collection<DiagramTextProviderProcessor> diagramTextProviderProcessors = new ArrayList<DiagramTextProviderProcessor>();
    public static final int DEFAULT_PRIORITY = 0;
    public static final int NORMAL_PRIORITY = 5;
    public static final int CUSTOM_PRIORITY = 10;
    private final Comparator<DiagramTextProvider> priorityComparator = new Comparator<DiagramTextProvider>(){

        @Override
        public int compare(DiagramTextProvider dtp2, DiagramTextProvider dtp1) {
            return ((DiagramTextProviderInfo)((Activator)Activator.this).diagramTextProviderInfo.get((Object)dtp1)).priority - ((DiagramTextProviderInfo)((Activator)Activator.this).diagramTextProviderInfo.get((Object)dtp2)).priority;
        }
    };
    private List<ILinkOpener> linkOpeners;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.resourceListener = PlantumlUtil.createResourceListener();
        if (this.resourceListener != null) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceListener, 16);
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (this.resourceListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceListener);
        }
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public boolean isEnabled(DiagramTextProvider diagramTextProvider) {
        String id;
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        return !preferenceStore.getBoolean(DiagramTextProvidersPreferencePage.getDiagramTextProviderDisablementKey(id = this.getDiagramTextProviderId(diagramTextProvider)));
    }

    public void addDiagramTextProviderProcessor(DiagramTextProviderProcessor diagramTextProviderProcessor) {
        if (this.diagramTextProviders == null) {
            this.diagramTextProviderProcessors.add(diagramTextProviderProcessor);
        } else {
            diagramTextProviderProcessor.processDiagramTextProviders(this);
        }
    }

    public DiagramTextProvider[] getDiagramTextProviders(Boolean enabled) {
        if (this.diagramTextProviders == null) {
            this.diagramTextProviders = new ArrayList<DiagramTextProvider>();
            this.diagramTextProviderInfo = new HashMap<DiagramTextProvider, DiagramTextProviderInfo>();
            this.processDiagramTextProviders();
            for (DiagramTextProviderProcessor diagramTextProviderProcessor : this.diagramTextProviderProcessors) {
                diagramTextProviderProcessor.processDiagramTextProviders(this);
            }
        }
        List<DiagramTextProvider> diagramTextProviders = this.diagramTextProviders;
        if (enabled != null) {
            diagramTextProviders = new ArrayList<DiagramTextProvider>(diagramTextProviders);
            Iterator it = diagramTextProviders.iterator();
            while (it.hasNext()) {
                if (enabled.booleanValue() == this.isEnabled((DiagramTextProvider)it.next())) continue;
                it.remove();
            }
        }
        return diagramTextProviders.toArray(new DiagramTextProvider[diagramTextProviders.size()]);
    }

    public String getDiagramTextProviderId(DiagramTextProvider diagramTextProvider) {
        if (this.diagramTextProviderInfo != null) {
            DiagramTextProviderInfo info = this.diagramTextProviderInfo.get(diagramTextProvider);
            String id = info != null ? info.id : null;
            return id != null ? id : diagramTextProvider.getClass().getName();
        }
        return null;
    }

    public String getDiagramTextProviderLabel(DiagramTextProvider diagramTextProvider) {
        if (this.diagramTextProviderInfo != null) {
            DiagramTextProviderInfo info = this.diagramTextProviderInfo.get(diagramTextProvider);
            return info != null ? info.label : null;
        }
        return null;
    }

    private void processDiagramTextProviders() {
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(String.valueOf(this.getBundle().getSymbolicName()) + ".diagramTextProvider");
        IExtension[] extensions = ep.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] iConfigurationElementArray = extensions[i].getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement ces = iConfigurationElementArray[n2];
                String name = ces.getName();
                if ("diagramTextProvider".equals(name)) {
                    try {
                        DiagramTextProvider diagramTextProvider = (DiagramTextProvider)ces.createExecutableExtension("providerClass");
                        String priorityValue = ces.getAttribute("priority");
                        int priority = 5;
                        if ("custom".equals(priorityValue)) {
                            priority = 10;
                        } else if ("normal".equals(priorityValue)) {
                            priority = 5;
                        } else if ("default".equals(priorityValue)) {
                            priority = 0;
                        } else {
                            try {
                                priority = Integer.valueOf(priorityValue);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        DiagramTextProviderInfo info = new DiagramTextProviderInfo();
                        info.id = ces.getAttribute("id");
                        info.label = ces.getAttribute("label");
                        info.priority = priority;
                        this.registerDiagramTextProvider(diagramTextProvider, info);
                    }
                    catch (InvalidRegistryObjectException invalidRegistryObjectException) {
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
            ++i;
        }
    }

    @Override
    public void registerDiagramTextProvider(DiagramTextProvider diagramTextProvider, DiagramTextProviderInfo info) {
        this.diagramTextProviderInfo.put(diagramTextProvider, info);
        int pos = 0;
        while (pos < this.diagramTextProviders.size()) {
            if (this.priorityComparator.compare(diagramTextProvider, this.diagramTextProviders.get(pos)) < 0) break;
            ++pos;
        }
        this.diagramTextProviders.add(pos, diagramTextProvider);
    }

    public ILinkOpener[] getLinkOpeners() {
        if (this.linkOpeners == null) {
            this.linkOpeners = new ArrayList<ILinkOpener>();
            this.processLinkOpeners();
        }
        return this.linkOpeners.toArray(new ILinkOpener[this.linkOpeners.size()]);
    }

    private void processLinkOpeners() {
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(String.valueOf(this.getBundle().getSymbolicName()) + ".linkOpener");
        IExtension[] extensions = ep.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] iConfigurationElementArray = extensions[i].getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement ces = iConfigurationElementArray[n2];
                String name = ces.getName();
                if ("linkOpener".equals(name)) {
                    try {
                        ILinkOpener linkOpener = (ILinkOpener)ces.createExecutableExtension("linkOpenerClass");
                        this.linkOpeners.add(linkOpener);
                    }
                    catch (InvalidRegistryObjectException invalidRegistryObjectException) {
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
            ++i;
        }
    }
}

