/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.parameters.validation;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.comma.actions.actions.AnyEvent;
import org.eclipse.comma.actions.actions.CommandEvent;
import org.eclipse.comma.actions.actions.CommandReply;
import org.eclipse.comma.actions.actions.EventCall;
import org.eclipse.comma.actions.actions.EventPattern;
import org.eclipse.comma.actions.actions.NotificationEvent;
import org.eclipse.comma.actions.actions.SignalEvent;
import org.eclipse.comma.behavior.behavior.Clause;
import org.eclipse.comma.behavior.behavior.NonTriggeredTransition;
import org.eclipse.comma.behavior.behavior.State;
import org.eclipse.comma.behavior.behavior.StateMachine;
import org.eclipse.comma.behavior.behavior.Transition;
import org.eclipse.comma.behavior.behavior.TriggeredTransition;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.expressions.expression.Expression;
import org.eclipse.comma.expressions.expression.ExpressionAny;
import org.eclipse.comma.expressions.generator.plantuml.ExpressionsUmlGenerator;
import org.eclipse.comma.parameters.ParametersUtils;
import org.eclipse.comma.parameters.parameters.ExpressionExtended;
import org.eclipse.comma.parameters.parameters.NotificationParams;
import org.eclipse.comma.parameters.parameters.Parameters;
import org.eclipse.comma.parameters.parameters.ParametersPackage;
import org.eclipse.comma.parameters.parameters.Params;
import org.eclipse.comma.parameters.parameters.ReplyParams;
import org.eclipse.comma.parameters.parameters.Scenario;
import org.eclipse.comma.parameters.parameters.StateOtherParams;
import org.eclipse.comma.parameters.parameters.StateReplyParams;
import org.eclipse.comma.parameters.parameters.StateTransitionPair;
import org.eclipse.comma.parameters.parameters.TriggerParams;
import org.eclipse.comma.parameters.validation.AbstractParametersValidator;
import org.eclipse.comma.signature.interfaceSignature.Command;
import org.eclipse.comma.signature.interfaceSignature.DIRECTION;
import org.eclipse.comma.signature.interfaceSignature.InterfaceEvent;
import org.eclipse.comma.signature.interfaceSignature.Notification;
import org.eclipse.comma.signature.interfaceSignature.Parameter;
import org.eclipse.comma.signature.interfaceSignature.Signal;
import org.eclipse.comma.types.types.EnumTypeDecl;
import org.eclipse.comma.types.types.FileImport;
import org.eclipse.comma.types.types.SimpleTypeDecl;
import org.eclipse.comma.types.types.Type;
import org.eclipse.comma.types.types.TypeDecl;
import org.eclipse.comma.types.types.TypesPackage;
import org.eclipse.comma.types.utilities.TypeUtilities;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class ParametersValidator
extends AbstractParametersValidator {
    @Check
    public void checkImportForValidity(FileImport imp) {
        boolean _not;
        boolean _isValidUri = EcoreUtil2.isValidUri((EObject)imp, (URI)URI.createURI((String)imp.getImportURI()));
        boolean bl = _not = !_isValidUri;
        if (_not) {
            this.error("Invalid resource", (EObject)imp, (EStructuralFeature)TypesPackage.eINSTANCE.getFileImport_ImportURI());
        }
    }

    @Check
    public void checkImportFor(FileImport imp) {
        if (imp.getImportURI().contains(".params") && !StringExtensions.isNullOrEmpty((String)((Parameters)imp.eContainer()).getVariablesOnlyInstance())) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("A variable only instance shall not import another params file");
            this.error(_builder.toString(), (EObject)imp, (EStructuralFeature)TypesPackage.eINSTANCE.getFileImport_ImportURI());
        }
    }

    @Check
    public void checkDuplicateEvents(Parameters m) {
        ArrayList<String> events = new ArrayList<String>();
        EList<TriggerParams> _triggerParams = m.getTriggerParams();
        for (TriggerParams triggerParams : _triggerParams) {
            boolean _contains = events.contains(triggerParams.getEvent().getName());
            if (_contains) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("'Duplicate trigger \"");
                String _name = triggerParams.getEvent().getName();
                _builder.append(_name);
                _builder.append("\"");
                this.error(_builder.toString(), triggerParams, (EStructuralFeature)ParametersPackage.Literals.TRIGGER_PARAMS__EVENT);
            }
            events.add(triggerParams.getEvent().getName());
        }
        events.clear();
        EList<NotificationParams> _notificationParams = m.getNotificationParams();
        for (NotificationParams notificationParams : _notificationParams) {
            boolean _contains = events.contains(notificationParams.getEvent().getName());
            if (_contains) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("'Duplicate notification \"");
                String _name = notificationParams.getEvent().getName();
                _builder.append(_name);
                _builder.append("\"");
                this.error(_builder.toString(), notificationParams, (EStructuralFeature)ParametersPackage.Literals.NOTIFICATION_PARAMS__EVENT);
            }
            events.add(notificationParams.getEvent().getName());
        }
        events.clear();
        EList<ReplyParams> _replyParams = m.getReplyParams();
        for (ReplyParams replyParams : _replyParams) {
            boolean _contains = events.contains(replyParams.getEvent().getName());
            if (_contains) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("'Duplicate reply to command \"");
                String _name = replyParams.getEvent().getName();
                _builder.append(_name);
                _builder.append("\"");
                this.error(_builder.toString(), replyParams, (EStructuralFeature)ParametersPackage.Literals.REPLY_PARAMS__EVENT);
            }
            events.add(replyParams.getEvent().getName());
        }
    }

    @Check
    public void checkEvents(Parameters m) {
        boolean _tripleNotEquals;
        if (m.getInterface() == null || m.getInterface().getName() == null) {
            return;
        }
        String _variablesOnlyInstance = m.getVariablesOnlyInstance();
        boolean bl = _tripleNotEquals = _variablesOnlyInstance != null;
        if (_tripleNotEquals) {
            return;
        }
        Interface itf = m.getInterface();
        Map<State, List<InterfaceEvent>> uncoveredTriggers = ParametersUtils.getUncoveredTriggers(itf, m);
        Set<State> _keySet = uncoveredTriggers.keySet();
        for (State s : _keySet) {
            List<InterfaceEvent> _get = uncoveredTriggers.get(s);
            for (InterfaceEvent event : _get) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Trigger \"");
                String _name = event.getName();
                _builder.append(_name);
                _builder.append("\" is missing parameters for state ");
                String _name_1 = s.getName();
                _builder.append(_name_1);
                this.error(_builder.toString(), (EObject)m, null);
            }
        }
        Map<State, List<Notification>> uncoveredNotifications = ParametersUtils.getUncoveredNotifications(itf, m);
        Set<State> _keySet_1 = uncoveredNotifications.keySet();
        for (State s_1 : _keySet_1) {
            List<Notification> _get_1 = uncoveredNotifications.get(s_1);
            for (Notification event_1 : _get_1) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("Notification \"");
                String _name_2 = event_1.getName();
                _builder_1.append(_name_2);
                _builder_1.append("\" is missing parameters for state ");
                String _name_3 = s_1.getName();
                _builder_1.append(_name_3);
                this.error(_builder_1.toString(), (EObject)m, null);
            }
        }
        Map<State, List<Command>> uncoveredReplies = ParametersUtils.getUncoveredReplies(itf, m);
        Set<State> _keySet_2 = uncoveredReplies.keySet();
        for (State s_2 : _keySet_2) {
            List<Command> _get_2 = uncoveredReplies.get(s_2);
            for (Command event_2 : _get_2) {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("Reply to command \"");
                String _name_4 = event_2.getName();
                _builder_2.append(_name_4);
                _builder_2.append("\" is missing parameters for state ");
                String _name_5 = s_2.getName();
                _builder_2.append(_name_5);
                this.error(_builder_2.toString(), (EObject)m, null);
            }
        }
    }

    @Check
    public void checkIfTriggerHasParams(TriggerParams m) {
        this.checkIfEventHasParams(m.getEvent(), m.getStateParams());
    }

    @Check
    public void checkIfNotificationHasParams(NotificationParams m) {
        this.checkIfEventHasParams((InterfaceEvent)m.getEvent(), m.getStateParams());
    }

    public void checkIfEventHasParams(InterfaceEvent e, EList<StateOtherParams> stateParams) {
        for (StateOtherParams sp : stateParams) {
            int _size = sp.getParams().size();
            boolean paramsNotProvided = _size > 0;
            int _size_1 = e.getParameters().size();
            boolean hasParams = _size_1 > 0;
            boolean noSkip = StringExtensions.isNullOrEmpty((String)sp.getSkip());
            if (!noSkip || hasParams == paramsNotProvided) continue;
            if (hasParams) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Provide params for state");
                this.error(_builder.toString(), sp, null);
                continue;
            }
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Event has no params");
            this.error(_builder_1.toString(), sp, null);
        }
    }

    @Check
    public void checkIfReplyHasParams(ReplyParams m) {
        EList<StateReplyParams> _stateParams = m.getStateParams();
        for (StateReplyParams sp : _stateParams) {
            boolean hasParams;
            int _size = sp.getParams().size();
            boolean paramsNotProvided = _size > 0;
            boolean _equalsIgnoreCase = m.getEvent().getType().getType().getName().equalsIgnoreCase("void");
            boolean bl = hasParams = !_equalsIgnoreCase;
            if (hasParams == paramsNotProvided) continue;
            if (hasParams) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Provide params for state");
                this.error(_builder.toString(), sp, null);
                continue;
            }
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Event has void reply");
            this.error(_builder_1.toString(), sp, null);
        }
    }

    @Check
    public void checkStateDuplication(TriggerParams p) {
        HashSet<String> coveredStates = new HashSet<String>();
        EList<StateOtherParams> _stateParams = p.getStateParams();
        for (StateOtherParams s : _stateParams) {
            String stateName = s.getState().toString();
            Functions.Function1 _function = c -> stateName.equalsIgnoreCase((String)c);
            boolean _exists = IterableExtensions.exists(coveredStates, (Functions.Function1)_function);
            if (_exists) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("State \"");
                _builder.append(stateName);
                _builder.append("\" already used");
                this.error(_builder.toString(), s, (EStructuralFeature)ParametersPackage.Literals.STATE_PARAMS__STATE);
                continue;
            }
            coveredStates.add(stateName);
        }
    }

    @Check
    public void checkStateDuplication(NotificationParams p) {
        HashSet<String> coveredStates = new HashSet<String>();
        EList<StateOtherParams> _stateParams = p.getStateParams();
        for (StateOtherParams s : _stateParams) {
            String stateName = s.getState().toString();
            Functions.Function1 _function = c -> stateName.equalsIgnoreCase((String)c);
            boolean _exists = IterableExtensions.exists(coveredStates, (Functions.Function1)_function);
            if (_exists) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("State \"");
                _builder.append(stateName);
                _builder.append("\" already used");
                this.error(_builder.toString(), s, (EStructuralFeature)ParametersPackage.Literals.STATE_PARAMS__STATE);
                continue;
            }
            coveredStates.add(stateName);
        }
    }

    @Check
    public void checkStateDuplication(ReplyParams p) {
        HashSet<String> coveredStates = new HashSet<String>();
        EList<StateReplyParams> _stateParams = p.getStateParams();
        for (StateReplyParams s : _stateParams) {
            String stateName = s.getState().toString();
            Functions.Function1 _function = c -> stateName.equalsIgnoreCase((String)c);
            boolean _exists = IterableExtensions.exists(coveredStates, (Functions.Function1)_function);
            if (_exists) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("State \"");
                _builder.append(stateName);
                _builder.append("\" already used");
                this.error(_builder.toString(), s, (EStructuralFeature)ParametersPackage.Literals.STATE_PARAMS__STATE);
                continue;
            }
            coveredStates.add(stateName);
        }
    }

    public void checkForDuplicateValues(List<StateOtherParams> sp) {
        ExpressionsUmlGenerator uml = new ExpressionsUmlGenerator(null, null);
        for (StateOtherParams s : sp) {
            HashSet<String> seenValues = new HashSet<String>();
            EList<Params> _params = s.getParams();
            for (Params p : _params) {
                boolean _not;
                String usedValueCombination = "";
                Functions.Function1 _function = i -> {
                    Expression _exp = i.getExp();
                    return _exp != null;
                };
                Iterable _filter = IterableExtensions.filter(p.getValue(), (Functions.Function1)_function);
                for (ExpressionExtended e : _filter) {
                    String expStr = uml.generateExpression(e.getExp()).toString();
                    String _usedValueCombination = usedValueCombination;
                    usedValueCombination = String.valueOf(_usedValueCombination) + " " + expStr;
                }
                boolean _add = seenValues.add(usedValueCombination);
                boolean bl = _not = !_add;
                if (!_not) continue;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Duplicate use of value combination\"");
                _builder.append(usedValueCombination);
                _builder.append("\"");
                this.error(_builder.toString(), p, (EStructuralFeature)ParametersPackage.Literals.PARAMS__VALUE);
            }
        }
    }

    @Check
    public void checkValuesDuplication(Parameters m) {
        EList<TriggerParams> _triggerParams = m.getTriggerParams();
        for (TriggerParams s : _triggerParams) {
            this.checkForDuplicateValues((List<StateOtherParams>)s.getStateParams());
        }
        EList<NotificationParams> _notificationParams = m.getNotificationParams();
        for (NotificationParams s_1 : _notificationParams) {
            this.checkForDuplicateValues((List<StateOtherParams>)s_1.getStateParams());
        }
    }

    public void checkForAtLastOneNonSkip(List<StateOtherParams> sp) {
        for (StateOtherParams s : sp) {
            boolean seenNonSkip = false;
            boolean hasParam = false;
            EList<Params> _params = s.getParams();
            for (Params p : _params) {
                seenNonSkip = seenNonSkip || StringExtensions.isNullOrEmpty((String)p.getSkip());
                hasParam = true;
            }
            if (seenNonSkip || !hasParam) continue;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("At least one paramater should not be skipped");
            this.error(_builder.toString(), s, (EStructuralFeature)ParametersPackage.Literals.STATE_PARAMS__PARAMS);
        }
    }

    @Check
    public void checkValuesAtLastOneNonSkip(Parameters m) {
        EList<TriggerParams> _triggerParams = m.getTriggerParams();
        for (TriggerParams s : _triggerParams) {
            this.checkForAtLastOneNonSkip((List<StateOtherParams>)s.getStateParams());
        }
        EList<NotificationParams> _notificationParams = m.getNotificationParams();
        for (NotificationParams s_1 : _notificationParams) {
            this.checkForAtLastOneNonSkip((List<StateOtherParams>)s_1.getStateParams());
        }
    }

    @Check
    public void checkTriggerParams(TriggerParams triggerParams) {
        InterfaceEvent event = triggerParams.getEvent();
        EList<StateOtherParams> _stateParams = triggerParams.getStateParams();
        for (StateOtherParams paramsSet : _stateParams) {
            EList<Params> _params = paramsSet.getParams();
            for (Params params : _params) {
                int _size_1;
                boolean _notEquals;
                Functions.Function1 _function = it -> {
                    DIRECTION _direction = it.getDirection();
                    return _direction != DIRECTION.OUT;
                };
                Iterable neededParams = IterableExtensions.filter((Iterable)event.getParameters(), (Functions.Function1)_function);
                int _size = params.getValue().size();
                boolean bl = _notEquals = _size != (_size_1 = IterableExtensions.size((Iterable)neededParams));
                if (_notEquals) {
                    this.error("Wrong number of parameters", paramsSet, (EStructuralFeature)ParametersPackage.Literals.STATE_PARAMS__PARAMS);
                    continue;
                }
                Functions.Function1 _function_1 = i -> {
                    Expression _exp = i.getExp();
                    return _exp != null;
                };
                Iterable _filter = IterableExtensions.filter(params.getValue(), (Functions.Function1)_function_1);
                for (ExpressionExtended e : _filter) {
                    boolean _not;
                    boolean _subTypeOf = this.subTypeOf(this.typeOf(e.getExp()), TypeUtilities.getTypeObject((Type)((Parameter[])Conversions.unwrapArray((Object)neededParams, Parameter.class))[params.getValue().indexOf((Object)e)].getType()));
                    boolean bl2 = _not = !_subTypeOf;
                    if (!_not) continue;
                    this.error("Type mismatch for parameter", params, (EStructuralFeature)ParametersPackage.Literals.PARAMS__VALUE, params.getValue().indexOf((Object)e));
                }
            }
        }
    }

    @Check
    public void checkNotificationParams(NotificationParams notificationParams) {
        Notification event = notificationParams.getEvent();
        EList<StateOtherParams> _stateParams = notificationParams.getStateParams();
        for (StateOtherParams paramsSet : _stateParams) {
            EList<Params> _params = paramsSet.getParams();
            for (Params params : _params) {
                int _size_1;
                boolean _notEquals;
                int _size = params.getValue().size();
                boolean bl = _notEquals = _size != (_size_1 = event.getParameters().size());
                if (_notEquals) {
                    this.error("Wrong number of parameters", paramsSet, (EStructuralFeature)ParametersPackage.Literals.STATE_PARAMS__PARAMS);
                    continue;
                }
                Functions.Function1 _function = i -> {
                    Expression _exp = i.getExp();
                    return _exp != null;
                };
                Iterable _filter = IterableExtensions.filter(params.getValue(), (Functions.Function1)_function);
                for (ExpressionExtended e : _filter) {
                    boolean _not;
                    boolean _subTypeOf = this.subTypeOf(this.typeOf(e.getExp()), TypeUtilities.getTypeObject((Type)((Parameter)event.getParameters().get(params.getValue().indexOf((Object)e))).getType()));
                    boolean bl2 = _not = !_subTypeOf;
                    if (!_not) continue;
                    this.error("Type mismatch for parameter", params, (EStructuralFeature)ParametersPackage.Literals.PARAMS__VALUE, params.getValue().indexOf((Object)e));
                }
            }
        }
    }

    @Check
    public void checkReplyParams(ReplyParams replyParams) {
        boolean _not;
        Command command = replyParams.getEvent();
        ArrayList<Type> expectedTypes = new ArrayList<Type>();
        Functions.Function1 _function = it -> {
            DIRECTION _direction = it.getDirection();
            return _direction != DIRECTION.IN;
        };
        Functions.Function1 _function_1 = it -> it.getType();
        Iterables.addAll(expectedTypes, (Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)command.getParameters(), (Functions.Function1)_function), (Functions.Function1)_function_1));
        boolean _isVoid = TypeUtilities.isVoid((Type)command.getType());
        boolean bl = _not = !_isVoid;
        if (_not) {
            expectedTypes.add(command.getType());
        }
        EList<StateReplyParams> _stateParams = replyParams.getStateParams();
        for (StateReplyParams paramsSet : _stateParams) {
            EList<Params> _params = paramsSet.getParams();
            for (Params params : _params) {
                int _size_1;
                boolean _notEquals;
                int _size = params.getValue().size();
                boolean bl2 = _notEquals = _size != (_size_1 = expectedTypes.size());
                if (_notEquals) {
                    this.error("Wrong number of parameters", paramsSet, (EStructuralFeature)ParametersPackage.Literals.STATE_PARAMS__PARAMS);
                    continue;
                }
                Functions.Function1 _function_2 = i -> {
                    Expression _exp = i.getExp();
                    return _exp != null;
                };
                Iterable _filter = IterableExtensions.filter(params.getValue(), (Functions.Function1)_function_2);
                for (ExpressionExtended e : _filter) {
                    boolean _not_1;
                    boolean _subTypeOf = this.subTypeOf(this.typeOf(e.getExp()), TypeUtilities.getTypeObject((Type)((Type)expectedTypes.get(params.getValue().indexOf((Object)e)))));
                    boolean bl3 = _not_1 = !_subTypeOf;
                    if (!_not_1) continue;
                    this.error("Type mismatch for parameter", params, (EStructuralFeature)ParametersPackage.Literals.PARAMS__VALUE, params.getValue().indexOf((Object)e));
                }
            }
        }
    }

    @Check
    public void checkAny(Params par) {
        EList<ExpressionExtended> _value = par.getValue();
        for (ExpressionExtended v : _value) {
            Expression _exp = v.getExp();
            if (!(_exp instanceof ExpressionAny)) continue;
            int index = 0;
            int matchedIndex = -1;
            EList<ExpressionExtended> _value_1 = par.getValue();
            for (ExpressionExtended ev : _value_1) {
                if (ev.getExp() instanceof ExpressionAny && Objects.equal((Object)ev, (Object)v)) {
                    matchedIndex = index;
                }
                ++index;
            }
            if (matchedIndex < 0) continue;
            boolean matchIsEnum = false;
            boolean matchIsBool = false;
            InterfaceEvent evt = null;
            EObject _eContainer = par.eContainer().eContainer();
            if (_eContainer instanceof TriggerParams) {
                EObject _eContainer_1 = par.eContainer().eContainer();
                evt = ((TriggerParams)_eContainer_1).getEvent();
            } else {
                EObject _eContainer_2 = par.eContainer().eContainer();
                evt = ((ReplyParams)_eContainer_2).getEvent();
            }
            if (evt instanceof Command) {
                Command cmd = (Command)evt;
                boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)cmd.getParameters());
                if (_isNullOrEmpty) {
                    TypeDecl _type = cmd.getType().getType();
                    matchIsEnum = _type instanceof EnumTypeDecl;
                    TypeDecl _type_1 = cmd.getType().getType();
                    if (_type_1 instanceof SimpleTypeDecl) {
                        TypeDecl _type_2 = cmd.getType().getType();
                        SimpleTypeDecl st = (SimpleTypeDecl)_type_2;
                        matchIsBool = st.getName().equalsIgnoreCase("bool");
                    }
                } else {
                    TypeDecl _type_3 = ((Parameter)cmd.getParameters().get(matchedIndex)).getType().getType();
                    matchIsEnum = _type_3 instanceof EnumTypeDecl;
                    TypeDecl _type_4 = ((Parameter)cmd.getParameters().get(matchedIndex)).getType().getType();
                    if (_type_4 instanceof SimpleTypeDecl) {
                        TypeDecl _type_5 = ((Parameter)cmd.getParameters().get(matchedIndex)).getType().getType();
                        SimpleTypeDecl st_1 = (SimpleTypeDecl)_type_5;
                        matchIsBool = st_1.getName().equalsIgnoreCase("bool");
                    }
                }
            }
            if (evt instanceof Signal) {
                Signal sgl = (Signal)evt;
                TypeDecl _type_6 = ((Parameter)sgl.getParameters().get(matchedIndex)).getType().getType();
                matchIsEnum = _type_6 instanceof EnumTypeDecl;
                TypeDecl _type_7 = ((Parameter)sgl.getParameters().get(matchedIndex)).getType().getType();
                if (_type_7 instanceof SimpleTypeDecl) {
                    TypeDecl _type_8 = ((Parameter)sgl.getParameters().get(matchedIndex)).getType().getType();
                    SimpleTypeDecl st_2 = (SimpleTypeDecl)_type_8;
                    matchIsBool = st_2.getName().equalsIgnoreCase("bool");
                }
            }
            if (evt instanceof Notification) {
                Notification not = (Notification)evt;
                TypeDecl _type_9 = ((Parameter)not.getParameters().get(matchedIndex)).getType().getType();
                matchIsEnum = _type_9 instanceof EnumTypeDecl;
                TypeDecl _type_10 = ((Parameter)not.getParameters().get(matchedIndex)).getType().getType();
                if (_type_10 instanceof SimpleTypeDecl) {
                    TypeDecl _type_11 = ((Parameter)not.getParameters().get(matchedIndex)).getType().getType();
                    SimpleTypeDecl st_3 = (SimpleTypeDecl)_type_11;
                    matchIsBool = st_3.getName().equalsIgnoreCase("bool");
                }
            }
            if (matchIsEnum || matchIsBool) continue;
            this.error("* keyword is only supported for enum and bool types", par, (EStructuralFeature)ParametersPackage.Literals.PARAMS__VALUE);
        }
    }

    @Check
    public void checkScenario(Scenario scenario) {
        int size = scenario.getScenarioLists().size();
        IntegerRange _upTo = new IntegerRange(0, size - 1);
        for (Integer i : _upTo) {
            State srcState = ((StateTransitionPair)scenario.getScenarioLists().get(i.intValue())).getState();
            EventPattern event = ((StateTransitionPair)scenario.getScenarioLists().get(i.intValue())).getEvent();
            State dstState = scenario.getEndState();
            if (i < size - 1) {
                dstState = ((StateTransitionPair)scenario.getScenarioLists().get(i + 1)).getState();
            }
            EObject _eContainer = scenario.eContainer();
            EList machines = ((Parameters)_eContainer).getInterface().getMachines();
            boolean isValidTransition = false;
            for (StateMachine m : machines) {
                Functions.Function1 _function = s -> Objects.equal((Object)s, (Object)srcState);
                Iterable _filter = IterableExtensions.filter((Iterable)m.getStates(), (Functions.Function1)_function);
                for (State s2 : _filter) {
                    EList _transitions = s2.getTransitions();
                    for (Transition t : _transitions) {
                        boolean bl = isValidTransition = isValidTransition || this.checkTransition(t, event, dstState);
                    }
                }
            }
            if (!isValidTransition) continue;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Invalid transition: src state \"");
            String _name = srcState.getName();
            _builder.append(_name);
            _builder.append("\" event \"");
            String _eventName = this.getEventName(event);
            _builder.append(_eventName);
            _builder.append("\" dst state \"");
            String _name_1 = dstState.getName();
            _builder.append(_name_1);
            _builder.append("\"");
            this.error(_builder.toString(), scenario, (EStructuralFeature)ParametersPackage.Literals.SCENARIO__NAME);
        }
    }

    protected boolean _checkTransition(TriggeredTransition t, EventPattern event, State dstState) {
        InterfaceEvent _trigger = t.getTrigger();
        boolean _equals = Objects.equal((Object)_trigger, (Object)event);
        if (_equals) {
            Functions.Function1 _function = it -> {
                State _target = it.getTarget();
                return Objects.equal((Object)_target, (Object)dstState);
            };
            int _size = IterableExtensions.size((Iterable)IterableExtensions.filter((Iterable)t.getClauses(), (Functions.Function1)_function));
            return _size > 0;
        }
        return false;
    }

    protected boolean _checkTransition(NonTriggeredTransition t, EventPattern event, State dstState) {
        EList _clauses = t.getClauses();
        Iterator iterator = _clauses.iterator();
        if (iterator.hasNext()) {
            Clause c = (Clause)iterator.next();
            Functions.Function1 _function = a -> {
                InterfaceEvent _event = a.getEvent();
                return Objects.equal((Object)_event, (Object)event);
            };
            int _size = IterableExtensions.size((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)c.getActions().getActions(), EventCall.class), (Functions.Function1)_function));
            return _size > 0;
        }
        return false;
    }

    protected String _getEventName(CommandEvent event) {
        return event.getEvent().getName();
    }

    protected String _getEventName(SignalEvent event) {
        return event.getEvent().getName();
    }

    protected String _getEventName(NotificationEvent event) {
        return event.getEvent().getName();
    }

    protected String _getEventName(AnyEvent event) {
        return "";
    }

    protected String _getEventName(CommandReply event) {
        return "";
    }

    @Check
    public void checkEventPattern(EventPattern event) {
        boolean _matched = false;
        if (Objects.equal((Object)event, AnyEvent.class)) {
            _matched = true;
        }
        if (!_matched && event instanceof CommandReply) {
            _matched = true;
        }
        if (_matched) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("All events must be a command, signal or notification");
            this.error(_builder.toString(), ((CommandReply)event).eContainer().eContainer(), (EStructuralFeature)ParametersPackage.Literals.SCENARIO__NAME);
        }
    }

    public boolean checkTransition(Transition t, EventPattern event, State dstState) {
        if (t instanceof NonTriggeredTransition) {
            return this._checkTransition((NonTriggeredTransition)t, event, dstState);
        }
        if (t instanceof TriggeredTransition) {
            return this._checkTransition((TriggeredTransition)t, event, dstState);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(t, event, dstState).toString());
    }

    public String getEventName(EventPattern event) {
        if (event instanceof CommandEvent) {
            return this._getEventName((CommandEvent)event);
        }
        if (event instanceof CommandReply) {
            return this._getEventName((CommandReply)event);
        }
        if (event instanceof NotificationEvent) {
            return this._getEventName((NotificationEvent)event);
        }
        if (event instanceof SignalEvent) {
            return this._getEventName((SignalEvent)event);
        }
        if (event instanceof AnyEvent) {
            return this._getEventName((AnyEvent)event);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(event).toString());
    }
}

