/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.lib;

import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.eclipse.comma.monitoring.lib.CComponentConstraintMonitor;
import org.eclipse.comma.monitoring.lib.CComponentConstraintResult;
import org.eclipse.comma.monitoring.lib.CInterfaceMonitoringContext;
import org.eclipse.comma.monitoring.lib.CPathDescription;
import org.eclipse.comma.monitoring.lib.constraints.CDataRuleObserver;
import org.eclipse.comma.monitoring.lib.constraints.CRule;
import org.eclipse.comma.monitoring.lib.constraints.CRuleError;
import org.eclipse.comma.monitoring.lib.constraints.CRulesExecutor;
import org.eclipse.comma.monitoring.lib.constraints.CTimeRuleObserver;
import org.eclipse.comma.monitoring.lib.messages.CObservedMessage;

public class CComponentTimeDataMonitor
extends CComponentConstraintMonitor {
    private CRulesExecutor rulesRunner;
    private CInterfaceMonitoringContext context;
    private CComponentConstraintResult result;
    private CComponentConstraintResult resultPerEvent;

    public CComponentTimeDataMonitor(CInterfaceMonitoringContext context, List<CRule> rules) {
        this.context = context;
        this.rulesRunner = new CRulesExecutor(context);
        this.registerRuleObservers(rules);
        this.rulesRunner.setListOfRules(rules);
        this.result = new CComponentConstraintResult();
    }

    private void registerRuleObservers(List<CRule> rules) {
        CTimeRuleObserver observerTR = new CTimeRuleObserver(this.context.getTimeStatisticsFileName(), "time");
        CDataRuleObserver observerDR = new CDataRuleObserver(this.context.getDataStatisticsFileName(), "data");
        for (CRule r : rules) {
            r.registerObserver(observerTR);
            r.registerObserver(observerDR);
        }
    }

    @Override
    public void consume(CObservedMessage message, List<CPathDescription> pathDescriptions, String port) {
        this.resultPerEvent = new CComponentConstraintResult();
        List<CRuleError> warnings = this.rulesRunner.consumeEvent(message);
        this.result.addConstraintErrors(warnings);
        this.resultPerEvent.addConstraintErrors(warnings);
    }

    @Override
    public CComponentConstraintResult getResults() {
        return this.result;
    }

    @Override
    public void traceEnded() {
        List<CRuleError> ruleErrors = this.result.getConstraintErrors();
        int i = 0;
        while (i < ruleErrors.size()) {
            String umlRuleErrorFileName = this.context.getRuleErrorUMLFile(i);
            try {
                FileWriter umlWriter = new FileWriter(umlRuleErrorFileName, false);
                umlWriter.write(ruleErrors.get(i).toUML());
                umlWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ruleErrors.get(i).setUMLFile(umlRuleErrorFileName);
            ++i;
        }
    }

    @Override
    public CComponentConstraintResult getResultForLastEvent() {
        return this.resultPerEvent;
    }
}

