/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.util.LayoutUtil;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.TextBoxDialogField;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class JUnitLaunchIncludeExcludeTagsDialog
extends StatusDialog {
    private SelectionButtonDialogField fHasIncludeTags;
    private SelectionButtonDialogField fHasExcludeTags;
    private TextBoxDialogField fIncludeTags;
    private TextBoxDialogField fExcludeTags;
    private ILaunchConfiguration fLaunchConfiguration;
    private static final String EMPTY_STRING = "";
    IDialogFieldListener fListener = this::doDialogFieldChanged;

    public JUnitLaunchIncludeExcludeTagsDialog(Shell parent, ILaunchConfiguration config) {
        super(parent);
        this.fLaunchConfiguration = config;
        this.setTitle(JUnitMessages.JUnitLaunchConfigurationTab_addincludeexcludetagdialog_title);
        this.createIncludeTagGroup();
        this.createExcludeTagGroup();
        this.setHelpAvailable(false);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite inner = new Composite(composite, 0);
        inner.setFont(composite.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        inner.setLayout((Layout)layout);
        inner.setLayoutData((Object)new GridData(1808));
        this.fHasIncludeTags.doFillIntoGrid(inner, 1);
        this.fIncludeTags.doFillIntoGrid(inner, 2);
        LayoutUtil.setHorizontalIndent((Control)this.fIncludeTags.getLabelControl(null));
        Text includeTagControl = this.fIncludeTags.getTextControl(null);
        LayoutUtil.setHorizontalIndent((Control)includeTagControl);
        LayoutUtil.setHorizontalGrabbing((Control)includeTagControl);
        LayoutUtil.setWidthHint((Control)this.fIncludeTags.getLabelControl(null), this.convertWidthInCharsToPixels(50));
        LayoutUtil.setVerticalGrabbing((Control)includeTagControl);
        LayoutUtil.setHeightHint((Control)includeTagControl, this.convertHeightInCharsToPixels(3));
        this.fHasExcludeTags.doFillIntoGrid(inner, 1);
        this.fExcludeTags.doFillIntoGrid(inner, 2);
        LayoutUtil.setHorizontalIndent((Control)this.fExcludeTags.getLabelControl(null));
        Text excludeTagsControl = this.fExcludeTags.getTextControl(null);
        LayoutUtil.setHorizontalIndent((Control)excludeTagsControl);
        LayoutUtil.setHorizontalGrabbing((Control)excludeTagsControl);
        LayoutUtil.setWidthHint((Control)this.fExcludeTags.getLabelControl(null), this.convertWidthInCharsToPixels(50));
        LayoutUtil.setVerticalGrabbing((Control)excludeTagsControl);
        LayoutUtil.setHeightHint((Control)excludeTagsControl, this.convertHeightInCharsToPixels(3));
        JUnitLaunchIncludeExcludeTagsDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private String getCommaSeperatedText(String input) {
        if (input.isEmpty()) {
            return EMPTY_STRING;
        }
        StringBuilder buf = new StringBuilder();
        String[] strings = input.split(System.lineSeparator());
        int i = 0;
        while (i < strings.length) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(strings[i]);
            ++i;
        }
        return buf.toString();
    }

    private String getLineSeperatedText(String input) {
        if (input.isEmpty()) {
            return EMPTY_STRING;
        }
        StringBuilder buf = new StringBuilder();
        String[] strings = input.split(",");
        int i = 0;
        while (i < strings.length) {
            if (i > 0) {
                buf.append(System.lineSeparator());
            }
            buf.append(strings[i]);
            ++i;
        }
        return buf.toString();
    }

    public String getIncludeTags() {
        return this.getCommaSeperatedText(this.fIncludeTags.getText());
    }

    public String getExcludeTags() {
        return this.getCommaSeperatedText(this.fExcludeTags.getText());
    }

    public boolean hasIncludeTags() {
        return this.fHasIncludeTags.isSelected();
    }

    public boolean hasExcludeTags() {
        return this.fHasExcludeTags.isSelected();
    }

    private void createIncludeTagGroup() {
        this.fHasIncludeTags = new SelectionButtonDialogField(32);
        this.fHasIncludeTags.setDialogFieldListener(this.fListener);
        this.fHasIncludeTags.setLabelText(JUnitMessages.JUnitLaunchConfigurationTab_includetag_checkbox_label);
        this.fIncludeTags = new TextBoxDialogField();
        this.fIncludeTags.setDialogFieldListener(this.fListener);
        this.fIncludeTags.setLabelText(JUnitMessages.JUnitLaunchConfigurationTab_includetags_description);
        try {
            this.fHasIncludeTags.setSelection(this.fLaunchConfiguration.getAttribute("org.eclipse.jdt.junit.HAS_INCLUDE_TAGS", false));
        }
        catch (CoreException coreException) {}
        this.fIncludeTags.setEnabled(this.fHasIncludeTags.isSelected());
        try {
            this.fIncludeTags.setText(this.getLineSeperatedText(this.fLaunchConfiguration.getAttribute("org.eclipse.jdt.junit.INCLUDE_TAGS", EMPTY_STRING)));
        }
        catch (CoreException coreException) {}
    }

    private void createExcludeTagGroup() {
        this.fHasExcludeTags = new SelectionButtonDialogField(32);
        this.fHasExcludeTags.setDialogFieldListener(this.fListener);
        this.fHasExcludeTags.setLabelText(JUnitMessages.JUnitLaunchConfigurationTab_excludetag_checkbox_label);
        this.fExcludeTags = new TextBoxDialogField();
        this.fExcludeTags.setDialogFieldListener(this.fListener);
        this.fExcludeTags.setLabelText(JUnitMessages.JUnitLaunchConfigurationTab_excludetags_description);
        try {
            this.fHasExcludeTags.setSelection(this.fLaunchConfiguration.getAttribute("org.eclipse.jdt.junit.HAS_EXCLUDE_TAGS", false));
        }
        catch (CoreException coreException) {}
        this.fExcludeTags.setEnabled(this.fHasExcludeTags.isSelected());
        try {
            this.fExcludeTags.setText(this.getLineSeperatedText(this.fLaunchConfiguration.getAttribute("org.eclipse.jdt.junit.EXCLUDE_TAGS", EMPTY_STRING)));
        }
        catch (CoreException coreException) {}
    }

    private IStatus getValidationStatus() {
        if (this.fHasIncludeTags != null && this.fHasIncludeTags.isSelected() && this.fIncludeTags.getText().trim().equals(EMPTY_STRING)) {
            return new StatusInfo(4, JUnitMessages.JUnitLaunchConfigurationTab_includetag_empty_error);
        }
        if (this.fHasExcludeTags != null && this.fHasExcludeTags.isSelected() && this.fExcludeTags.getText().trim().equals(EMPTY_STRING)) {
            return new StatusInfo(4, JUnitMessages.JUnitLaunchConfigurationTab_excludetag_empty_error);
        }
        return new StatusInfo();
    }

    private void doDialogFieldChanged(DialogField field) {
        if (field == this.fHasIncludeTags) {
            this.fIncludeTags.setEnabled(this.fHasIncludeTags.isSelected());
        }
        if (field == this.fHasExcludeTags) {
            this.fExcludeTags.setEnabled(this.fHasExcludeTags.isSelected());
        }
        this.updateStatus(this.getValidationStatus());
    }
}

