/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.descriptions;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.access.impl.URIHelperConstants;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.impl.AbstractResourceDescription;
import org.eclipse.xtext.resource.impl.ChangedResourceDescriptionDelta;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class TypeResourceDescription
extends AbstractResourceDescription {
    private final List<IEObjectDescription> exportedObjects;
    private final URI uri;

    public TypeResourceDescription(QualifiedName typeName) {
        this.uri = URIHelperConstants.OBJECTS_URI.appendSegment(typeName.toString("."));
        ClassDescription classDescription = new ClassDescription(typeName);
        this.exportedObjects = Collections.singletonList(classDescription);
    }

    protected List<IEObjectDescription> computeExportedObjects() {
        return this.exportedObjects;
    }

    public Iterable<QualifiedName> getImportedNames() {
        return Collections.emptyList();
    }

    public Iterable<IReferenceDescription> getReferenceDescriptions() {
        return Collections.emptyList();
    }

    public URI getURI() {
        return this.uri;
    }

    public static class ClassDescription
    implements IEObjectDescription {
        private final QualifiedName qualifiedName;

        public ClassDescription(QualifiedName qualifiedName) {
            this.qualifiedName = qualifiedName;
        }

        public EClass getEClass() {
            return null;
        }

        public EObject getEObjectOrProxy() {
            throw new UnsupportedOperationException();
        }

        public URI getEObjectURI() {
            throw new UnsupportedOperationException();
        }

        public QualifiedName getName() {
            return this.qualifiedName;
        }

        public String getUserData(String key) {
            return null;
        }

        public String[] getUserDataKeys() {
            return Strings.EMPTY_ARRAY;
        }

        public int hashCode() {
            return Objects.hash(this.qualifiedName);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ClassDescription other = (ClassDescription)obj;
            return !(this.qualifiedName == null ? other.qualifiedName != null : !this.qualifiedName.equals((Object)other.qualifiedName));
        }

        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("qualifiedName", (Object)this.qualifiedName);
            return b.toString();
        }

        public QualifiedName getQualifiedName() {
            return this.qualifiedName;
        }
    }

    public static class ChangedDelta
    extends ChangedResourceDescriptionDelta {
        public ChangedDelta(QualifiedName javaTypeName) {
            super(null, (IResourceDescription)new TypeResourceDescription(javaTypeName));
        }
    }
}

