/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.tests;

import java.util.Collection;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.core.transition.common.capellaHelpers.HashMapSet;

public class TraceabilitySID {
    HashMapSet<String, EObject> sourceMap = new HashMapSet();
    HashMapSet<String, EObject> targetMap = new HashMapSet();

    public void init(Resource source, Resource target) {
        TreeIterator it = target.getAllContents();
        this.sourceMap = new HashMapSet();
        this.targetMap = new HashMapSet();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            if (!(obj instanceof ModelElement)) continue;
            String id = this.getSourceId(obj);
            EObject sourceObject = this.getEObject(source, id);
            this.sourceMap.put((Object)id, (Object)sourceObject);
            this.targetMap.put((Object)id, (Object)obj);
        }
    }

    public String getSourceId(EObject element) {
        String id = ((ModelElement)element).getSid();
        if (id == null) {
            id = ((ModelElement)element).getId();
        }
        return id;
    }

    public EObject getEObject(Resource source_p, String id_p) {
        return source_p.getEObject(id_p);
    }

    public Collection<EObject> getTracedObjects(String sourceId_p) {
        return this.targetMap.get((Object)sourceId_p);
    }

    public Collection<EObject> getSourceObjects(String sourceId_p) {
        return this.sourceMap.get((Object)sourceId_p);
    }

    public EObject getTracedObject(String sourceId_p) {
        Collection<EObject> objects = this.getTracedObjects(sourceId_p);
        if (!objects.isEmpty()) {
            return objects.iterator().next();
        }
        return null;
    }

    public EObject getTracedObject(EObject source) {
        Collection<EObject> objects = this.getTracedObjects(this.getSourceId(source));
        if (!objects.isEmpty()) {
            return objects.iterator().next();
        }
        return null;
    }

    public EObject getSourceObject(EObject target) {
        Collection<EObject> objects = this.getSourceObjects(this.getSourceId(target));
        if (!objects.isEmpty()) {
            return objects.iterator().next();
        }
        return null;
    }
}

