/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.filtering.sirius.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.core.model.helpers.query.CapellaQueries;
import org.polarsys.capella.filtering.AbstractFilteringResult;
import org.polarsys.capella.filtering.ComposedFilteringResult;
import org.polarsys.capella.filtering.FilteringCriterion;
import org.polarsys.capella.filtering.FilteringResult;
import org.polarsys.capella.filtering.FilteringResults;
import org.polarsys.capella.filtering.semantic.queries.FilteringCriterionQuery;
import org.polarsys.capella.filtering.tools.FilteringToolsPlugin;
import org.polarsys.capella.filtering.tools.utils.FilteringUtils;
import org.polarsys.capella.filtering.tools.view.GlobalFiteringCache;

public class FilteringServices {
    private static FilteringServices service = null;

    public static FilteringServices getService() {
        if (service == null) {
            service = new FilteringServices();
        }
        return service;
    }

    public Collection<Object> getAssociatedElements(FilteringCriterion filteringCriterion) {
        List queryResult = new FilteringCriterionQuery().compute((Object)filteringCriterion);
        return queryResult;
    }

    public List<FilteringCriterion> getAssociatedCriteria(EObject eObj) {
        return FilteringUtils.getAssociatedCriteria((EObject)eObj);
    }

    public Collection<AbstractFilteringResult> getAssociatedResults(ModelElement capellaElement) {
        HashSet<AbstractFilteringResult> result = new HashSet<AbstractFilteringResult>();
        FilteringResults filteringResults = FilteringUtils.getFilteringResults((EObject)capellaElement);
        SystemEngineering sysEng = CapellaQueries.getInstance().getRootQueries().getSystemEngineering(capellaElement);
        List allFilteringResults = FilteringUtils.getAllFilteringResults((FilteringResults)filteringResults);
        for (AbstractFilteringResult abstractFilteringResult : allFilteringResults) {
            Set derivation;
            if (abstractFilteringResult instanceof FilteringResult) {
                if (!this.hasAtLeastOneCriteria((EObject)capellaElement, (EList<FilteringCriterion>)((FilteringResult)abstractFilteringResult).getFilteringCriteria())) continue;
                result.add(abstractFilteringResult);
                continue;
            }
            if (!(abstractFilteringResult instanceof ComposedFilteringResult) || !(derivation = FilteringUtils.computeDerivation((AbstractFilteringResult)((ComposedFilteringResult)abstractFilteringResult), (EObject)sysEng)).contains(capellaElement)) continue;
            result.add(abstractFilteringResult);
        }
        return result;
    }

    public Collection<EObject> getAssociatedElements(AbstractFilteringResult filteringResult) {
        SystemEngineering root = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ModelElement)filteringResult);
        if (root == null) {
            return Collections.emptySet();
        }
        Set derivation = FilteringUtils.computeDerivation((AbstractFilteringResult)filteringResult, (EObject)root);
        return derivation;
    }

    private boolean hasAtLeastOneCriteria(EObject elt, EList<FilteringCriterion> criteria) {
        return !this.intersectionOf((List)this.getAssociatedCriteria(elt), (List)criteria).isEmpty();
    }

    public boolean isFilteredByGlobalFilteringCache(EObject element) {
        GlobalFiteringCache globalFilteringCache = FilteringToolsPlugin.getGlobalFilteringCache();
        if (FilteringUtils.hasAssociatedCriteria((EObject)element) && globalFilteringCache.isEnabled()) {
            Project project = CapellaProjectHelper.getProject((EObject)element);
            AbstractFilteringResult globalFilteringResult = globalFilteringCache.get(project);
            if (globalFilteringResult == null) {
                return false;
            }
            Predicate predicate = FilteringUtils.computePredicate((AbstractFilteringResult)globalFilteringResult);
            return predicate.test(element);
        }
        return true;
    }

    public boolean hasDecorationPLText(EObject view) {
        if (view instanceof DDiagramElement) {
            EObject target = ((DDiagramElement)view).getTarget();
            List f = FilteringUtils.getAssociatedCriteria((EObject)target);
            boolean hasDecoration = !f.isEmpty();
            return hasDecoration;
        }
        return false;
    }

    public Collection<FilteringCriterion> getAllFilteringCriteria(EObject modelElement) {
        List filteringModels = FilteringUtils.getFilteringModels((EObject)modelElement, (boolean)true);
        return FilteringUtils.getOwnedFilteringCriteria((Collection)filteringModels);
    }

    public Collection<AbstractFilteringResult> getAllFilteringResults(EObject modelElement) {
        FilteringResults configs = FilteringUtils.getFilteringResults((EObject)modelElement);
        return FilteringUtils.getAllFilteringResults((FilteringResults)configs);
    }

    private <T> List<T> intersectionOf(List<T> list1, List<T> list2) {
        ArrayList<T> list = new ArrayList<T>();
        for (T t : list1) {
            if (!list2.contains(t)) continue;
            list.add(t);
        }
        return list;
    }

    public Collection<AbstractFilteringResult> hasFilteringCriterion(FilteringCriterion filteringCriterion) {
        ArrayList<AbstractFilteringResult> configurations = new ArrayList<AbstractFilteringResult>();
        FilteringResults configs = FilteringUtils.getFilteringResults((EObject)filteringCriterion);
        if (configs != null) {
            for (AbstractFilteringResult config : FilteringUtils.getAllFilteringResults((FilteringResults)configs)) {
                EList filteringCriteria = config.computeFilteringCriterionSet().getFilteringCriteria();
                if (filteringCriteria == null || !filteringCriteria.contains((Object)filteringCriterion)) continue;
                configurations.add(config);
            }
        }
        return configurations;
    }

    public EObject getFilteringModel(EObject modelElement) {
        return FilteringUtils.getFilteringModel((EObject)modelElement);
    }

    public EObject getFilteringResults(EObject modelElement) {
        return FilteringUtils.getFilteringResults((EObject)modelElement);
    }

    public EObject removeFilteringCriterionFromFilteringResult(EObject context, FilteringResult config, FilteringCriterion feat) {
        if (config.getFilteringCriteria() != null) {
            config.getFilteringCriteria().remove((Object)feat);
        }
        return context;
    }

    public EObject addFilteringCriterionToResult(EObject context, FilteringResult result, FilteringCriterion criterion) {
        if (result.getFilteringCriteria() != null && !result.getFilteringCriteria().contains((Object)criterion)) {
            result.getFilteringCriteria().add((Object)criterion);
        }
        return context;
    }
}

