/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.validation.commandline;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.model.Category;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.validation.ConstraintStatusDiagnostic;
import org.polarsys.capella.core.commandline.core.AbstractCommandLine;
import org.polarsys.capella.core.commandline.core.CommandLineException;
import org.polarsys.capella.core.commandline.core.CommandLineMode;
import org.polarsys.capella.core.commandline.core.Messages;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.model.helpers.query.CapellaQueries;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;
import org.polarsys.capella.core.validation.commandline.FilteringArgumentHelper;
import org.polarsys.capella.filtering.AbstractFilteringResult;
import org.polarsys.capella.filtering.ComposedFilteringResult;
import org.polarsys.capella.filtering.FilteringCriterionSet;
import org.polarsys.capella.filtering.FilteringResult;
import org.polarsys.capella.filtering.tools.actions.ComposedFilteringExtractionJob;
import org.polarsys.capella.filtering.tools.actions.FilteringExtractionJob;
import org.polarsys.capella.filtering.tools.utils.FilteringUtils;

public class FilteringCommandLine
extends AbstractCommandLine {
    public FilteringCommandLine() {
        argHelper = new FilteringArgumentHelper();
    }

    public void checkArgs(IApplicationContext context) throws CommandLineException {
        try {
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException exception) {
            this.logErrorAndThrowException(Messages.refresh_problem);
        }
        if (this.isEmtyOrNull(argHelper.getFilePath())) {
            this.logErrorAndThrowException(Messages.representation_mandatory);
        }
        if (this.isEmtyOrNull(argHelper.getImportProjects())) {
            this.setMode(CommandLineMode.NO_IMPORT);
            this.checkFilePath();
        } else if (!this.isEmtyOrNull(argHelper.getImportProjects())) {
            this.setMode(CommandLineMode.IMPORT);
        }
    }

    private void checkFilePath() throws CommandLineException {
        String projectName = FilteringCommandLine.getProjectName((String)argHelper.getFilePath());
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!project.exists()) {
            this.logErrorAndThrowException(String.valueOf(Messages.project) + projectName + Messages.not_exist);
        }
        try {
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException exception) {
            StringBuilder loggerMessage = new StringBuilder(String.valueOf(Messages.unable_open_project) + project.getName());
            logger.warn((Object)loggerMessage.toString(), (Throwable)exception);
        }
        IFile file = project.getFile(FilteringCommandLine.getRelativeFilePath((String)argHelper.getFilePath()));
        if (!file.exists()) {
            String message = String.valueOf(Messages.aird) + argHelper.getFilePath() + Messages.not_exist;
            this.logErrorAndThrowException(message);
        }
    }

    public void printHelp() {
        this.logInfo("Capella Filtering Command Line Derivator");
        super.printHelp();
    }

    public boolean execute(IApplicationContext context) throws CommandLineException {
        FilteringCommandLine.startFakeWorkbench();
        String fileURI = String.valueOf(Messages.resource_prefix) + argHelper.getFilePath();
        URI uri = URI.createURI((String)fileURI);
        String outputFolder = argHelper.getOutputFolder();
        String filteringResultId = ((FilteringArgumentHelper)argHelper).getFilteringResultId();
        if (this.isEmtyOrNull(filteringResultId)) {
            this.logErrorAndThrowException("Filtering result id is null or empty!");
        }
        boolean status = false;
        try {
            status = this.execute(uri, filteringResultId, outputFolder);
        }
        catch (FileNotFoundException | InterruptedException | CoreException | OperationCanceledException exception) {
            this.logErrorAndThrowException(exception.getMessage());
        }
        if (status) {
            this.logInfo("Filtering Derivation generated to:  " + argHelper.getOutputFolder());
        }
        return false;
    }

    private boolean execute(URI uri, String filteringResultId, String outputFolder) throws FileNotFoundException, CoreException, CommandLineException, OperationCanceledException, InterruptedException {
        ModelElement element;
        Project semanticRootElement = this.loadSemanticRootElement(uri);
        IProject currentProject = FilteringUtils.getEclipseProject((EObject)semanticRootElement);
        if (semanticRootElement == null) {
            this.logErrorAndThrowException("No semantic model found!");
        }
        if (!((element = CapellaQueries.getInstance().getGetElementsQueries().getElementById(semanticRootElement, filteringResultId)) instanceof AbstractFilteringResult)) {
            this.logErrorAndThrowException("Id does not reference a Filtering Result!");
        }
        AbstractFilteringResult filteringResult = (AbstractFilteringResult)element;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String derivedProjectName = filteringResult.getName();
        int i = 2;
        while (FilteringUtils.projectExists((String)derivedProjectName)) {
            this.logInfo("a project with name: " + derivedProjectName + " already exists");
            derivedProjectName = String.valueOf(filteringResult.getName()) + "_" + i;
            ++i;
        }
        IProject derivedProject = workspace.getRoot().getProject(derivedProjectName);
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        derivedProject.create((IProgressMonitor)progressMonitor);
        derivedProject.open((IProgressMonitor)progressMonitor);
        FilteringCriterionSet computedFilteringCriterionSet = filteringResult.computeFilteringCriterionSet();
        ComposedFilteringExtractionJob job = null;
        if (filteringResult instanceof ComposedFilteringResult) {
            job = new ComposedFilteringExtractionJob(currentProject, derivedProject, (List)computedFilteringCriterionSet.getFilteringCriteria(), filteringResult, null);
        } else if (filteringResult instanceof FilteringResult) {
            job = new FilteringExtractionJob(currentProject, derivedProject, (List)computedFilteringCriterionSet.getFilteringCriteria(), filteringResult, null);
        }
        workspace.run(job, (IProgressMonitor)progressMonitor);
        Session session = SessionManager.INSTANCE.getSession(uri, (IProgressMonitor)new NullProgressMonitor());
        session.close((IProgressMonitor)progressMonitor);
        return true;
    }

    public static void ensureEMFValidationActivation() {
        ModelValidationService.getInstance().loadXmlConstraintDeclarations();
    }

    private List<EObject> loadEObjects(Project project, List<String> uris) throws CoreException {
        ArrayList<EObject> results = new ArrayList<EObject>();
        for (String uriFragment : uris) {
            String idSegment = this.getIdSegment(uriFragment);
            ModelElement element = CapellaQueries.getInstance().getGetElementsQueries().getElementById(project, idSegment);
            results.add((EObject)element);
        }
        return results;
    }

    private String getIdSegment(String uriFragment) {
        URI uri = URI.createURI((String)uriFragment);
        return uri.fragment();
    }

    private Project loadSemanticRootElement(URI uri) {
        SessionManager sessionManager = SessionManager.INSTANCE;
        Session session = sessionManager.getSession(uri, (IProgressMonitor)new NullProgressMonitor());
        if (!session.isOpen()) {
            session.open((IProgressMonitor)new NullProgressMonitor());
        }
        return SessionHelper.getCapellaProject((Session)session);
    }

    public static void startFakeWorkbench() {
        if (PlatformUI.isWorkbenchRunning()) {
            return;
        }
        Display display = PlatformUI.createDisplay();
        PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new WorkbenchAdvisor(){

            public boolean openWindows() {
                return false;
            }

            public String getInitialWindowPerspectiveId() {
                return null;
            }
        });
    }

    private String getSeverityLabel(Integer severity) {
        switch (severity) {
            case 2: {
                return "Error";
            }
            case 1: {
                return "Warning";
            }
            case 0: {
                return "Info";
            }
        }
        return "";
    }

    private String getCategory(IMarker iMarker) throws CoreException {
        Set cats;
        String result = "";
        Diagnostic diagnostic = (Diagnostic)iMarker.getAdapter(Diagnostic.class);
        if (diagnostic instanceof ConstraintStatusDiagnostic && !(cats = ((ConstraintStatusDiagnostic)diagnostic).getConstraintStatus().getConstraint().getDescriptor().getCategories()).isEmpty()) {
            result = ((Category)cats.iterator().next()).getQualifiedName();
        }
        return result;
    }
}

