/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.filtering.tools.decorators;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.sirius.ui.business.api.descriptor.ComposedImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.filtering.tools.FilteringToolsPlugin;
import org.polarsys.capella.filtering.tools.utils.FilteringUtils;

public class CriteriaLabelDecorator
implements ILabelDecorator {
    public static final ImageDescriptor FILTERING_OVERLAY_DESC = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.polarsys.capella.filtering.tools", (String)"icons/ovr_optional.png");

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image decorateImage(Image image, Object element) {
        if (image == null) {
            return null;
        }
        if (element instanceof CapellaElement && this.isOptional((CapellaElement)element)) {
            ComposedImage img = this.decorateFiltering(image);
            ComposedImageDescriptor descriptor = new ComposedImageDescriptor(img);
            return FilteringToolsPlugin.getDefault().getImage((ImageDescriptor)descriptor);
        }
        return null;
    }

    private ComposedImage decorateFiltering(Image image) {
        ArrayList<Image> images = new ArrayList<Image>(2);
        images.add(image);
        images.add(FilteringToolsPlugin.getDefault().getImage(FILTERING_OVERLAY_DESC));
        return new ComposedImage(images){

            public List<ComposedImage.Point> getDrawPoints(ComposedImage.Size size) {
                ArrayList<ComposedImage.Point> results = new ArrayList<ComposedImage.Point>();
                results.add(new ComposedImage.Point());
                ComposedImage.Point overlay = new ComposedImage.Point();
                overlay.x = 0;
                overlay.y = 7;
                results.add(overlay);
                return results;
            }
        };
    }

    public String decorateText(String text, Object element) {
        String decorator;
        if (element instanceof CapellaElement && this.isOptional((CapellaElement)element) && (decorator = FilteringUtils.getCommaSeparatedExplicitFeatures((EObject)((CapellaElement)element))) != null) {
            return String.valueOf(text) + " [" + decorator + "]";
        }
        return text;
    }

    private boolean isOptional(CapellaElement element) {
        return !FilteringUtils.getExplicitAssociatedCriteria((EObject)element).isEmpty();
    }
}

