/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.formatter;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.css.core.internal.CSSCorePlugin;
import org.eclipse.wst.css.core.internal.cleanup.CSSCleanupStrategy;
import org.eclipse.wst.css.core.internal.formatter.AbstractCSSSourceFormatter;
import org.eclipse.wst.css.core.internal.formatter.AttrChangeContext;
import org.eclipse.wst.css.core.internal.formatter.CompoundRegion;
import org.eclipse.wst.css.core.internal.formatter.FormatRegion;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSAttr;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSImportRule;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.util.CSSUtil;
import org.eclipse.wst.css.core.internal.util.RegionIterator;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.w3c.dom.stylesheets.MediaList;

public class ImportRuleFormatter
extends AbstractCSSSourceFormatter {
    public static final String IMPORT = "@import";
    private static ImportRuleFormatter instance;

    ImportRuleFormatter() {
    }

    @Override
    public StringBuffer formatAttrChanged(ICSSNode node, ICSSAttr attr, boolean insert, AttrChangeContext context) {
        StringBuffer buf = new StringBuffer();
        if (node == null || attr == null) {
            return buf;
        }
        if (!"href".equalsIgnoreCase(attr.getName())) {
            return buf;
        }
        if (context != null && ((IndexedRegion)node).getEndOffset() > 0) {
            if (attr != null && ((IndexedRegion)attr).getEndOffset() > 0) {
                ITextRegion next;
                IStructuredDocumentRegion flatNode = node.getOwnerDocument().getModel().getStructuredDocument().getRegionAtCharacterOffset(((IndexedRegion)attr).getStartOffset());
                ITextRegion region = flatNode.getRegionAtCharacterOffset(((IndexedRegion)attr).getStartOffset());
                RegionIterator it = new RegionIterator(flatNode, region);
                it.prev();
                if (it.hasPrev()) {
                    ITextRegion prev = it.prev();
                    context.start = prev.getType() == "S" ? it.getStructuredDocumentRegion().getStartOffset(prev) : it.getStructuredDocumentRegion().getStartOffset(region);
                    it.next();
                } else {
                    context.start = it.getStructuredDocumentRegion().getStartOffset(region);
                }
                it.next();
                it.next();
                context.end = it.hasNext() ? ((next = it.next()).getType() == "S" ? it.getStructuredDocumentRegion().getEndOffset(next) : it.getStructuredDocumentRegion().getEndOffset(region)) : it.getStructuredDocumentRegion().getEndOffset(region);
            } else {
                ICSSNode child = node.getFirstChild();
                IStructuredDocumentRegion flatNode = null;
                ITextRegion region = null;
                if (child == null) {
                    flatNode = node.getOwnerDocument().getModel().getStructuredDocument().getRegionAtCharacterOffset(((IndexedRegion)node).getEndOffset() - 1);
                    region = flatNode.getRegionAtCharacterOffset(((IndexedRegion)node).getEndOffset() - 1);
                } else {
                    flatNode = node.getOwnerDocument().getModel().getStructuredDocument().getRegionAtCharacterOffset(((IndexedRegion)child).getStartOffset() - 1);
                    region = flatNode.getRegionAtCharacterOffset(((IndexedRegion)child).getStartOffset() - 1);
                }
                if (region.getType() == "S") {
                    context.start = flatNode.getStartOffset(region);
                    context.end = flatNode.getEndOffset(region);
                } else {
                    context.start = flatNode.getEndOffset();
                    context.end = flatNode.getEndOffset();
                }
            }
        }
        if (insert && attr.getValue() != null && attr.getValue().length() > 0) {
            this.appendSpaceBefore(node, attr.getValue(), buf);
            buf.append(attr.getValue());
            this.appendSpaceBefore(node, "", buf);
        }
        return buf;
    }

    @Override
    protected void formatBefore(ICSSNode node, ICSSNode child, String toAppend, StringBuffer source, IRegion exceptFor) {
        int end;
        ICSSNode prev = child != null ? child.getPreviousSibling() : node.getLastChild();
        int start = prev != null ? ((IndexedRegion)prev).getEndOffset() : 0;
        int n = end = child != null ? ((IndexedRegion)child).getStartOffset() : 0;
        if (start > 0 && start < end) {
            CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
            IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
            CompoundRegion[] regions = null;
            if (exceptFor == null) {
                regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, new FormatRegion(start, end - start), stgy);
            } else {
                String pickupType = "MEDIA_SEPARATOR";
                if (prev == null || child == null) {
                    pickupType = null;
                }
                regions = this.getRegions(structuredDocument, new FormatRegion(start, end - start), exceptFor, pickupType);
            }
            int i = 0;
            while (i < regions.length) {
                this.appendSpaceBefore(node, regions[i], source);
                source.append(this.decoratedRegion(regions[i], 0, stgy));
                ++i;
            }
            this.appendSpaceBefore(node, toAppend, source);
        } else if (prev != null && child != null) {
            source.append(",");
            this.appendSpaceBefore(node, toAppend, source);
        } else if (child != null) {
            this.appendSpaceBefore(node, toAppend, source);
        }
    }

    @Override
    protected void formatBefore(ICSSNode node, ICSSNode child, IRegion region, String toAppend, StringBuffer source) {
        CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
        IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
        CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, region, stgy);
        CompoundRegion[] outside = this.getOutsideRegions(structuredDocument, region);
        int i = 0;
        while (i < regions.length) {
            if (i != 0 || ImportRuleFormatter.needS(outside[0])) {
                this.appendSpaceBefore(node, regions[i], source);
            }
            source.append(this.decoratedRegion(regions[i], 0, stgy));
            ++i;
        }
        if (ImportRuleFormatter.needS(outside[1])) {
            if (((IndexedRegion)child).getStartOffset() == region.getOffset() + region.getLength()) {
                this.appendSpaceBefore(node, toAppend, source);
            } else {
                this.appendSpaceBefore(node, outside[1], source);
            }
        }
    }

    @Override
    protected void formatPost(ICSSNode node, StringBuffer source) {
        int start;
        CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
        int end = ((IndexedRegion)node).getEndOffset();
        int n = start = node.getLastChild() != null && ((IndexedRegion)node.getLastChild()).getEndOffset() > 0 ? ((IndexedRegion)node.getLastChild()).getEndOffset() : this.getChildInsertPos(node);
        if (end > 0 && start < end) {
            IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
            CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, new FormatRegion(start, end - start), stgy);
            int i = 0;
            while (i < regions.length) {
                this.appendDelimBefore(node, regions[i], source);
                source.append(this.decoratedRegion(regions[i], 0, stgy));
                ++i;
            }
        } else {
            source.append(";");
        }
    }

    @Override
    protected void formatPost(ICSSNode node, IRegion region, StringBuffer source) {
        CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
        IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
        CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, region, stgy);
        CompoundRegion[] outside = this.getOutsideRegions(structuredDocument, region);
        int i = 0;
        while (i < regions.length) {
            if ((i != 0 || ImportRuleFormatter.needS(outside[0])) && !regions[i].getType().equals("DELIMITER")) {
                this.appendDelimBefore(node, regions[i], source);
            }
            source.append(this.decoratedRegion(regions[i], 0, stgy));
            ++i;
        }
    }

    @Override
    protected void formatPre(ICSSNode node, StringBuffer source) {
        int end;
        int start = ((IndexedRegion)node).getStartOffset();
        int n = end = node.getFirstChild() != null && ((IndexedRegion)node.getFirstChild()).getEndOffset() > 0 ? ((IndexedRegion)node.getFirstChild()).getStartOffset() : this.getChildInsertPos(node);
        if (end > 0) {
            CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
            IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
            CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, new FormatRegion(start, end - start), stgy);
            int i = 0;
            while (i < regions.length) {
                String str = regions[i].getText();
                str = regions[i].getType() == "IMPORT" ? this.decoratedIdentRegion(regions[i], stgy) : this.decoratedPropValueRegion(regions[i], stgy);
                if (i != 0) {
                    this.appendSpaceBefore(node, regions[i], source);
                }
                source.append(str);
                ++i;
            }
        } else {
            Preferences preferences = CSSCorePlugin.getDefault().getPluginPreferences();
            Object str = IMPORT;
            if (preferences.getInt("identifierCase") == 2) {
                str = IMPORT.toUpperCase();
            }
            String quote = preferences.getString("quote");
            source.append((String)str);
            str = "url(";
            if (preferences.getInt("propValueCase") == 2) {
                str = ((String)str).toUpperCase();
            }
            String href = ((ICSSImportRule)node).getHref();
            quote = CSSUtil.detectQuote(href, quote);
            str = (String)str + quote + href + quote + ")";
            this.appendSpaceBefore(node, (String)str, source);
            source.append((String)str);
        }
        ICSSNode child = node.getFirstChild();
        if (child != null && child instanceof MediaList && ((MediaList)((Object)child)).getLength() > 0) {
            this.appendSpaceBefore(node, "", source);
        }
    }

    @Override
    protected void formatPre(ICSSNode node, IRegion region, StringBuffer source) {
        CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
        IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
        CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, region, stgy);
        CompoundRegion[] outside = this.getOutsideRegions(structuredDocument, region);
        int i = 0;
        while (i < regions.length) {
            String str = regions[i].getText();
            str = regions[i].getType() == "IMPORT" ? this.decoratedIdentRegion(regions[i], stgy) : this.decoratedPropValueRegion(regions[i], stgy);
            if (i != 0 || ImportRuleFormatter.needS(outside[0])) {
                this.appendSpaceBefore(node, regions[i], source);
            }
            source.append(str);
            ++i;
        }
        if (ImportRuleFormatter.needS(outside[1]) && !this.isIncludesPreEnd(node, region)) {
            this.appendSpaceBefore(node, outside[1], source);
        }
    }

    @Override
    public int getAttrInsertPos(ICSSNode node, String attrName) {
        if (node == null || attrName == null || attrName.length() == 0) {
            return -1;
        }
        if (!"href".equalsIgnoreCase(attrName)) {
            return -1;
        }
        ICSSAttr attr = (ICSSAttr)node.getAttributes().getNamedItem("href");
        if (attr != null && ((IndexedRegion)attr).getEndOffset() > 0) {
            return ((IndexedRegion)attr).getStartOffset();
        }
        IndexedRegion iNode = (IndexedRegion)node;
        if (iNode.getEndOffset() <= 0) {
            return -1;
        }
        FormatRegion formatRegion = null;
        ICSSNode child = node.getFirstChild();
        formatRegion = child != null && ((IndexedRegion)child).getEndOffset() > 0 ? new FormatRegion(iNode.getStartOffset(), ((IndexedRegion)child).getStartOffset() - iNode.getStartOffset()) : new FormatRegion(iNode.getStartOffset(), iNode.getEndOffset() - iNode.getStartOffset());
        CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(node.getOwnerDocument().getModel().getStructuredDocument(), formatRegion, this.getCleanupStrategy(node));
        boolean atrule = false;
        int i = 0;
        while (i < regions.length) {
            if (regions[i].getType() == "IMPORT") {
                atrule = true;
            } else if (atrule && regions[i].getType() != "COMMENT") {
                return regions[i].getStartOffset();
            }
            ++i;
        }
        return child != null && ((IndexedRegion)child).getEndOffset() > 0 ? ((IndexedRegion)child).getStartOffset() : iNode.getEndOffset();
    }

    @Override
    public int getChildInsertPos(ICSSNode node) {
        int n = ((IndexedRegion)node).getEndOffset();
        if (n > 0) {
            IStructuredDocumentRegion flatNode = node.getOwnerDocument().getModel().getStructuredDocument().getRegionAtCharacterOffset(n - 1);
            if (flatNode.getRegionAtCharacterOffset(n - 1).getType() == "DELIMITER") {
                return n - 1;
            }
            return n;
        }
        return -1;
    }

    public static synchronized ImportRuleFormatter getInstance() {
        if (instance == null) {
            instance = new ImportRuleFormatter();
        }
        return instance;
    }
}

