/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.team.core.DefaultRepositoryProviderType;
import org.eclipse.team.core.IProjectSetSerializer;
import org.eclipse.team.core.ProjectSetCapability;
import org.eclipse.team.core.Team;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.internal.core.DefaultProjectSetCapability;
import org.eclipse.team.internal.core.TeamPlugin;

public abstract class RepositoryProviderType
extends PlatformObject {
    private static Map<String, RepositoryProviderType> allProviderTypes = new HashMap<String, RepositoryProviderType>();
    private String id;
    private String scheme;

    public static RepositoryProviderType getProviderType(String id) {
        RepositoryProviderType type = allProviderTypes.get(id);
        if (type != null) {
            return type;
        }
        return RepositoryProviderType.newProviderType(id);
    }

    public static RepositoryProviderType getTypeForScheme(String scheme) {
        for (RepositoryProviderType type : allProviderTypes.values()) {
            if (type.getFileSystemScheme() == null || !type.getFileSystemScheme().equals(scheme)) continue;
            return type;
        }
        return RepositoryProviderType.findProviderForScheme(scheme);
    }

    private static RepositoryProviderType findProviderForScheme(String scheme) {
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.team.core", "repository");
        if (extension != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = extension.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = ext.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configElement = iConfigurationElementArray[n4];
                    String extensionId = configElement.getAttribute("id");
                    String typeScheme = configElement.getAttribute("fileSystemScheme");
                    if (typeScheme != null && typeScheme.equals(scheme) && extensionId != null) {
                        return RepositoryProviderType.newProviderType(extensionId);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return null;
    }

    private void setID(String id) {
        this.id = id;
    }

    private static RepositoryProviderType newProviderType(String id) {
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.team.core", "repository");
        if (extension != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = extension.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = ext.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configElement = iConfigurationElementArray[n4];
                    String extensionId = configElement.getAttribute("id");
                    if (extensionId != null && extensionId.equals(id)) {
                        try {
                            RepositoryProviderType providerType = configElement.getAttribute("typeClass") == null ? new DefaultRepositoryProviderType() : (RepositoryProviderType)((Object)configElement.createExecutableExtension("typeClass"));
                            providerType.setID(id);
                            allProviderTypes.put(id, providerType);
                            String scheme = configElement.getAttribute("fileSystemScheme");
                            providerType.setFileSystemScheme(scheme);
                            return providerType;
                        }
                        catch (CoreException e) {
                            TeamPlugin.log(e);
                        }
                        catch (ClassCastException e) {
                            String className = configElement.getAttribute("typeClass");
                            TeamPlugin.log(4, "Class " + className + " registered for repository provider type id " + id + " is not a subclass of RepositoryProviderType", e);
                        }
                        return null;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return null;
    }

    private void setFileSystemScheme(String scheme) {
        this.scheme = scheme;
    }

    public final String getID() {
        return this.id;
    }

    public ProjectSetCapability getProjectSetCapability() {
        IProjectSetSerializer oldSerializer = Team.getProjectSetSerializer(this.getID());
        if (oldSerializer != null) {
            DefaultProjectSetCapability capability = new DefaultProjectSetCapability();
            capability.setSerializer(oldSerializer);
            return capability;
        }
        return null;
    }

    public void metaFilesDetected(IProject project, IContainer[] containers) {
    }

    public Subscriber getSubscriber() {
        return null;
    }

    public final String getFileSystemScheme() {
        return this.scheme;
    }
}

