/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.java.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.search.IJavaSearchScope;

public class JSPSearchScope
implements IJavaSearchScope {
    private boolean fEnclosesAll = false;
    private List fResourcePaths = null;
    private List fJavaElements = null;

    public JSPSearchScope() {
        this.fEnclosesAll = true;
        this.init();
    }

    public JSPSearchScope(String[] resourceStringPath) {
        this.init();
        this.fResourcePaths.addAll(Arrays.asList(resourceStringPath));
    }

    public JSPSearchScope(IJavaElement[] javaElement) {
        this.init();
        this.fJavaElements.addAll(Arrays.asList(javaElement));
    }

    private void init() {
        this.fResourcePaths = new ArrayList();
        this.fJavaElements = new ArrayList();
    }

    public boolean encloses(String resourcePathString) {
        if (this.fEnclosesAll) {
            return true;
        }
        return this.enclosesPath(resourcePathString);
    }

    public boolean encloses(IJavaElement element) {
        if (this.fEnclosesAll) {
            return true;
        }
        return true;
    }

    public boolean encloses(IResourceProxy element) {
        if (this.fEnclosesAll) {
            return true;
        }
        if (this.enclosesPath(element.requestFullPath().toOSString())) {
            return true;
        }
        return true;
    }

    public void addPath(String path) {
        this.fResourcePaths.add(path);
    }

    public void addElement(IJavaElement element) {
        this.fJavaElements.add(element);
    }

    private boolean enclosesPath(String possible) {
        String[] paths = this.fResourcePaths.toArray(new String[this.fResourcePaths.size()]);
        int i = 0;
        while (i < paths.length) {
            if (possible.equals(paths[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getDescription() {
        return "JSPSearchScope";
    }

    public IPath[] enclosingProjectsAndJars() {
        return this.fResourcePaths.toArray(new IPath[this.fResourcePaths.size()]);
    }

    public boolean includesBinaries() {
        return false;
    }

    public boolean includesClasspaths() {
        return false;
    }

    public void setIncludesBinaries(boolean includesBinaries) {
    }

    public void setIncludesClasspaths(boolean includesClasspaths) {
    }
}

