/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.validators;

import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.validators.IValidationListener;
import org.eclipse.birt.report.model.api.validators.ValueRequiredValidator;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.validators.ValidatorTestCase;

public class ValueRequiredValidatorTest
extends ValidatorTestCase {
    ValidatorTestCase.MyListener listener = new ValidatorTestCase.MyListener();

    public void testTriggers() throws Exception {
        this.createDesign();
        MetaDataDictionary.getInstance().setUseValidationTrigger(true);
        OdaDataSetHandle dataSetHandle = this.designHandle.getElementFactory().newOdaDataSet("dataset1");
        this.designHandle.addValidationListener((IValidationListener)this.listener);
        this.designHandle.getDataSets().add((DesignElementHandle)dataSetHandle);
        ValueRequiredValidatorTest.assertTrue((boolean)this.listener.hasError((DesignElementHandle)dataSetHandle, ValueRequiredValidator.getInstance().getName(), "dataSource", "Error.PropertyValueException.VALUE_REQUIRED"));
        OdaDataSourceHandle dataSourceHandle = this.designHandle.getElementFactory().newOdaDataSource("dataSource1");
        this.designHandle.getDataSources().add((DesignElementHandle)dataSourceHandle);
        dataSetHandle.setDataSource(dataSourceHandle.getName());
        ValueRequiredValidatorTest.assertFalse((boolean)this.listener.hasError((DesignElementHandle)dataSetHandle, ValueRequiredValidator.getInstance().getName(), "dataSource", "Error.PropertyValueException.VALUE_REQUIRED"));
        dataSetHandle.setDataSource(null);
        ValueRequiredValidatorTest.assertTrue((boolean)this.listener.hasError((DesignElementHandle)dataSetHandle, ValueRequiredValidator.getInstance().getName(), "dataSource", "Error.PropertyValueException.VALUE_REQUIRED"));
    }
}

