/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import java.util.ArrayList;
import org.eclipse.birt.report.model.api.elements.structures.ConfigVariable;
import org.eclipse.birt.report.model.api.elements.structures.HideRule;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class StructureEqualsTest
extends BaseTestCase {
    public void testSingleStructure() {
        String expr = "true";
        HideRule rule = this.createHideRule("all", expr);
        StructureEqualsTest.assertTrue((boolean)rule.equals((Object)rule));
        StructureEqualsTest.assertTrue((boolean)rule.equals((Object)rule.copy()));
        StructureEqualsTest.assertFalse((boolean)rule.equals((Object)new ConfigVariable()));
        StructureEqualsTest.assertFalse((boolean)rule.equals(null));
        HideRule ruleOne = this.createHideRule("excel", expr);
        StructureEqualsTest.assertFalse((boolean)rule.equals((Object)ruleOne));
        ruleOne.setFormat("all");
        StructureEqualsTest.assertTrue((boolean)rule.equals((Object)ruleOne));
        StructureEqualsTest.assertTrue((boolean)ruleOne.equals((Object)rule));
    }

    public void testStructureList() {
        String expr = "true";
        ArrayList<HideRule> rules = new ArrayList<HideRule>();
        ArrayList<HideRule> ruleOnes = new ArrayList<HideRule>();
        StructureEqualsTest.assertTrue((boolean)rules.equals(ruleOnes));
        rules.add(this.createHideRule("all", expr));
        StructureEqualsTest.assertFalse((boolean)rules.equals(ruleOnes));
        StructureEqualsTest.assertFalse((boolean)ruleOnes.equals(rules));
        ruleOnes.add(this.createHideRule("all", expr));
        StructureEqualsTest.assertTrue((boolean)rules.equals(ruleOnes));
        StructureEqualsTest.assertTrue((boolean)ruleOnes.equals(rules));
        rules.add(this.createHideRule("email", expr));
        ruleOnes.add(this.createHideRule("all", expr));
        StructureEqualsTest.assertFalse((boolean)rules.equals(ruleOnes));
        StructureEqualsTest.assertFalse((boolean)ruleOnes.equals(rules));
        ((HideRule)ruleOnes.get(1)).setFormat("email");
        StructureEqualsTest.assertTrue((boolean)rules.equals(ruleOnes));
        StructureEqualsTest.assertTrue((boolean)ruleOnes.equals(rules));
        rules.add(this.createHideRule("excel", expr));
        ruleOnes.add(this.createHideRule("all", expr));
        StructureEqualsTest.assertFalse((boolean)rules.equals(ruleOnes));
        StructureEqualsTest.assertFalse((boolean)ruleOnes.equals(rules));
        ((HideRule)ruleOnes.get(2)).setFormat("excel");
        StructureEqualsTest.assertTrue((boolean)rules.equals(ruleOnes));
        StructureEqualsTest.assertTrue((boolean)ruleOnes.equals(rules));
    }

    private HideRule createHideRule(String format, String expr) {
        HideRule rule = new HideRule();
        rule.setFormat(format);
        rule.setExpression(expr);
        return rule;
    }
}

