/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import junit.framework.TestCase;
import org.eclipse.birt.report.model.api.util.StringUtil;

public class StringUtilTest
extends TestCase {
    public void testTrimString() {
        StringUtilTest.assertNull((Object)StringUtil.trimString(null));
        StringUtilTest.assertNull((Object)StringUtil.trimString((String)""));
        StringUtilTest.assertNull((Object)StringUtil.trimString((String)"   "));
        StringUtilTest.assertNull((Object)StringUtil.trimString((String)"\t"));
        StringUtilTest.assertEquals((String)"abc d ef", (String)StringUtil.trimString((String)"\tabc d ef  "));
    }

    public void testToRgbText() {
        StringUtilTest.assertEquals((String)"#000000", (String)StringUtil.toRgbText((int)0));
        StringUtilTest.assertEquals((String)"#00ff00", (String)StringUtil.toRgbText((int)65280));
        StringUtilTest.assertEquals((String)"#ffffff", (String)StringUtil.toRgbText((int)0xFFFFFF));
        StringUtilTest.assertEquals((String)"#ffffff", (String)StringUtil.toRgbText((int)0x100000E));
    }

    public void testIsBlank() {
        StringUtilTest.assertTrue((boolean)StringUtil.isBlank(null));
        StringUtilTest.assertTrue((boolean)StringUtil.isBlank((String)""));
        StringUtilTest.assertTrue((boolean)StringUtil.isBlank((String)"   "));
        StringUtilTest.assertFalse((boolean)StringUtil.isBlank((String)" abc d ef  "));
    }

    public void testIsEmpty() {
        StringUtilTest.assertTrue((boolean)StringUtil.isEmpty(null));
        StringUtilTest.assertTrue((boolean)StringUtil.isEmpty((String)""));
        StringUtilTest.assertFalse((boolean)StringUtil.isEmpty((String)"   "));
        StringUtilTest.assertFalse((boolean)StringUtil.isEmpty((String)" abc d ef  "));
    }

    public void testDoubleToString() {
        StringUtilTest.assertEquals((String)"123456.789", (String)StringUtil.doubleToString((double)123456.7890123, (int)3));
        StringUtilTest.assertEquals((String)"1234567.89", (String)StringUtil.doubleToString((double)1234567.890123, (int)3));
        StringUtilTest.assertEquals((String)"12345678.901", (String)StringUtil.doubleToString((double)1.234567890123E7, (int)3));
        StringUtilTest.assertEquals((String)"123456789.012", (String)StringUtil.doubleToString((double)1.234567890123E8, (int)3));
        StringUtilTest.assertEquals((String)"1234567890.123", (String)StringUtil.doubleToString((double)1.234567890123E9, (int)3));
        StringUtilTest.assertEquals((String)"12345678901.23", (String)StringUtil.doubleToString((double)1.234567890123E10, (int)3));
        StringUtilTest.assertEquals((String)"1234567890123", (String)StringUtil.doubleToString((double)1.234567890123E12, (int)3));
        StringUtilTest.assertEquals((String)"1234567890123.457", (String)StringUtil.doubleToString((double)1.2345678901234568E12, (int)3));
        StringUtilTest.assertEquals((String)"12345678901234.568", (String)StringUtil.doubleToString((double)1.2345678901234568E13, (int)3));
        StringUtilTest.assertEquals((String)"123456789012345.67", (String)StringUtil.doubleToString((double)1.2345678901234567E14, (int)3));
        StringUtilTest.assertEquals((String)"1234567890123456.8", (String)StringUtil.doubleToString((double)1.2345678901234568E15, (int)3));
        StringUtilTest.assertEquals((String)"12345678901234568", (String)StringUtil.doubleToString((double)1.2345678901234568E16, (int)3));
        StringUtilTest.assertEquals((String)"123456789012345680", (String)StringUtil.doubleToString((double)1.2345678901234568E17, (int)3));
        StringUtilTest.assertEquals((String)"123456", (String)StringUtil.doubleToString((double)123456.0, (int)0));
        StringUtilTest.assertEquals((String)"123456", (String)StringUtil.doubleToString((double)123456.0, (int)3));
        StringUtilTest.assertEquals((String)"123457", (String)StringUtil.doubleToString((double)123456.7890123, (int)0));
        StringUtilTest.assertEquals((String)"123457", (String)StringUtil.doubleToString((double)123456.7890123, (int)-1));
        StringUtilTest.assertEquals((String)"123000", (String)StringUtil.doubleToString((double)123000.0, (int)3));
        StringUtilTest.assertEquals((String)"1234560", (String)StringUtil.doubleToString((double)1234560.0, (int)3));
        StringUtilTest.assertEquals((String)"123.456", (String)StringUtil.doubleToString((double)123.456, (int)3));
        StringUtilTest.assertEquals((String)"123.457", (String)StringUtil.doubleToString((double)123.45678, (int)3));
        StringUtilTest.assertEquals((String)"123.456", (String)StringUtil.doubleToString((double)123.456, (int)10));
        StringUtilTest.assertEquals((String)"0.00001235", (String)StringUtil.doubleToString((double)1.235E-5, (int)10));
        StringUtilTest.assertEquals((String)"0.0021", (String)StringUtil.doubleToString((double)0.0021, (int)10));
        StringUtilTest.assertEquals((String)"0.0005678", (String)StringUtil.doubleToString((double)5.678E-4, (int)10));
        StringUtilTest.assertEquals((String)"0.001", (String)StringUtil.doubleToString((double)5.678E-4, (int)3));
    }

    public void testIsEqual() {
        StringUtilTest.assertTrue((boolean)StringUtil.isEqual(null, null));
        StringUtilTest.assertFalse((boolean)StringUtil.isEqual(null, (String)"abc"));
        StringUtilTest.assertTrue((boolean)StringUtil.isEqual((String)"abc", (String)"abc"));
        StringUtilTest.assertFalse((boolean)StringUtil.isEqual((String)"abcd", (String)"abc"));
        StringUtilTest.assertFalse((boolean)StringUtil.isEqual((String)"Abc", (String)"abc"));
    }

    public void testIsEqualIgnoreCase() {
        StringUtilTest.assertTrue((boolean)StringUtil.isEqualIgnoreCase(null, null));
        StringUtilTest.assertFalse((boolean)StringUtil.isEqualIgnoreCase(null, (String)"abc"));
        StringUtilTest.assertTrue((boolean)StringUtil.isEqualIgnoreCase((String)"abc", (String)"abc"));
        StringUtilTest.assertFalse((boolean)StringUtil.isEqualIgnoreCase((String)"abcd", (String)"abc"));
        StringUtilTest.assertTrue((boolean)StringUtil.isEqualIgnoreCase((String)"Abc", (String)"abc"));
    }

    public void testExtractFileName() {
        StringUtilTest.assertEquals((String)"abc", (String)StringUtil.extractFileName((String)"c:\\home\\abc.xml"));
        StringUtilTest.assertEquals((String)"abc", (String)StringUtil.extractFileName((String)"c:\\home\\abc"));
        StringUtilTest.assertEquals((String)"abc", (String)StringUtil.extractFileName((String)"/home/user/abc.xml"));
        StringUtilTest.assertEquals((String)"abc", (String)StringUtil.extractFileName((String)"/home/user/abc"));
        StringUtilTest.assertEquals((String)"abc", (String)StringUtil.extractFileName((String)"/home/user.cliff/abc.xml"));
        StringUtilTest.assertEquals((String)"abc", (String)StringUtil.extractFileName((String)"/home/user.cliff/abc"));
    }

    public void testTrimQuotes() {
        StringUtilTest.assertEquals((String)"abc.bca", (String)StringUtil.trimQuotes((String)"\"abc.bca\""));
        StringUtilTest.assertEquals((String)"ab\"c.bca", (String)StringUtil.trimQuotes((String)"\"ab\"c.bca\""));
        StringUtilTest.assertEquals((String)"\"abc.bca", (String)StringUtil.trimQuotes((String)"\"abc.bca"));
        StringUtilTest.assertEquals((String)"abc.bca\"", (String)StringUtil.trimQuotes((String)"abc.bca\""));
    }
}

