/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.format;

import java.text.ParseException;
import junit.framework.TestCase;
import org.eclipse.birt.core.format.StringFormatter;
import org.junit.Test;

public class StringFormatterTest
extends TestCase {
    @Test
    public void testApplyPattern() {
        StringFormatter sampleStr = new StringFormatter();
        sampleStr.applyPattern("@@@@&&@@@<<<>>>!@@@&>");
        StringFormatterTest.assertEquals((String)"@@@@&&@@@<<<>>>!@@@&>", (String)sampleStr.getPattern());
    }

    @Test
    public void testFormat() {
        StringFormatter sampleStr = new StringFormatter();
        StringFormatterTest.assertEquals((String)"", (String)sampleStr.getPattern());
        sampleStr.applyPattern("@@@@");
        StringFormatterTest.assertEquals((String)"@@@@", (String)sampleStr.getPattern());
        StringFormatterTest.assertEquals((String)"1234fggggg", (String)sampleStr.format("1234fggggg"));
        sampleStr.applyPattern("@@@@!");
        StringFormatterTest.assertEquals((String)"1234fggggg", (String)sampleStr.format("1234fggggg"));
        sampleStr.applyPattern("@@@@!");
        StringFormatterTest.assertEquals((String)"123 ", (String)sampleStr.format("123"));
        sampleStr.applyPattern("@@@@!!!");
        StringFormatterTest.assertEquals((String)"123 ", (String)sampleStr.format("123"));
        sampleStr.applyPattern("@@@@");
        StringFormatterTest.assertEquals((String)"123456", (String)sampleStr.format("123456"));
        sampleStr.applyPattern("@@@@!");
        StringFormatterTest.assertEquals((String)"123456", (String)sampleStr.format("123456"));
        sampleStr.applyPattern("(@@)@@@");
        StringFormatterTest.assertEquals((String)"(  )123", (String)sampleStr.format("123"));
        sampleStr.applyPattern("&&&&!");
        StringFormatterTest.assertEquals((String)"123", (String)sampleStr.format("123"));
        StringFormatterTest.assertEquals((String)"123", (String)sampleStr.format(" 123  "));
        sampleStr.applyPattern("&&&&!^");
        StringFormatterTest.assertEquals((String)" 123  ", (String)sampleStr.format(" 123  "));
        sampleStr.applyPattern("&&&&&&");
        StringFormatterTest.assertEquals((String)"123", (String)sampleStr.format("123"));
        sampleStr.applyPattern("@@@&!");
        StringFormatterTest.assertEquals((String)"123", (String)sampleStr.format("123"));
        sampleStr.applyPattern("&@@@&!");
        StringFormatterTest.assertEquals((String)"123 ", (String)sampleStr.format("123"));
        sampleStr.applyPattern("@@@&");
        StringFormatterTest.assertEquals((String)" 123", (String)sampleStr.format("123"));
        sampleStr.applyPattern("@@@@@aaa!");
        StringFormatterTest.assertEquals((String)"123  aaa", (String)sampleStr.format("123"));
        sampleStr.applyPattern("@@aaa!");
        StringFormatterTest.assertEquals((String)"12aaa3", (String)sampleStr.format("123"));
        sampleStr.applyPattern("@@aaa&&&!");
        StringFormatterTest.assertEquals((String)"12aaa3", (String)sampleStr.format("123"));
        sampleStr.applyPattern("@@@@@aaa>!");
        StringFormatterTest.assertEquals((String)"123  aaa", (String)sampleStr.format("123"));
        sampleStr.applyPattern("@@@@<!");
        StringFormatterTest.assertEquals((String)"1234fggggg", (String)sampleStr.format("1234fggggg"));
        sampleStr.applyPattern("@@@@<!");
        StringFormatterTest.assertEquals((String)"1234fggggg", (String)sampleStr.format("1234fggGgG"));
        sampleStr.applyPattern("@@@@>!");
        StringFormatterTest.assertEquals((String)"1234FGGGGG", (String)sampleStr.format("1234fggggg"));
        sampleStr.applyPattern("@@@@&&&>!");
        StringFormatterTest.assertEquals((String)"1234FGGGGG", (String)sampleStr.format("1234fggggg"));
        sampleStr.applyPattern("@@@@&&@@@<<<>>>@@@&>");
        StringFormatterTest.assertEquals((String)"   1234FGGGGG", (String)sampleStr.format("1234fggggg"));
        sampleStr.applyPattern("!");
        StringFormatterTest.assertEquals((String)"123", (String)sampleStr.format("123"));
        sampleStr.applyPattern("");
        StringFormatterTest.assertEquals((String)"123", (String)sampleStr.format("123"));
        sampleStr.applyPattern(">");
        StringFormatterTest.assertEquals((String)"123AAA", (String)sampleStr.format("123aaA"));
        StringFormatterTest.assertEquals((String)"123AAA", (String)sampleStr.format("123aaA"));
        sampleStr.applyPattern("***\"!");
        StringFormatterTest.assertEquals((String)"***\"123", (String)sampleStr.format("123"));
        sampleStr.applyPattern("***&YY&&&!");
        StringFormatterTest.assertEquals((String)"***1YY23", (String)sampleStr.format("123"));
        sampleStr.applyPattern("***&YY@@@!");
        StringFormatterTest.assertEquals((String)"***1YY23 ", (String)sampleStr.format("123"));
        sampleStr.applyPattern("@@@-@@-@@@@!");
        StringFormatterTest.assertEquals((String)"600-00-03274", (String)sampleStr.format("6000003274"));
        sampleStr.applyPattern("@@@@@-@@@@!");
        StringFormatterTest.assertEquals((String)"94305-0110", (String)sampleStr.format("943050110"));
        StringFormatterTest.assertEquals((String)"94305-0110", (String)sampleStr.format("943050110   "));
        sampleStr.applyPattern("@@@@@-@@@@!^");
        StringFormatterTest.assertEquals((String)"94305-0110   ", (String)sampleStr.format("943050110   "));
        sampleStr.applyPattern("@@@@@-@@@@");
        StringFormatterTest.assertEquals((String)"94305-0110", (String)sampleStr.format("943050110"));
        StringFormatterTest.assertEquals((String)"94305-0110", (String)sampleStr.format("   943050110"));
        sampleStr.applyPattern("@@@@@-@@@@^");
        StringFormatterTest.assertEquals((String)"   94305-0110", (String)sampleStr.format("   943050110"));
        sampleStr.applyPattern("@@@@@!");
        StringFormatterTest.assertEquals((String)"94305", (String)sampleStr.format("94305"));
        sampleStr.applyPattern("@@@@@");
        StringFormatterTest.assertEquals((String)"94305", (String)sampleStr.format("94305"));
        sampleStr.applyPattern("(@@@)-@@@-@@@@!");
        StringFormatterTest.assertEquals((String)"(650)-837-2345,", (String)sampleStr.format("6508372345,"));
        sampleStr.applyPattern("(@@@)-@@@-@@@@");
        StringFormatterTest.assertEquals((String)"(650)-837-2345", (String)sampleStr.format("6508372345"));
    }

    @Test
    public void testParser() throws Exception {
        StringFormatter sampleStr = new StringFormatter();
        StringFormatterTest.assertEquals((String)"", (String)sampleStr.getPattern());
        sampleStr.applyPattern("@@@@");
        StringFormatterTest.assertEquals((String)"1234fggggg", (String)sampleStr.parser("1234fggggg"));
        sampleStr.applyPattern("@@@@!");
        StringFormatterTest.assertEquals((String)"1234fggggg", (String)sampleStr.parser("1234fggggg"));
        sampleStr.applyPattern("@@@@!");
        StringFormatterTest.assertEquals((String)"123", (String)sampleStr.parser("123 "));
        sampleStr.applyPattern("@@@@!!!");
        StringFormatterTest.assertEquals((String)"123", (String)sampleStr.parser("123 "));
        sampleStr.applyPattern("@@@@");
        StringFormatterTest.assertEquals((String)"123456", (String)sampleStr.parser("123456"));
        sampleStr.applyPattern("@@@@!");
        StringFormatterTest.assertEquals((String)"123456", (String)sampleStr.parser("123456"));
        sampleStr.applyPattern("(@@)@@@");
        StringFormatterTest.assertEquals((String)"123", (String)sampleStr.parser("(  )123"));
        sampleStr.applyPattern("(&&)@@@");
        StringFormatterTest.assertEquals((String)"  123", (String)sampleStr.parser("(  )123"));
        sampleStr.applyPattern("&&&&!");
        StringFormatterTest.assertEquals((String)"123 ", (String)sampleStr.parser("123"));
        sampleStr.applyPattern("&&&&&&");
        StringFormatterTest.assertEquals((String)"   123", (String)sampleStr.parser("123"));
        sampleStr.applyPattern("@@@&!");
        StringFormatterTest.assertEquals((String)"123 ", (String)sampleStr.parser("123"));
        sampleStr.applyPattern("&@@@&!");
        try {
            StringFormatterTest.assertEquals((String)"123 ", (String)sampleStr.parser("123"));
            assert (false);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        sampleStr.applyPattern("@@@&");
        StringFormatterTest.assertEquals((String)"123", (String)sampleStr.parser(" 123"));
        sampleStr.applyPattern("@@@@@aaa!");
        StringFormatterTest.assertEquals((String)"123", (String)sampleStr.parser("123  aaa"));
        sampleStr.applyPattern("@@@&&aaa!");
        StringFormatterTest.assertEquals((String)"123  ", (String)sampleStr.parser("123  aaa"));
        sampleStr.applyPattern("@@aaa!");
        StringFormatterTest.assertEquals((String)"123", (String)sampleStr.parser("12aaa3"));
        sampleStr.applyPattern("@@aaa&&&!");
        try {
            StringFormatterTest.assertEquals((String)"12aaa3", (String)sampleStr.parser("123"));
            assert (false);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        sampleStr.applyPattern("@@@@@aaa>!");
        StringFormatterTest.assertEquals((String)"123", (String)sampleStr.parser("123"));
        sampleStr.applyPattern("@@@@<!");
        StringFormatterTest.assertEquals((String)"1234fggggg", (String)sampleStr.parser("1234fggggg"));
        sampleStr.applyPattern("@@@@<!");
        StringFormatterTest.assertEquals((String)"1234fggGgG", (String)sampleStr.parser("1234fggGgG"));
        sampleStr.applyPattern("@@@@>!");
        StringFormatterTest.assertEquals((String)"1234fggggg", (String)sampleStr.parser("1234fggggg"));
        sampleStr.applyPattern("@@@@&&&>!");
        StringFormatterTest.assertEquals((String)"1234fggggg", (String)sampleStr.parser("1234fggggg"));
        sampleStr.applyPattern("@@@@&&@@@<<<>>>@@@&>");
        StringFormatterTest.assertEquals((String)"1234fggggg", (String)sampleStr.parser("1234fggggg"));
        sampleStr.applyPattern("!");
        StringFormatterTest.assertEquals((String)"123", (String)sampleStr.parser("123"));
        sampleStr.applyPattern("");
        StringFormatterTest.assertEquals((String)"123", (String)sampleStr.parser("123"));
        sampleStr.applyPattern(">");
        StringFormatterTest.assertEquals((String)"123aaA", (String)sampleStr.parser("123aaA"));
        sampleStr.applyPattern("***\"!");
        StringFormatterTest.assertEquals((String)"123", (String)sampleStr.parser("***\"123"));
        sampleStr.applyPattern("***&YY&&&!");
        StringFormatterTest.assertEquals((String)"123 ", (String)sampleStr.parser("***1YY23"));
        sampleStr.applyPattern("***&YY@@@!");
        StringFormatterTest.assertEquals((String)"123", (String)sampleStr.parser("***1YY23 "));
        sampleStr.applyPattern("***\"!^");
        StringFormatterTest.assertEquals((String)"123", (String)sampleStr.parser("***\"123"));
        sampleStr.applyPattern("***&YY&&&!^");
        StringFormatterTest.assertEquals((String)"123 ", (String)sampleStr.parser("***1YY23"));
        sampleStr.applyPattern("***&YY@@@!^");
        StringFormatterTest.assertEquals((String)"123", (String)sampleStr.parser("***1YY23 "));
        sampleStr.applyPattern("@@@-@@-@@@@!");
        StringFormatterTest.assertEquals((String)"6000003274", (String)sampleStr.parser("600-00-03274"));
        sampleStr.applyPattern("@@@@@-@@@@!");
        StringFormatterTest.assertEquals((String)"943050110", (String)sampleStr.parser("94305-0110"));
        sampleStr.applyPattern("@@@@@-@@@@");
        StringFormatterTest.assertEquals((String)"943050110", (String)sampleStr.parser("94305-0110"));
        sampleStr.applyPattern("@@@@@!");
        StringFormatterTest.assertEquals((String)"94305", (String)sampleStr.parser("94305"));
        sampleStr.applyPattern("@@@@@");
        StringFormatterTest.assertEquals((String)"94305", (String)sampleStr.parser("94305"));
        sampleStr.applyPattern("(@@@)-@@@-@@@@!");
        StringFormatterTest.assertEquals((String)"6508372345", (String)sampleStr.parser("(650)-837-2345"));
        sampleStr.applyPattern("(@@@)-@@@-@@@@");
        StringFormatterTest.assertEquals((String)"6508372345", (String)sampleStr.parser("(650)-837-2345"));
        sampleStr.applyPattern("(@@@)-@@@-@@@@!");
        StringFormatterTest.assertEquals((String)"65083723456", (String)sampleStr.parser("(650)-837-23456"));
        sampleStr.applyPattern("(@@@)-@@@-@@@@");
        StringFormatterTest.assertEquals((String)"346508372345", (String)sampleStr.parser("34(650)-837-2345"));
    }

    @Test
    public void testTrim() {
        StringFormatter sampleStr = new StringFormatter("Zip Code + 4");
        StringFormatterTest.assertEquals((String)"650837-2000", (String)sampleStr.format("6508372000"));
        StringFormatterTest.assertEquals((String)"650837-2000", (String)sampleStr.format(" 6508372000 "));
        StringFormatterTest.assertEquals((String)"     - 650", (String)sampleStr.format("650 "));
    }
}

