/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.eclipse.birt.core.archive.ArchiveUtil;
import org.eclipse.birt.core.archive.compound.ArchiveEntry;
import org.eclipse.birt.core.archive.compound.ArchiveFile;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class UpgradeArchiveTest
extends TestCase {
    @Before
    public void setUp() {
        new File("./utest/").mkdir();
    }

    @After
    public void tearDown() {
        new File("./utest/").delete();
    }

    @Test
    public void testUpgrade() throws IOException {
        this.saveResource("V2_1_1.rptarchive", "./utest/test.rptarchive");
        try (ArchiveFile af = new ArchiveFile("./utest/test.rptarchive", "rw+");){
            byte[] buffer = new byte[4096];
            int i = 0;
            while (i < 128) {
                ArchiveEntry entry = af.openEntry("/" + i);
                UpgradeArchiveTest.assertEquals((long)(i * 4), (long)entry.getLength());
                int j = 0;
                while (j < i) {
                    entry.read((long)(j * 4), buffer, 0, 4);
                    int v = ArchiveUtil.bytesToInteger((byte[])buffer);
                    UpgradeArchiveTest.assertEquals((int)j, (int)v);
                    ++j;
                }
                entry.close();
                ++i;
            }
        }
        new File("./utest/test.rptarchive").delete();
    }

    @Test
    public void testArchiveV1() throws IOException {
        this.saveResource("V2_1_1.rptarchive", "./utest/test.rptarchive");
        try (ArchiveFile af = new ArchiveFile("./utest/test.rptarchive", "r");){
            int v;
            int j;
            ArchiveEntry entry;
            byte[] buffer = new byte[4096];
            int i = 0;
            while (i < 128) {
                entry = af.openEntry("/" + i);
                UpgradeArchiveTest.assertEquals((long)(i * 4), (long)entry.getLength());
                j = 0;
                while (j < i) {
                    entry.read((long)(j * 4), buffer, 0, 4);
                    v = ArchiveUtil.bytesToInteger((byte[])buffer);
                    UpgradeArchiveTest.assertEquals((int)j, (int)v);
                    ++j;
                }
                entry.close();
                ++i;
            }
            i = 0;
            while (i < 128) {
                entry = af.openEntry("/" + i);
                UpgradeArchiveTest.assertEquals((long)(i * 4), (long)entry.getLength());
                j = 0;
                while (j < i) {
                    entry.read((long)(j * 4), buffer, 0, 4);
                    v = ArchiveUtil.bytesToInteger((byte[])buffer);
                    UpgradeArchiveTest.assertEquals((int)j, (int)v);
                    ++j;
                }
                entry.close();
                ++i;
            }
        }
        new File("./utest/test.rptarchive").delete();
    }

    protected void saveResource(String resource, String file) throws IOException {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(resource);
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            try (FileOutputStream out = new FileOutputStream(file);){
                byte[] buffer = new byte[4096];
                int size = in.read(buffer);
                do {
                    ((OutputStream)out).write(buffer, 0, size);
                } while ((size = in.read(buffer)) != -1);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

