/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.util;

import java.io.IOException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.util.SecurityUtil;

public class DeviceUtil {
    private static final ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.device.extension/util");

    private DeviceUtil() {
    }

    public static void openURL(String href) {
        if (href == null) {
            return;
        }
        if (((String)href).startsWith("file:")) {
            href = ((String)href).substring(5);
            while (((String)href).startsWith("/")) {
                href = ((String)href).substring(1);
            }
            href = "file:///" + (String)href;
        }
        final String localHref = href;
        Process p = null;
        try {
            p = SecurityUtil.execRuntimeCommand((Runtime)Runtime.getRuntime(), (String)("/usr/bin/open " + localHref));
        }
        catch (IOException e) {
            p = null;
        }
        if (p == null) {
            Thread launcher = new Thread(){

                @Override
                public void run() {
                    try {
                        String encodedLocalHref = DeviceUtil.urlEncodeForSpaces(localHref.toCharArray());
                        Process p = DeviceUtil.openWebBrowser(encodedLocalHref);
                        try {
                            if (p != null) {
                                p.waitFor();
                            }
                        }
                        catch (InterruptedException e) {
                            logger.log((Exception)e);
                        }
                    }
                    catch (IOException e) {
                        logger.log((Exception)e);
                    }
                }
            };
            launcher.start();
        }
    }

    private static String urlEncodeForSpaces(char[] input) {
        StringBuilder retu = new StringBuilder(input.length);
        int i = 0;
        while (i < input.length) {
            if (input[i] == ' ') {
                retu.append("%20");
            } else {
                retu.append(input[i]);
            }
            ++i;
        }
        return retu.toString();
    }

    private static Process openWebBrowser(String href) throws IOException {
        Process p = null;
        String webBrowser = null;
        try {
            webBrowser = "netscape";
            p = SecurityUtil.execRuntimeCommand((Runtime)Runtime.getRuntime(), (String)(webBrowser + "  " + href));
        }
        catch (IOException e) {
            p = null;
            webBrowser = "mozilla";
        }
        if (p == null) {
            try {
                p = SecurityUtil.execRuntimeCommand((Runtime)Runtime.getRuntime(), (String)(webBrowser + " " + href));
            }
            catch (IOException e) {
                p = null;
                webBrowser = "explorer";
            }
        }
        if (p == null) {
            try {
                p = SecurityUtil.execRuntimeCommand((Runtime)Runtime.getRuntime(), (String)(webBrowser + " " + href));
            }
            catch (IOException e) {
                p = null;
                throw e;
            }
        }
        return p;
    }
}

